/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api.importing;

import java.util.function.Function;
import java.util.regex.Pattern;
import org.eclipse.osee.define.api.importing.BlockField;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;

public class BlockFieldToken
extends NamedIdBase {
    protected final Pattern typeRegex;
    public final Pattern contentRegex;
    private final AttributeTypeToken oseeType;
    private final Function<BlockFieldToken, BlockField> parser;

    public BlockFieldToken(Long id, String name, String typeRegex, String contentRegex, Function<BlockFieldToken, BlockField> parser, AttributeTypeToken oseeType) {
        super(id, name);
        this.typeRegex = Pattern.compile(typeRegex);
        this.contentRegex = Pattern.compile(contentRegex, 32);
        this.oseeType = oseeType;
        this.parser = parser;
    }

    public static BlockFieldToken valueOf(long id, String name, String typeRegex, String contentRegex, Function<BlockFieldToken, BlockField> parser, AttributeTypeToken oseeType) {
        return new BlockFieldToken(id, name, typeRegex, contentRegex, parser, oseeType);
    }

    public static BlockFieldToken valueOf(long id, String name, String typeRegex, String contentRegex, Function<BlockFieldToken, BlockField> parser) {
        return BlockFieldToken.valueOf(id, name, typeRegex, contentRegex, parser, (AttributeTypeToken)AttributeTypeToken.SENTINEL);
    }

    public String getImportTypeName() {
        return this.getName();
    }

    public AttributeTypeToken getOseeType() {
        return this.oseeType;
    }

    public Pattern getTypeRegex() {
        return this.typeRegex;
    }

    public Pattern getContentRegex() {
        return this.contentRegex;
    }

    public BlockField getNewParser() {
        return this.parser.apply(this);
    }
}

