/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public final class OseeHierarchyComparator
implements Comparator<ArtifactReadable> {
    private final Map<Long, List<ArtifactReadable>> parentToChildrenCache;
    private final Map<Long, String> artPositionCache;
    private final ActivityLog activityLog;
    public Map<ArtifactReadable, String> errors;

    public OseeHierarchyComparator(ActivityLog activityLog) {
        this.activityLog = activityLog;
        this.parentToChildrenCache = new HashMap<Long, List<ArtifactReadable>>();
        this.artPositionCache = new HashMap<Long, String>();
        this.errors = new HashMap<ArtifactReadable, String>();
    }

    @Override
    public int compare(ArtifactReadable art1, ArtifactReadable art2) {
        try {
            int size;
            int toReturn = 0;
            String paragraph1 = this.getHierarchyPosition(art1);
            String paragraph2 = this.getHierarchyPosition(art2);
            int[] set1 = this.getParagraphIndices(paragraph1);
            int[] set2 = this.getParagraphIndices(paragraph2);
            int length1 = set1.length;
            int length2 = set2.length;
            int n = size = length1 < length2 ? length1 : length2;
            if (size == 0 && length1 != length2) {
                toReturn = length1 < length2 ? -1 : 1;
            } else {
                int index = 0;
                while (index < size) {
                    toReturn = Integer.compare(set1[index], set2[index]);
                    if (toReturn != 0) break;
                    ++index;
                }
                if (toReturn == 0) {
                    toReturn = length1 < length2 ? -1 : 1;
                }
            }
            return toReturn;
        }
        catch (Exception ex) {
            this.activityLog.createThrowableEntry(CoreActivityTypes.OSEE_ERROR, (Throwable)ex);
            return 1;
        }
    }

    public String getHierarchyPosition(ArtifactReadable art1) {
        if (this.artPositionCache.containsKey(art1.getId())) {
            return this.artPositionCache.get(art1.getId());
        }
        ArtifactReadable artifactCursor = art1;
        StringBuilder builder = new StringBuilder(20);
        while (artifactCursor.notEqual((Id)CoreArtifactTokens.DefaultHierarchyRoot)) {
            ArtifactReadable parent = null;
            try {
                parent = artifactCursor.getParent();
            }
            catch (OseeCoreException oseeCoreException) {
                this.errors.put(art1, "Hierarchy Index Unavailable");
                builder.insert(0, "0.");
                break;
            }
            if (parent == null) {
                this.errors.put(art1, "Not Connected to Root");
                builder.insert(0, "0.");
                break;
            }
            builder.insert(0, String.valueOf(this.getPosition(artifactCursor)) + ".");
            artifactCursor = parent;
        }
        String position = builder.substring(0, builder.length() - 1);
        this.artPositionCache.put(art1.getId(), position);
        return position;
    }

    private int getPosition(ArtifactReadable artifact) {
        int index;
        ArtifactReadable parent = artifact.getParent();
        List children = this.parentToChildrenCache.get(parent.getId());
        if (children == null) {
            children = parent.getChildren();
            this.parentToChildrenCache.put(parent.getId(), children);
        }
        if ((index = 1 + children.indexOf(artifact)) > 0) {
            return index;
        }
        throw new OseeStateException("[%s] is expected to be a child of [%s]", new Object[]{artifact, parent});
    }

    private int[] getParagraphIndices(String paragraph) {
        int[] paragraphs;
        if (Strings.isValid((String)paragraph)) {
            String[] values = paragraph.split("\\.");
            paragraphs = new int[values.length];
            int index = 0;
            while (index < values.length) {
                paragraphs[index] = Integer.parseInt(values[index].replace("-", ""));
                ++index;
            }
        } else {
            paragraphs = new int[]{};
        }
        return paragraphs;
    }
}

