/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.eclipse.help.search.ISearchDocument;

public class LuceneSearchDocument
implements ISearchDocument {
    private Document doc;

    public LuceneSearchDocument(Document document) {
        this.doc = document;
    }

    @Override
    public void setTitle(String title) {
        this.doc.add((IndexableField)new TextField("title", title, Field.Store.NO));
        this.doc.add((IndexableField)new TextField("exact_title", title, Field.Store.NO));
        this.doc.add((IndexableField)new StoredField("raw_title", title));
    }

    @Override
    public void setSummary(String summary) {
        this.doc.add((IndexableField)new StoredField("summary", summary));
    }

    @Override
    public void addContents(String contents) {
        this.doc.add((IndexableField)new TextField("contents", (Reader)new StringReader(contents)));
        this.doc.add((IndexableField)new TextField("exact_contents", (Reader)new StringReader(contents)));
    }

    @Override
    public void setHasFilters(boolean hasFilters) {
        this.doc.add((IndexableField)new StoredField("filters", Boolean.toString(hasFilters)));
    }

    public Document getDocument() {
        return this.doc;
    }

    @Override
    public void addContents(Reader contents, Reader exactContents) {
        this.doc.add((IndexableField)new TextField("contents", contents));
        this.doc.add((IndexableField)new TextField("exact_contents", exactContents));
    }
}

