/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util.result;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.result.Manipulations;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class XResultPageBase {
    protected String title;
    protected String html;
    protected final String id;
    protected String manipulatedHtml;
    protected Set<Manipulations> manipulations = new HashSet<Manipulations>();
    private int numWarnings = Integer.MAX_VALUE;
    private int numErrors = Integer.MAX_VALUE;

    public XResultPageBase(String title, String text) {
        this(title, text, Manipulations.ALL);
    }

    public XResultPageBase(String title, String html, Manipulations ... manipulations) {
        this.title = title;
        this.html = html;
        this.id = GUID.create();
        Manipulations[] manipulationsArray = manipulations;
        int n = manipulations.length;
        int n2 = 0;
        while (n2 < n) {
            Manipulations man = manipulationsArray[n2];
            switch (man) {
                case ALL: {
                    this.manipulations.add(Manipulations.GUID_CMD_HYPER);
                    this.manipulations.add(Manipulations.ERROR_RED);
                    this.manipulations.add(Manipulations.CONVERT_NEWLINES);
                    this.manipulations.add(Manipulations.WARNING_YELLOW);
                    this.manipulations.add(Manipulations.SUCCESS_GREEN);
                    break;
                }
                case HTML_MANIPULATIONS: {
                    this.manipulations.add(Manipulations.GUID_CMD_HYPER);
                    this.manipulations.add(Manipulations.ERROR_RED);
                    this.manipulations.add(Manipulations.WARNING_YELLOW);
                    this.manipulations.add(Manipulations.SUCCESS_GREEN);
                    break;
                }
                default: {
                    this.manipulations.add(man);
                }
            }
            ++n2;
        }
    }

    public int getNumWarnings() {
        if (this.numWarnings == Integer.MAX_VALUE) {
            if (this.manipulations.contains(Manipulations.WARNING_YELLOW)) {
                this.numWarnings = Lib.numOccurances((String)this.html, (String)"Warning:");
            }
            return 0;
        }
        return this.numWarnings;
    }

    public int getNumErrors() {
        if (this.numErrors == Integer.MAX_VALUE) {
            if (this.manipulations.contains(Manipulations.WARNING_YELLOW)) {
                this.numErrors = Lib.numOccurances((String)this.html, (String)"Error:");
            }
            return 0;
        }
        return this.numErrors;
    }

    public String getId() {
        return this.id;
    }

    public String getErrorWarningHtml() {
        int numErrors = this.getNumErrors();
        int numWarnings = this.getNumWarnings();
        return String.format("%s <b>Errors</b>: %d  <b>Warnings</b>: %d%s<br/><br/>", this.getErrorWarningColorPre(numErrors, numWarnings), numErrors, numWarnings, this.getErrorWarningColorPost(numErrors, numWarnings));
    }

    private String getErrorWarningColorPre(int numErrors, int numWarnings) {
        if (numErrors > 0) {
            return "<font color=\"red\">";
        }
        if (numWarnings > 0) {
            return "<font color=\"yellow\">";
        }
        return "";
    }

    private String getErrorWarningColorPost(int numErrors, int numWarnings) {
        if (numErrors > 0 || numWarnings > 0) {
            return "</font>";
        }
        return "";
    }

    public String getManipulatedHtml() {
        return this.getManipulatedHtml(this.manipulations);
    }

    public String handleIdCmdHyper(String str) {
        return str;
    }

    public String getManipulatedHtml(Collection<Manipulations> manipulations) {
        if (this.manipulatedHtml == null) {
            String str = String.valueOf(manipulations.contains(Manipulations.ERROR_WARNING_HEADER) ? this.getErrorWarningHtml() : "") + this.getText();
            if (manipulations.contains(Manipulations.RAW_HTML)) {
                str = AHTML.simplePage((String)str);
            } else {
                if (manipulations.contains(Manipulations.CONVERT_NEWLINES)) {
                    str = str.replaceAll("\n", AHTML.newline());
                }
                if (manipulations.contains(Manipulations.GUID_CMD_HYPER)) {
                    str = this.handleIdCmdHyper(str);
                }
                if (manipulations.contains(Manipulations.ERROR_RED)) {
                    str = str.replaceAll("Error:", AHTML.color((String)"red", (String)"Error:"));
                }
                if (manipulations.contains(Manipulations.WARNING_YELLOW)) {
                    str = str.replaceAll("Warning:", AHTML.color((String)"orange", (String)"Warning:"));
                }
                if (manipulations.contains(Manipulations.SUCCESS_GREEN)) {
                    str = str.replaceAll("Success:", "<b>" + AHTML.color((String)"05977F", (String)"Success:") + "</b>");
                }
            }
            this.manipulatedHtml = str;
        }
        return this.manipulatedHtml;
    }

    public String getText() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Set<Manipulations> getManipulations() {
        return this.manipulations;
    }

    public void setManipulations(Set<Manipulations> manipulations) {
        this.manipulations = manipulations;
    }

    public void setNumErrors(int numErrors) {
        this.numErrors = numErrors;
    }

    public void setNumWarnings(int numWarnings) {
        this.numWarnings = numWarnings;
    }
}

