/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.osee.framework.core.publishing.OptionType;
import org.eclipse.osee.framework.core.publishing.RendererMap;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.jdk.core.util.Message;

public class EnumRendererMap
implements RendererMap {
    private Map<RendererOption, Object> rendererOptions;

    private static Message appendKeyValueMessage(RendererOption key, Object value, Message message) {
        return message.indentInc().segment((CharSequence)"Key", (Object)key).segment((CharSequence)"Key Type", ((Object)((Object)key)).getClass()).segment((CharSequence)"Value", value).segment((CharSequence)"Expected Value Class", key.getType().getImplementationClass()).segment((CharSequence)"Value Class", (Object)(Objects.nonNull(value) ? value.getClass().getName() : "(value is null)"));
    }

    private static boolean checkKeyAndScalarValue(RendererOption key, Object value) {
        if (Objects.isNull(value)) {
            return false;
        }
        Class<?> implementationClass = key.getType().getImplementationClass();
        if (Objects.isNull(implementationClass)) {
            return true;
        }
        return implementationClass.isAssignableFrom(value.getClass());
    }

    private static boolean checkKeyAndValue(RendererOption key, Object value) {
        return key.getType().isCollection() ? EnumRendererMap.checkKeyAndVectorValue(key, value) : EnumRendererMap.checkKeyAndScalarValue(key, value);
    }

    private static boolean checkKeyAndVectorValue(RendererOption key, Object value) {
        return Objects.nonNull(value) && value instanceof Collection && !((Collection)value).stream().anyMatch(valueElement -> !key.getType().getImplementationClass().isAssignableFrom(valueElement.getClass()));
    }

    private static EnumMap<RendererOption, Object> copy(Map<RendererOption, Object> rendererMap) {
        EnumMap<RendererOption, Object> enumMap = new EnumMap<RendererOption, Object>(RendererOption.class);
        rendererMap.keySet().forEach(key -> {
            Object value = rendererMap.get(key);
            if (Objects.nonNull(value)) {
                if (!EnumRendererMap.checkKeyAndValue(key, value)) {
                    throw new IllegalArgumentException(new Message().title((CharSequence)"EnumRendererMap::copy, parameter \"value\" is not the correct class for the \"key\".").segment(message -> {
                        Message message2 = EnumRendererMap.appendKeyValueMessage(key, value, message);
                    }).toString());
                }
                enumMap.put((RendererOption)((Object)key), value);
            }
        });
        return enumMap;
    }

    private static EnumMap<RendererOption, Object> copy(RendererMap rendererMap) {
        EnumMap<RendererOption, Object> enumMap = new EnumMap<RendererOption, Object>(RendererOption.class);
        if (Objects.isNull(rendererMap)) {
            return enumMap;
        }
        rendererMap.keySet().forEach(key -> {
            Object value = rendererMap.getRendererOptionValue((RendererOption)((Object)key));
            if (!EnumRendererMap.checkKeyAndValue(key, value)) {
                throw new IllegalArgumentException(new Message().title((CharSequence)"EnumRendererMap::copy, parameter \"value\" is not the correct class for the \"key\".").segment(message -> {
                    Message message2 = EnumRendererMap.appendKeyValueMessage(key, value, message);
                }).toString());
            }
            enumMap.put((RendererOption)((Object)key), value);
        });
        return enumMap;
    }

    public EnumRendererMap() {
        this.rendererOptions = new EnumMap<RendererOption, Object>(RendererOption.class);
    }

    public EnumRendererMap(Map<RendererOption, Object> rendererMap) {
        this.rendererOptions = EnumRendererMap.copy(rendererMap);
    }

    public EnumRendererMap(Object ... objects) {
        this.rendererOptions = new EnumMap<RendererOption, Object>(RendererOption.class);
        if (Objects.isNull(objects) || objects.length == 0) {
            return;
        }
        if ((objects.length & 1) == 1) {
            throw new IllegalArgumentException(new Message().title((CharSequence)"EnumRendererMap::new, the number of parameters must no be odd.").indentInc().segment((CharSequence)"Parameters", (Object)objects).toString());
        }
        int i = 0;
        while (i < objects.length) {
            Object keyObject = objects[i];
            Object valueObject = objects[i + 1];
            if (!(keyObject instanceof RendererOption)) {
                throw new IllegalArgumentException("EnumRendererMap::new, the key parameter is not a \"RendererOption\".");
            }
            RendererOption key = (RendererOption)((Object)keyObject);
            if (!EnumRendererMap.checkKeyAndValue(key, valueObject)) {
                throw new IllegalArgumentException(new Message().title((CharSequence)"EnumRendererMap::new, a parameter \"value\" is not the correct class for the \"key\".").segment(message -> {
                    Message message2 = EnumRendererMap.appendKeyValueMessage(key, valueObject, message);
                }).toString());
            }
            this.rendererOptions.put(key, valueObject);
            i += 2;
        }
    }

    public EnumRendererMap(RendererMap rendererMap) {
        this.rendererOptions = EnumRendererMap.copy(rendererMap);
    }

    @Override
    public void free() {
        this.rendererOptions.clear();
        this.rendererOptions = null;
    }

    @Override
    public <T> T getRendererOptionValue(RendererOption key) {
        Objects.requireNonNull(key, "EnumRendererMap::getRendererOptionValue, parameter \"key\" cannot be null.");
        Object value = this.rendererOptions.get((Object)key);
        if (Objects.isNull(value)) {
            Object rv = key.getType().getDefaultValue();
            return (T)rv;
        }
        assert (EnumRendererMap.checkKeyAndValue(key, value)) : new Message().title((CharSequence)"EnumRendererMap::getRendererOptionValue, stored value is not the correct class for the \"key\".").segment(message -> {
            Message message2 = EnumRendererMap.appendKeyValueMessage(key, value, message);
        }).toString();
        Object castValue = value;
        return (T)castValue;
    }

    @Override
    public boolean isRendererOptionSet(RendererOption key) {
        Objects.requireNonNull(key, "EnumRendererMap::isRendererOptionSet, parameter \"key\" cannot be null.");
        return this.rendererOptions.containsKey((Object)key);
    }

    @Override
    public boolean isRendererOptionSetAndFalse(RendererOption key) {
        Objects.requireNonNull(key, "EnumRendererMap::isRendererOptionSetAndFalse, parameter \"key\" cannot be null.");
        if (!key.getType().equals((Object)OptionType.Boolean)) {
            throw new IllegalArgumentException(new Message().title((CharSequence)"EnumRendererMap::isRendererOptionSetAndFalse, parameter \"key\" is not for a Boolean option.").segment((CharSequence)"Key", (Object)key).toString());
        }
        Object value = this.rendererOptions.get((Object)key);
        if (Objects.isNull(value)) {
            return false;
        }
        assert (value instanceof Boolean) : new Message().title((CharSequence)"PublishingOptions::isRendererOptionSetAndFalse, the value associated with the \"key\" is not of the correct class.").segment(message -> {
            Message message2 = EnumRendererMap.appendKeyValueMessage(key, value, message);
        }).toString();
        Boolean castValue = (Boolean)value;
        return castValue == false;
    }

    @Override
    public boolean isRendererOptionSetAndTrue(RendererOption key) {
        Objects.requireNonNull(key, "EnumRendererMap::isRendererOptionSetAndTrue, parameter \"key\" cannot be null.");
        if (!key.getType().equals((Object)OptionType.Boolean)) {
            throw new IllegalArgumentException(new Message().title((CharSequence)"EnumRendererMap::isRendererOptionSetAndTrue, parameter \"key\" is not for a Boolean option.").segment((CharSequence)"Key", (Object)key).toString());
        }
        Object value = this.rendererOptions.get((Object)key);
        if (Objects.isNull(value)) {
            return false;
        }
        assert (value instanceof Boolean) : new Message().title((CharSequence)"PublishingOptions::isRendererOptionSetAndTrue, the value associated with the \"key\" is not of the correct class.").segment(message -> {
            Message message2 = EnumRendererMap.appendKeyValueMessage(key, value, message);
        }).toString();
        Boolean castValue = (Boolean)value;
        return castValue;
    }

    @Override
    public Set<RendererOption> keySet() {
        return Collections.unmodifiableSet(this.rendererOptions.keySet());
    }

    @Override
    public <T> T removeRendererOption(RendererOption key) {
        Objects.requireNonNull(key, "PublishingOptions::removeRendererOption, parameter \"key\" cannot be null.");
        Object value = this.rendererOptions.remove((Object)key);
        if (Objects.isNull(value)) {
            return null;
        }
        assert (EnumRendererMap.checkKeyAndValue(key, value)) : new Message().title((CharSequence)"PublishingOptions::removeRendererOption,  the value associated with the \"key\" is not of the correct class.").segment(message -> {
            Message message2 = EnumRendererMap.appendKeyValueMessage(key, value, message);
        }).toString();
        Object castValue = value;
        return (T)castValue;
    }

    @Override
    public <T> T setRendererOption(RendererOption key, T value) {
        Objects.requireNonNull(key, "PublishingOptions::setRendererOption, parameter \"key\" cannot be null.");
        Objects.requireNonNull(value, "PublishingOptions::setRendererOption, parameter \"value\" cannot be null.");
        if (!EnumRendererMap.checkKeyAndValue(key, value)) {
            throw new IllegalArgumentException(new Message().title((CharSequence)"PublishingOptions::setRendererOption, parameter \"value\" is not the correct class for the \"key\".").segment(message -> {
                Message message2 = EnumRendererMap.appendKeyValueMessage(key, value, message);
            }).toString());
        }
        Object priorValue = this.rendererOptions.put(key, value);
        if (Objects.isNull(priorValue)) {
            return null;
        }
        assert (EnumRendererMap.checkKeyAndValue(key, priorValue)) : new Message().title((CharSequence)"PublishingOptions::setRendererOption, the prior value associated with the \"key\" is not of the correct class.").segment(message -> {
            Message message2 = EnumRendererMap.appendKeyValueMessage(key, value, message);
        }).toString();
        Object castPriorValue = value;
        return castPriorValue;
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"PublishingOptions").indentInc().segmentMap((CharSequence)"renderOptions", this.rendererOptions).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }

    @Override
    public RendererMap unmodifiableRendererMap() {
        return new RendererMap(){

            @Override
            public void free() {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T getRendererOptionValue(RendererOption key) {
                return EnumRendererMap.this.getRendererOptionValue(key);
            }

            @Override
            public boolean isRendererOptionSet(RendererOption key) {
                return EnumRendererMap.this.isRendererOptionSet(key);
            }

            @Override
            public boolean isRendererOptionSetAndFalse(RendererOption key) {
                return EnumRendererMap.this.isRendererOptionSet(key);
            }

            @Override
            public boolean isRendererOptionSetAndTrue(RendererOption key) {
                return EnumRendererMap.this.isRendererOptionSetAndTrue(key);
            }

            @Override
            public Set<RendererOption> keySet() {
                return EnumRendererMap.this.keySet();
            }

            @Override
            public <T> T setRendererOption(RendererOption key, T value) {
                throw new UnsupportedOperationException();
            }

            public Message toMessage(int indent, Message message) {
                return EnumRendererMap.this.toMessage(indent, message);
            }

            @Override
            public RendererMap unmodifiableRendererMap() {
                return this;
            }

            @Override
            public <T> T removeRendererOption(RendererOption key) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

