/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access.object;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.access.object.AccessObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchToken;

public class ArtifactAccessObject
extends AccessObject
implements ArtifactId {
    private final ArtifactToken artifact;
    private static final Map<ArtifactToken, ArtifactAccessObject> cache = new HashMap<ArtifactToken, ArtifactAccessObject>();

    private ArtifactAccessObject(ArtifactToken artifact) {
        super(artifact);
        this.artifact = artifact;
    }

    @Override
    public BranchToken getBranch() {
        return this.artifact.getBranch();
    }

    @Override
    public void removeFromCache() {
        cache.remove(this.artifact);
    }

    @Override
    public Long getId() {
        return this.artifact.getId();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.artifact == null ? 0 : this.artifact.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactAccessObject other = (ArtifactAccessObject)obj;
        return !(this.artifact == null ? other.artifact != null : !this.artifact.equals(other.artifact));
    }

    public static ArtifactAccessObject valueOf(ArtifactToken artifact) {
        ArtifactAccessObject aao = cache.get(artifact);
        if (aao == null) {
            aao = new ArtifactAccessObject(artifact);
            cache.put(artifact, aao);
        }
        return aao;
    }

    public String toString() {
        return "Artifact " + this.artifact.toStringWithId();
    }

    public ArtifactToken getArtifact() {
        return this.artifact;
    }
}

