/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model.transaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.core.model.change.ChangeVersion;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.model.transaction.AddAttribute;
import org.eclipse.osee.orcs.rest.model.transaction.AddRelation;
import org.eclipse.osee.orcs.rest.model.transaction.ArtifactSortContainer;
import org.eclipse.osee.orcs.rest.model.transaction.ArtifactSortContainerCreate;
import org.eclipse.osee.orcs.rest.model.transaction.ArtifactSortContainerModify;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.AttributeTransfer;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;
import org.eclipse.osee.orcs.rest.model.transaction.DeleteAttribute;
import org.eclipse.osee.orcs.rest.model.transaction.DeleteRelation;
import org.eclipse.osee.orcs.rest.model.transaction.ModifyArtifact;
import org.eclipse.osee.orcs.rest.model.transaction.SetAttribute;
import org.eclipse.osee.orcs.rest.model.transaction.TransactionBuilderData;

public class TransactionBuilderDataFactory {
    private final OrcsApi orcsApi;
    private BranchId currentBranch;
    private TransactionId currentTransaction;
    private final HashMap<ArtifactId, ArtifactSortContainer> workingArtsById = new HashMap();
    private final ArrayList<ChangeItem> attributeChanges = new ArrayList();
    private final ArrayList<ChangeItem> relationChanges = new ArrayList();
    private final ArrayList<ChangeItem> tupleChanges = new ArrayList();
    private final XResultData results = new XResultData();

    public TransactionBuilderDataFactory(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public TransactionBuilderData loadFromChanges(TransactionId txId1, TransactionId txId2) {
        Objects.requireNonNull(txId1, "The given start transaction cannot be null");
        Objects.requireNonNull(txId2, "The given end transaction cannot be null");
        List changes = this.orcsApi.getTransactionFactory().compareTxs(txId1, txId2);
        TransactionBuilderData tbd = new TransactionBuilderData();
        for (ChangeItem change : changes) {
            if (!this.isGoodChange(change)) continue;
            ChangeType ct = change.getChangeType();
            if (ct.isArtifactChange()) {
                ChangeVersion net = change.getNetChange();
                ModificationType mt = net.getModType();
                if (ModificationType.NEW.equals(mt)) {
                    tbd = this.newArtifact(change, tbd);
                    continue;
                }
                if (ModificationType.MODIFIED.equals(mt)) {
                    tbd = this.modifyArtifact(change, tbd);
                    continue;
                }
                if (!ModificationType.DELETED.equals(mt)) continue;
                tbd = this.deleteArtifact(change, tbd);
                continue;
            }
            if (ct.isAttributeChange()) {
                this.attributeChanges.add(change);
                continue;
            }
            if (ct.isRelationChange()) {
                this.relationChanges.add(change);
                continue;
            }
            if (ct.isTupleChange()) {
                this.tupleChanges.add(change);
                continue;
            }
            if (!ct.equals((Object)ChangeType.Unknown)) continue;
            this.results.errorf("unknown change not handled: %s", new Object[]{change.toString()});
        }
        tbd = this.handleAttributeChanges(tbd);
        tbd = this.handleRelationChanges(tbd);
        tbd = this.handleTupleChanges(tbd);
        tbd.setBranch(this.currentBranch.getIdString());
        tbd.setTxComment(String.format("Set from JSON data that exports a change report from txId %s to txId %s", txId1.getIdString(), txId2.getIdString()));
        return tbd;
    }

    private boolean isGoodChange(ChangeItem change) {
        Boolean good = change.getIgnoreType().isNone() || change.getIgnoreType().isResurrected() || change.getIgnoreType().isAlreadyOnDestination();
        if (this.currentBranch == null) {
            this.currentBranch = change.getCurrentVersion().getTransactionToken().getBranch();
        } else {
            TransactionToken currentTransaction = change.getCurrentVersion().getTransactionToken();
            BranchId changeBranch = currentTransaction.getBranch();
            if (this.currentBranch != changeBranch) {
                this.results.errorf("branch switch during creation: was %s is %s", new Object[]{this.currentBranch, changeBranch});
            }
        }
        return good;
    }

    private TransactionBuilderData deleteArtifact(ChangeItem change, TransactionBuilderData tbd) {
        Long id;
        List<Long> artifacts = tbd.getDeleteArtifacts();
        if (artifacts == null) {
            artifacts = new ArrayList<Long>();
            tbd.setDeleteArtifacts(artifacts);
        }
        if (!artifacts.contains(id = change.getArtId().getId())) {
            artifacts.add(id);
        }
        return tbd;
    }

    private TransactionBuilderData modifyArtifact(ChangeItem change, TransactionBuilderData tbd) {
        ArtifactSortContainer artSort = this.addArtFromChange(change);
        List<ModifyArtifact> artifacts = tbd.getModifyArtifacts();
        if (artifacts == null) {
            artifacts = new ArrayList<ModifyArtifact>();
            tbd.setModifyArtifacts(artifacts);
        }
        ModifyArtifact modifiedArt = new ModifyArtifact();
        modifiedArt.setApplicabilityId(change.getCurrentVersion().getApplicabilityToken().getIdString());
        modifiedArt.setId(change.getArtId().getIdString());
        if (artSort instanceof ArtifactSortContainerModify) {
            ((ArtifactSortContainerModify)artSort).setModifyArt(modifiedArt);
        }
        return tbd;
    }

    private TransactionBuilderData newArtifact(ChangeItem change, TransactionBuilderData tbd) {
        this.addArtFromChange(change);
        List<CreateArtifact> artifacts = tbd.getCreateArtifacts();
        if (artifacts == null) {
            artifacts = new ArrayList<CreateArtifact>();
            tbd.setCreateArtifacts(artifacts);
        }
        return tbd;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ArtifactSortContainer addArtFromChange(ChangeItem change) {
        ArtifactSortContainer artSort;
        ArtifactId artId = change.getArtId();
        ModificationType modType = change.getNetChange().getModType();
        if (this.workingArtsById.containsKey(artId)) {
            return this.workingArtsById.get(artId);
        }
        if (this.currentBranch.isInvalid()) {
            this.results.error("current branch is invalid");
            throw new OseeCoreException("Branch in TransactionBuilderDataFactory invalid", new Object[0]);
        }
        ArtifactReadable art = this.orcsApi.getQueryFactory().fromBranch(this.currentBranch).fromTransaction(this.currentTransaction).andId(artId).asArtifact();
        if (!art.isValid()) {
            this.results.errorf("Can't find artifact for art id: ", new Object[]{artId.toString()});
            throw new OseeCoreException("Artifact for art id %s failed in query", new Object[]{artId.toString()});
        }
        if (modType.equals(ModificationType.NEW)) {
            if (change.getIgnoreType().isAlreadyOnDestination()) {
                artSort = new ArtifactSortContainerModify(art);
                this.workingArtsById.put((ArtifactId)art, artSort);
                return artSort;
            }
            ArtifactSortContainerCreate artSortCreate = new ArtifactSortContainerCreate(art);
            CreateArtifact createdArt = new CreateArtifact();
            createdArt.setId(art.getIdString());
            createdArt.setApplicabilityId(change.getCurrentVersion().getApplicabilityToken().getIdString());
            createdArt.setName(art.getName());
            createdArt.setTypeId(change.getItemTypeId().getIdString());
            artSortCreate.setCreateArtifact(createdArt);
            this.workingArtsById.put(artId, artSortCreate);
            return artSortCreate;
        }
        if (modType.equals(ModificationType.MODIFIED)) {
            artSort = new ArtifactSortContainerModify(art);
            ModifyArtifact modifiedArt = new ModifyArtifact();
            modifiedArt.setId(art.getIdString());
            modifiedArt.setApplicabilityId(change.getCurrentVersion().getApplicabilityToken().getIdString());
            this.workingArtsById.put((ArtifactId)art, artSort);
            return artSort;
        }
        artSort = new ArtifactSortContainer(art);
        this.workingArtsById.put(artId, artSort);
        return artSort;
    }

    private TransactionBuilderData handleAttributeChanges(TransactionBuilderData tbd) {
        for (ChangeItem change : this.attributeChanges) {
            ChangeVersion net = change.getNetChange();
            ModificationType mt = net.getModType();
            if (ModificationType.NEW.equals(mt)) {
                this.newAttribute(change, tbd);
                continue;
            }
            if (ModificationType.MODIFIED.equals(mt)) {
                this.modifyAttribute(change, tbd);
                continue;
            }
            if (!ModificationType.DELETED.equals(mt)) continue;
            this.deleteAttribute(change, tbd);
        }
        return this.fillData(tbd);
    }

    private TransactionBuilderData fillData(TransactionBuilderData tbd) {
        this.workingArtsById.forEach((artId, sortArt) -> this.addSortContent(tbd, (ArtifactSortContainer)sortArt));
        return tbd;
    }

    private void addSortContent(TransactionBuilderData tbd, ArtifactSortContainer sortArt) {
        if (sortArt instanceof ArtifactSortContainerCreate) {
            tbd.getCreateArtifacts().add(((ArtifactSortContainerCreate)sortArt).getCreateArt());
        } else if (sortArt instanceof ArtifactSortContainerModify) {
            tbd.getModifyArtifacts().add(((ArtifactSortContainerModify)sortArt).getModifyArt());
        } else {
            this.results.errorf("default sort container not handled %s", new Object[]{sortArt.getArtifact().getIdString()});
        }
    }

    private TransactionBuilderData deleteAttribute(ChangeItem change, TransactionBuilderData tbd) {
        ArtifactSortContainer sortArt = this.workingArtsById.get(change.getArtId());
        if (sortArt == null) {
            this.results.errorf("artifact not in change report: %s", new Object[]{change.getArtId()});
        } else if (sortArt instanceof ArtifactSortContainerCreate) {
            this.results.errorf("must not delete attribute in creation container: %s", new Object[]{change});
        } else if (sortArt instanceof ArtifactSortContainerModify) {
            ModifyArtifact art = ((ArtifactSortContainerModify)sortArt).getModifyArt();
            List<DeleteAttribute> attrs = art.getDeleteAttributes();
            if (attrs == null) {
                attrs = new ArrayList<DeleteAttribute>();
                art.setDeleteAttributes(attrs);
            }
            DeleteAttribute attr = new DeleteAttribute();
            attr.setTypeId(change.getItemTypeId().getIdString());
            attrs.add(attr);
        } else {
            this.results.errorf("incorrect default sort container for deleted attribute %s", new Object[]{change.getItemId().toString()});
        }
        return tbd;
    }

    private TransactionBuilderData modifyAttribute(ChangeItem change, TransactionBuilderData tbd) {
        ArtifactSortContainer sortArt = this.workingArtsById.get(change.getArtId());
        if (sortArt == null) {
            this.results.errorf("artifact not in change report: %s", new Object[]{change.getArtId()});
        } else if (sortArt instanceof ArtifactSortContainerCreate) {
            this.results.warningf("modify attribute in create artifact, change: %s", new Object[]{change});
            CreateArtifact art = ((ArtifactSortContainerCreate)sortArt).getCreateArt();
            List<Attribute> attrs = art.getAttributes();
            if (attrs == null) {
                attrs = new ArrayList<Attribute>();
                art.setAttributes(attrs);
            }
            boolean found = false;
            for (Attribute attr : attrs) {
                if (!attr.getTypeId().equals(change.getItemTypeId().getIdString())) continue;
                found = true;
            }
            if (!found) {
                attrs.add((Attribute)this.setupTransferArtifact(change, sortArt.getArtifact(), Attribute::new));
            }
        } else if (sortArt instanceof ArtifactSortContainerModify) {
            ModifyArtifact art = ((ArtifactSortContainerModify)sortArt).getModifyArt();
            List<SetAttribute> attrs = art.getSetAttributes();
            if (attrs == null) {
                attrs = new ArrayList<SetAttribute>();
                art.setSetAttributes(attrs);
            }
            boolean found = false;
            for (SetAttribute attr : attrs) {
                if (!attr.getTypeId().equals(change.getItemTypeId().getIdString())) continue;
                found = true;
            }
            if (!found) {
                attrs.add((SetAttribute)this.setupTransferArtifact(change, sortArt.getArtifact(), SetAttribute::new));
            }
        } else {
            this.results.errorf("incorrect default sort container for modified attribute %s", new Object[]{change.getItemId().toString()});
        }
        return tbd;
    }

    private AttributeTransfer setupTransferArtifact(ChangeItem change, ArtifactReadable art, Function<String, AttributeTransfer> attrTrans) {
        AttributeTypeGeneric attrType = this.orcsApi.tokenService().getAttributeType(change.getItemTypeId().getId());
        AttributeTransfer item = attrTrans.apply(attrType.getIdString());
        if (attrType.isDate()) {
            List dates = art.getAttributeValues((AttributeTypeToken)attrType);
            item.setValue(Arrays.asList(Long.valueOf(((Date)dates.get(0)).getTime()).toString()));
        } else {
            if (attrType.isInputStream()) {
                throw new OseeCoreException("Not handling Binary Data", new Object[0]);
            }
            item.setValue(art.fetchAttributesAsStringList((AttributeTypeToken)attrType));
        }
        return item;
    }

    private TransactionBuilderData newAttribute(ChangeItem change, TransactionBuilderData tbd) {
        ArtifactSortContainer sortArt = this.workingArtsById.get(change.getArtId());
        if (sortArt == null) {
            this.results.errorf("artifact not in change report: %s", new Object[]{change.getArtId()});
        } else if (sortArt instanceof ArtifactSortContainerCreate) {
            CreateArtifact art = ((ArtifactSortContainerCreate)sortArt).getCreateArt();
            List<Attribute> attrs = art.getAttributes();
            if (attrs == null) {
                attrs = new ArrayList<Attribute>();
                art.setAttributes(attrs);
            }
            boolean found = false;
            for (Attribute attr : attrs) {
                if (!attr.getTypeId().equals(change.getItemTypeId().getIdString())) continue;
                found = true;
            }
            if (!found) {
                attrs.add((Attribute)this.setupTransferArtifact(change, sortArt.getArtifact(), Attribute::new));
            }
        } else if (sortArt instanceof ArtifactSortContainerModify) {
            ModifyArtifact art = ((ArtifactSortContainerModify)sortArt).getModifyArt();
            List<AddAttribute> attrs = art.getAddAttributes();
            if (attrs == null) {
                attrs = new ArrayList<AddAttribute>();
                art.setAddAttributes(attrs);
            }
            boolean found = false;
            for (AddAttribute attr : attrs) {
                if (!attr.getTypeId().equals(change.getItemTypeId().getIdString())) continue;
                found = true;
            }
            if (!found) {
                attrs.add((AddAttribute)this.setupTransferArtifact(change, sortArt.getArtifact(), AddAttribute::new));
            }
        } else {
            this.results.errorf("incorrect default sort container for modified attribute %s", new Object[]{change.getItemId().toString()});
        }
        return tbd;
    }

    private TransactionBuilderData handleRelationChanges(TransactionBuilderData tbd) {
        for (ChangeItem change : this.relationChanges) {
            ChangeVersion current = change.getCurrentVersion();
            ModificationType mt = current.getModType();
            if (ModificationType.NEW.equals(mt)) {
                tbd = this.newRelation(change, tbd);
                continue;
            }
            if (!ModificationType.DELETED.equals(mt)) continue;
            tbd = this.deleteRelation(change, tbd);
        }
        return tbd;
    }

    private TransactionBuilderData deleteRelation(ChangeItem change, TransactionBuilderData tbd) {
        List<DeleteRelation> rels = tbd.getDeleteRelations();
        if (rels == null) {
            rels = new ArrayList<DeleteRelation>();
            tbd.setDeleteRelations(rels);
        }
        DeleteRelation dr = new DeleteRelation();
        dr.setaArtId(change.getArtId().getIdString());
        dr.setbArtId(change.getArtIdB().toString());
        dr.setTypeId(change.getItemTypeId().getIdString());
        rels.add(dr);
        return tbd;
    }

    private TransactionBuilderData newRelation(ChangeItem change, TransactionBuilderData tbd) {
        List<AddRelation> rels = tbd.getAddRelations();
        if (rels == null) {
            rels = new ArrayList<AddRelation>();
            tbd.setAddRelations(rels);
        }
        AddRelation dr = new AddRelation();
        dr.setaArtId(change.getArtId().getIdString());
        dr.setbArtId(change.getArtIdB().toString());
        dr.setTypeId(change.getItemTypeId().getIdString());
        rels.add(dr);
        return tbd;
    }

    private TransactionBuilderData handleTupleChanges(TransactionBuilderData tbd) {
        for (ChangeItem change : this.tupleChanges) {
            this.results.errorf("tuple changes not handled for change: %s", new Object[]{change});
        }
        return tbd;
    }
}

