/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.internal.old;

import java.util.Collection;
import org.eclipse.osee.framework.messaging.EndpointReceive;
import org.eclipse.osee.framework.messaging.EndpointSend;
import org.eclipse.osee.framework.messaging.ExceptionHandler;
import org.eclipse.osee.framework.messaging.Message;
import org.eclipse.osee.framework.messaging.MessagingGateway;
import org.eclipse.osee.framework.messaging.ReceiveListener;
import org.eclipse.osee.framework.messaging.SendListener;
import org.eclipse.osee.framework.messaging.id.MessageId;
import org.eclipse.osee.framework.messaging.id.ProtocolId;
import org.eclipse.osee.framework.messaging.internal.old.ApplicationDistributer;
import org.eclipse.osee.framework.messaging.internal.old.EndpointReceiveCollection;
import org.eclipse.osee.framework.messaging.internal.old.EndpointSendCollection;
import org.eclipse.osee.framework.messaging.internal.old.MessageListenerCollection;

public class MessagingGatewayImpl
implements MessagingGateway,
ApplicationDistributer {
    private final MessageListenerCollection messageListeners = new MessageListenerCollection();
    private final EndpointReceiveCollection endpointReceivers = new EndpointReceiveCollection();
    private final EndpointSendCollection endpointSenders = new EndpointSendCollection();

    @Override
    public void addReceiveListener(MessageId messageId, ReceiveListener receiveListener) {
        this.messageListeners.addReceiveListener(messageId, receiveListener);
    }

    @Override
    public void addSendListener(MessageId messageId, SendListener sendListener) {
        this.messageListeners.addSendListener(messageId, sendListener);
    }

    @Override
    public void removeReceiveListener(MessageId messageId, ReceiveListener receiveListener) {
        this.messageListeners.removeReceiveListener(messageId, receiveListener);
    }

    @Override
    public void removeSendListener(MessageId messageId, SendListener sendListener) {
        this.messageListeners.removeSendListener(messageId, sendListener);
    }

    @Override
    public void distribute(Message message) {
        this.messageListeners.notifyReceiveListeners(message);
    }

    @Override
    public boolean bind(EndpointReceive endpoint) {
        if (this.endpointReceivers.add(endpoint)) {
            endpoint.onBind(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean unbind(EndpointReceive endpoint) {
        endpoint.onUnbind(this);
        return this.endpointReceivers.remove(endpoint);
    }

    @Override
    public Collection<EndpointReceive> getReceiveEndpoints() {
        return this.endpointReceivers.getAll();
    }

    @Override
    public boolean bind(EndpointSend endpoint) {
        return this.endpointSenders.add(endpoint);
    }

    @Override
    public boolean unbind(EndpointSend endpoint) {
        return this.endpointSenders.remove(endpoint);
    }

    @Override
    public boolean bindSendProtocol(ProtocolId protocolId, EndpointSend endpoint) {
        return this.endpointSenders.bind(protocolId, endpoint);
    }

    @Override
    public boolean unbindSendProtocol(ProtocolId protocolId, EndpointSend endpoint) {
        return this.endpointSenders.unbind(protocolId, endpoint);
    }

    @Override
    public boolean bindSendMessage(MessageId messageId, ProtocolId protocolId) {
        return this.endpointSenders.bind(messageId, protocolId);
    }

    @Override
    public boolean unbindSendMessage(MessageId messageId, ProtocolId protocolId) {
        return this.endpointSenders.unbind(messageId, protocolId);
    }

    @Override
    public Collection<EndpointSend> getSendEndpoints() {
        return this.endpointSenders.getAll();
    }

    @Override
    public void send(Message message, ExceptionHandler exceptionHandler) {
        EndpointSend sender = this.endpointSenders.get(message.getId());
        if (sender == null) {
            String errorMessage = String.format("No registered senders for messageId[%s].", message.getId().toString());
            exceptionHandler.handleException(new Exception(errorMessage));
        } else {
            sender.send(message, exceptionHandler);
        }
    }

    @Override
    public void dispose() {
        this.messageListeners.dispose();
        this.endpointReceivers.dispose();
        this.endpointSenders.dispose();
    }
}

