/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.internal.activemq;

import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.command.ActiveMQDestination;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.messaging.OseeMessagingListener;
import org.eclipse.osee.framework.messaging.ReplyConnection;
import org.eclipse.osee.framework.messaging.internal.Activator;
import org.eclipse.osee.framework.messaging.internal.ConsoleDebugSupport;
import org.eclipse.osee.framework.messaging.internal.ServiceUtility;
import org.eclipse.osee.framework.messaging.internal.activemq.ActiveMqUtil;
import org.eclipse.osee.framework.messaging.internal.activemq.ReplyConnectionActiveMqImpl;

class ActiveMqMessageListenerWrapper
implements MessageListener {
    private final OseeMessagingListener listener;
    private final MessageProducer producer;
    private final Session session;
    private final ActiveMqUtil activeMqUtil;
    private final ExecutorService executor;

    ActiveMqMessageListenerWrapper(ActiveMqUtil activeMqUtil, MessageProducer producer, Session session, OseeMessagingListener listener) {
        this.producer = producer;
        this.session = session;
        this.listener = listener;
        this.activeMqUtil = activeMqUtil;
        this.executor = Executors.newSingleThreadExecutor();
    }

    public void onMessage(Message jmsMessage) {
        ConsoleDebugSupport support = null;
        try {
            support = ServiceUtility.getConsoleDebugSupport();
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Get Bundle is null");
        }
        try {
            Destination destReply;
            if (support != null) {
                if (support.getPrintReceives()) {
                    System.out.println(new Date() + " : " + jmsMessage.getJMSMessageID());
                    System.out.println("MESSAGE:");
                    System.out.println(jmsMessage.toString());
                    System.out.println("-----------------------------------------------------------------------------");
                }
                support.addReceive(jmsMessage);
            }
            if ((destReply = jmsMessage.getJMSReplyTo()) != null) {
                ActiveMQDestination dest = (ActiveMQDestination)jmsMessage.getJMSDestination();
                String correlationId = dest.getPhysicalName();
                ReplyConnectionActiveMqImpl replyConnectionActiveMqImpl = new ReplyConnectionActiveMqImpl(this.activeMqUtil, this.session, this.producer, destReply, correlationId);
                this.process(jmsMessage, replyConnectionActiveMqImpl);
            } else {
                this.process(jmsMessage, new ReplyConnectionActiveMqImpl());
            }
        }
        catch (JMSException ex) {
            OseeLog.log(ActiveMqMessageListenerWrapper.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(ActiveMqMessageListenerWrapper.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    OseeMessagingListener getListener() {
        return this.listener;
    }

    private void process(Message message, ReplyConnection replyConnection) {
        this.executor.submit(new ListenerProcessRunnable(message, replyConnection));
    }

    class ListenerProcessRunnable
    implements Runnable {
        private final Message message;
        private final ReplyConnection replyConnection;

        public ListenerProcessRunnable(Message message, ReplyConnection replyConnection) {
            this.message = message;
            this.replyConnection = replyConnection;
        }

        @Override
        public void run() {
            try {
                HashMap<String, Object> headers = new HashMap<String, Object>();
                Enumeration propertyNames = this.message.getPropertyNames();
                if (propertyNames != null) {
                    while (propertyNames.hasMoreElements()) {
                        String name = (String)propertyNames.nextElement();
                        Object element = this.message.getObjectProperty(name);
                        headers.put(name, element);
                    }
                }
                if (ActiveMqMessageListenerWrapper.this.activeMqUtil.translateMessage(this.message, ActiveMqMessageListenerWrapper.this.listener.getClazz()) != null) {
                    ActiveMqMessageListenerWrapper.this.listener.process(ActiveMqMessageListenerWrapper.this.activeMqUtil.translateMessage(this.message, ActiveMqMessageListenerWrapper.this.listener.getClazz()), headers, this.replyConnection);
                    OseeLog.log(Activator.class, (Level)Level.FINE, (String)String.format("recieved message %s - %s", this.message.getJMSDestination().toString(), this.message.toString()));
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Exception ", (Throwable)ex);
            }
        }
    }
}

