/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.messaging.ConnectionNode;
import org.eclipse.osee.framework.messaging.ConnectionNodeFactory;
import org.eclipse.osee.framework.messaging.MessageService;
import org.eclipse.osee.framework.messaging.NodeInfo;
import org.eclipse.osee.framework.messaging.internal.Activator;

public class MessageServiceImpl
implements MessageService {
    private static final String VM_URI = "vm://localhost?broker.persistent=false";
    private final NodeInfo defaultNode;
    private final Map<NodeInfo, ConnectionNode> connectionNodes = new ConcurrentHashMap<NodeInfo, ConnectionNode>();
    private final ConnectionNodeFactory factory;

    public MessageServiceImpl(ConnectionNodeFactory factory) {
        this.factory = factory;
        this.defaultNode = new NodeInfo("osee-jms", this.getDefaultURI());
    }

    private URI getDefaultURI() {
        URI defaultURI = null;
        String uri = OseeProperties.getOseeDefaultBrokerUri();
        if (uri == null) {
            uri = VM_URI;
        }
        try {
            defaultURI = new URI(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                defaultURI = new URI(VM_URI);
            }
            catch (URISyntaxException ex1) {
                OseeLog.log(MessageServiceImpl.class, (Level)Level.SEVERE, (Throwable)ex1);
            }
        }
        String message = "Default URI is null";
        if (defaultURI != null) {
            message = defaultURI.toASCIIString();
        }
        OseeLog.logf(Activator.class, (Level)Level.FINER, (String)"Default URI for message Service [%s]", (Object[])new Object[]{message});
        return defaultURI;
    }

    @Override
    public ConnectionNode getDefault() {
        return this.get(this.defaultNode);
    }

    @Override
    public Collection<NodeInfo> getAvailableConnections() {
        return new ArrayList<NodeInfo>(this.connectionNodes.keySet());
    }

    @Override
    public int size() {
        return this.connectionNodes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.connectionNodes.isEmpty();
    }

    @Override
    public ConnectionNode get(NodeInfo nodeInfo) {
        ConnectionNode node = this.connectionNodes.get(nodeInfo);
        if (node == null) {
            OseeLog.logf(Activator.class, (Level)Level.FINEST, (String)"going to create a new Connection Node for [%s]", (Object[])new Object[]{nodeInfo.toString()});
            node = this.factory.create(nodeInfo);
            this.connectionNodes.put(nodeInfo, node);
            OseeLog.logf(Activator.class, (Level)Level.FINE, (String)"Created a new Connection Node for [%s]", (Object[])new Object[]{nodeInfo.toString()});
        }
        return node;
    }

    void stop() {
        for (ConnectionNode node : this.connectionNodes.values()) {
            node.stop();
        }
    }
}

