/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.internal;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.jms.JMSException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.messaging.ConnectionListener;
import org.eclipse.osee.framework.messaging.ConnectionNode;
import org.eclipse.osee.framework.messaging.ConnectionNodeFailoverSupport;
import org.eclipse.osee.framework.messaging.MessageID;
import org.eclipse.osee.framework.messaging.OseeMessagingListener;
import org.eclipse.osee.framework.messaging.OseeMessagingStatusCallback;
import org.eclipse.osee.framework.messaging.internal.activemq.OseeExceptionListener;
import org.eclipse.osee.framework.messaging.services.internal.OseeMessagingStatusImpl;

public class FailoverConnectionNode
implements ConnectionNode,
Runnable {
    private final ConnectionNodeFailoverSupport connectionNode;
    private final List<SavedSubscribe> savedSubscribes;
    private final List<ConnectionListener> connectionListeners;
    private final ScheduledExecutorService scheduledExecutor;
    private boolean lastConnectedState = false;
    private final ScheduledFuture<?> itemToCancel;

    public FailoverConnectionNode(ConnectionNodeFailoverSupport connectionNode, ScheduledExecutorService scheduledExecutor, OseeExceptionListener exceptionListener) {
        this.connectionNode = connectionNode;
        exceptionListener.setListener(this);
        this.savedSubscribes = new CopyOnWriteArrayList<SavedSubscribe>();
        this.connectionListeners = new CopyOnWriteArrayList<ConnectionListener>();
        this.scheduledExecutor = scheduledExecutor;
        this.itemToCancel = this.scheduledExecutor.scheduleAtFixedRate(this, 60L, 15L, TimeUnit.SECONDS);
    }

    @Override
    public void send(MessageID messageId, Object message, OseeMessagingStatusCallback statusCallback) {
        this.send(messageId, message, null, statusCallback);
    }

    @Override
    public void send(MessageID messageId, Object message, Properties properties, OseeMessagingStatusCallback statusCallback) {
        this.attemptSmartConnect();
        if (this.lastConnectedState) {
            try {
                this.connectionNode.send(messageId, message, properties, statusCallback);
            }
            catch (OseeCoreException oseeCoreException) {
                this.stop();
                this.run();
                this.connectionNode.send(messageId, message, properties, statusCallback);
            }
        }
    }

    @Override
    public void send(MessageID messageId, Object message) {
        String errorMessage = String.format("Error sending message(%s)", messageId.getId());
        OseeMessagingStatusImpl defaultErrorHandler = new OseeMessagingStatusImpl(errorMessage, this.getClass());
        this.send(messageId, message, defaultErrorHandler);
    }

    private void attemptSmartConnect() {
        if (!this.lastConnectedState) {
            this.run();
        }
    }

    @Override
    public void stop() {
        this.itemToCancel.cancel(false);
        this.connectionNode.stop();
    }

    @Override
    public void subscribe(MessageID messageId, OseeMessagingListener listener, OseeMessagingStatusCallback statusCallback) {
        this.savedSubscribes.add(new SavedSubscribe(messageId, listener, statusCallback));
        this.attemptSmartConnect();
        this.connectionNode.subscribe(messageId, listener, statusCallback);
    }

    @Override
    public void subscribe(MessageID messageId, OseeMessagingListener listener, String selector, OseeMessagingStatusCallback statusCallback) {
        this.savedSubscribes.add(new SavedSubscribe(messageId, listener, statusCallback));
        this.attemptSmartConnect();
        this.connectionNode.subscribe(messageId, listener, selector, statusCallback);
    }

    @Override
    public void subscribe(MessageID messageId, OseeMessagingListener listener) {
        String errorMessage = String.format("Error subscribing message(%s)", messageId.getId());
        OseeMessagingStatusImpl defaultErrorHandler = new OseeMessagingStatusImpl(errorMessage, this.getClass());
        this.subscribe(messageId, listener, defaultErrorHandler);
    }

    @Override
    public boolean subscribeToReply(MessageID messageId, OseeMessagingListener listener) {
        return this.connectionNode.subscribeToReply(messageId, listener);
    }

    @Override
    public void unsubscribe(MessageID messageId, OseeMessagingListener listener) {
        String errorMessage = String.format("Error unsubscribing message(%s)", messageId.getId());
        OseeMessagingStatusImpl defaultErrorHandler = new OseeMessagingStatusImpl(errorMessage, this.getClass());
        this.unsubscribe(messageId, listener, defaultErrorHandler);
    }

    @Override
    public void unsubscribe(MessageID messageId, OseeMessagingListener listener, OseeMessagingStatusCallback statusCallback) {
        this.savedSubscribes.remove(new SavedSubscribe(messageId, listener, statusCallback));
        this.connectionNode.unsubscribe(messageId, listener, statusCallback);
    }

    @Override
    public boolean unsubscribteToReply(MessageID messageId, OseeMessagingListener listener) {
        this.connectionNode.unsubscribteToReply(messageId, listener);
        return false;
    }

    @Override
    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
        if (this.lastConnectedState) {
            connectionListener.connected(this);
        } else {
            connectionListener.notConnected(this);
        }
    }

    @Override
    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.remove(connectionListener);
    }

    private void subscribeToMessages() {
        for (SavedSubscribe subscribe : this.savedSubscribes) {
            if (subscribe.selector == null) {
                this.connectionNode.subscribe(subscribe.messageId, subscribe.listener, subscribe.statusCallback);
                continue;
            }
            this.connectionNode.subscribe(subscribe.messageId, subscribe.listener, subscribe.selector, subscribe.statusCallback);
        }
    }

    @Override
    public void run() {
        if (this.connectionNode.isConnected()) {
            this.connected();
        } else {
            try {
                this.connectionNode.start();
                this.subscribeToMessages();
                if (this.connectionNode.isConnected()) {
                    this.connected();
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(FailoverConnectionNode.class, (Level)Level.FINE, (Throwable)ex);
                this.notConnected();
            }
        }
    }

    private synchronized void connected() {
        if (!this.lastConnectedState) {
            this.lastConnectedState = true;
            this.notifyConnectionListenersConnected();
        }
    }

    private void notifyConnectionListenersConnected() {
        for (ConnectionListener listener : this.connectionListeners) {
            listener.connected(this);
        }
    }

    private synchronized void notConnected() {
        if (this.lastConnectedState) {
            this.notifyConnectionListenersNotConnected();
        }
        this.lastConnectedState = false;
    }

    private void notifyConnectionListenersNotConnected() {
        for (ConnectionListener listener : this.connectionListeners) {
            listener.notConnected(this);
        }
    }

    @Override
    public String getSenders() {
        return this.connectionNode.getSenders();
    }

    @Override
    public String getSubscribers() {
        return this.connectionNode.getSubscribers();
    }

    @Override
    public String getSummary() {
        return this.connectionNode.getSummary();
    }

    public void onException(JMSException ex) {
        this.connectionNode.stop();
    }

    private class SavedSubscribe {
        MessageID messageId;
        OseeMessagingListener listener;
        OseeMessagingStatusCallback statusCallback;
        String selector;

        public SavedSubscribe(MessageID messageId, OseeMessagingListener listener, OseeMessagingStatusCallback statusCallback) {
            this.messageId = messageId;
            this.listener = listener;
            this.statusCallback = statusCallback;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.listener == null ? 0 : this.listener.hashCode());
            result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
            result = 31 * result + (this.statusCallback == null ? 0 : this.statusCallback.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SavedSubscribe other = (SavedSubscribe)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.listener == null ? other.listener != null : !this.listener.equals(other.listener)) {
                return false;
            }
            if (this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId)) {
                return false;
            }
            return this.statusCallback != null || other.statusCallback == null;
        }

        private FailoverConnectionNode getOuterType() {
            return FailoverConnectionNode.this;
        }
    }
}

