/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import org.eclipse.osee.jdbc.JdbcDbType;
import org.eclipse.osee.jdbc.JdbcException;
import org.eclipse.osee.jdbc.internal.JdbcConnectionFactory;
import org.eclipse.osee.jdbc.internal.JdbcConnectionInfo;

public class JdbcConnectionFactoryManager {
    private final Map<String, JdbcConnectionFactory> factories;

    public JdbcConnectionFactoryManager(Map<String, JdbcConnectionFactory> factories) {
        this.factories = factories;
    }

    public MetaData getMetaData(JdbcConnectionInfo dbInfo) {
        JdbcConnectionFactory proxiedFactory = this.getFactory(dbInfo.getDriver());
        return this.getMetaData(proxiedFactory, dbInfo);
    }

    public JdbcConnectionFactory getFactory(String driver) {
        JdbcConnectionFactory factory = this.factories.get(driver);
        if (factory == null) {
            factory = new DefaultConnectionFactory(driver);
            this.factories.put(driver, factory);
        }
        return factory;
    }

    private MetaData getMetaData(JdbcConnectionFactory proxiedFactory, JdbcConnectionInfo dbInfo) {
        MetaData metaData = new MetaData();
        Connection connection = null;
        try {
            try {
                connection = proxiedFactory.getConnection(dbInfo);
                DatabaseMetaData metadata = connection.getMetaData();
                metaData.setTxIsolationLevelSupported(metadata.supportsTransactionIsolationLevel(2));
                metaData.setValidationQuery(JdbcDbType.getDbType(metadata).getValidationSql());
            }
            catch (SQLException ex) {
                throw JdbcException.newJdbcException(ex);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    throw JdbcException.newJdbcException(ex);
                }
            }
        }
        return metaData;
    }

    private static final class DefaultConnectionFactory
    implements JdbcConnectionFactory {
        private final String driver;

        public DefaultConnectionFactory(String driver) {
            this.driver = driver;
        }

        @Override
        public Connection getConnection(JdbcConnectionInfo dbInfo) {
            try {
                Class.forName(this.driver);
            }
            catch (Exception ex) {
                throw JdbcException.newJdbcException(ex, "Unable to find connection factory with driver [%s]", this.driver);
            }
            try {
                return DriverManager.getConnection(dbInfo.getUri(), dbInfo.getProperties());
            }
            catch (Exception ex) {
                throw JdbcException.newJdbcException(ex, "Unable to get connection for db - [%s]", dbInfo);
            }
        }

        @Override
        public String getDriver() {
            return this.driver;
        }
    }

    public static final class MetaData {
        private boolean isTxIsolationLevelSupported;
        private String validationQuery;

        public boolean isTxIsolationLevelSupported() {
            return this.isTxIsolationLevelSupported;
        }

        public void setTxIsolationLevelSupported(boolean isTxIsolationLevelSupported) {
            this.isTxIsolationLevelSupported = isTxIsolationLevelSupported;
        }

        public String getValidationQuery() {
            return this.validationQuery;
        }

        public void setValidationQuery(String validationQuery) {
            this.validationQuery = validationQuery;
        }
    }
}

