/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc;

import java.io.Closeable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcException;
import org.eclipse.osee.jdbc.internal.JdbcUtil;

public class OseePreparedStatement
implements Closeable {
    private final PreparedStatement preparedStatement;
    private final int batchIncrementSize;
    private final boolean autoClose;
    private final JdbcConnection connection;
    private int currentBatchSize;
    private int resultCount;
    private int size;

    public OseePreparedStatement(PreparedStatement preparedStatement, int batchIncrementSize, JdbcConnection connection, boolean autoClose) {
        this.preparedStatement = preparedStatement;
        this.batchIncrementSize = batchIncrementSize;
        this.autoClose = autoClose;
        this.connection = connection;
    }

    public void addToBatch(Object ... params) {
        int i = 0;
        while (i < params.length) {
            JdbcUtil.setInputParameterForStatement(this.preparedStatement, params[i], i + 1);
            ++i;
        }
        this.finishAddToBatch();
    }

    public void addToBatch(Object param1) {
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param1, 1);
        this.finishAddToBatch();
    }

    public void addToBatch(Object param1, Object param2) {
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param1, 1);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param2, 2);
        this.finishAddToBatch();
    }

    public void addToBatch(Object param1, Object param2, Object param3) {
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param1, 1);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param2, 2);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param3, 3);
        this.finishAddToBatch();
    }

    public void addToBatch(Object param1, Object param2, Object param3, Object param4) {
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param1, 1);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param2, 2);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param3, 3);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param4, 4);
        this.finishAddToBatch();
    }

    public void addToBatch(Object param1, Object param2, Object param3, Object param4, Object param5) {
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param1, 1);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param2, 2);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param3, 3);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param4, 4);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param5, 5);
        this.finishAddToBatch();
    }

    private void finishAddToBatch() {
        try {
            this.preparedStatement.addBatch();
            this.preparedStatement.clearParameters();
            ++this.currentBatchSize;
            ++this.size;
            if (this.currentBatchSize >= this.batchIncrementSize) {
                int[] updates = this.preparedStatement.executeBatch();
                this.resultCount += JdbcUtil.calculateBatchUpdateResults(updates);
                this.currentBatchSize = 0;
            }
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    public int execute() {
        try {
            if (this.currentBatchSize == 0) {
                int n = this.resultCount;
                return n;
            }
            int n = this.resultCount += JdbcUtil.calculateBatchUpdateResults(this.preparedStatement.executeBatch());
            return n;
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
        finally {
            this.close();
        }
    }

    public int size() {
        return this.size;
    }

    @Override
    public void close() {
        JdbcUtil.close(this.preparedStatement);
        if (this.autoClose) {
            this.connection.close();
        }
    }
}

