/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import javax.inject.Inject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.SashLayout;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;

public class SashRenderer
extends SWTPartRenderer {
    private static final int DEFAULT_WEIGHT = 5000;
    private int processedContent = 0;

    @Inject
    @Optional
    private void subscribeTopicOrientationChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/GenericTile/horizontal/*") Event event) {
        MUIElement element = (MUIElement)event.getProperty("ChangedElement");
        if (element.getRenderer() != this) {
            return;
        }
        this.forceLayout((MElementContainer<MUIElement>)((MElementContainer)element));
    }

    @Inject
    @Optional
    private void subscribeTopicSashWeightChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/containerData/*") Event event) {
        MUIElement element = (MUIElement)event.getProperty("ChangedElement");
        MElementContainer parent = element.getParent();
        if (parent.getRenderer() != this) {
            return;
        }
        this.forceLayout((MElementContainer<MUIElement>)parent);
    }

    /*
     * Unable to fully structure code
     */
    protected void forceLayout(MElementContainer<MUIElement> pscModel) {
        if (this.processedContent == 0) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            pscModel = pscModel.getParent();
lbl4:
            // 2 sources

            ** while (!(pscModel.getWidget() instanceof Composite))
        }
lbl5:
        // 1 sources

        s = (Composite)pscModel.getWidget();
        if (Platform.getOS().equals("win32")) {
            layout = s.getLayout();
            if (layout instanceof SashLayout && ((SashLayout)layout).layoutUpdateInProgress) {
                return;
            }
            s.layout(true, true);
        } else {
            s.requestLayout();
        }
    }

    public Object createWidget(MUIElement element, Object parent) {
        MElementContainer elementParent = element.getParent();
        if (elementParent == null && element.getCurSharedRef() != null) {
            elementParent = element.getCurSharedRef();
        }
        if (elementParent != null && elementParent.getRenderer() == this) {
            Rectangle newRect = new Rectangle(0, 0, 0, 0);
            if (parent instanceof Composite) {
                ((Composite)parent).addDisposeListener(e -> {
                    element.setWidget(null);
                    element.setRenderer(null);
                });
            }
            return newRect;
        }
        Composite sashComposite = null;
        MPartSashContainer psc = (MPartSashContainer)element;
        for (MPartSashContainerElement psce : psc.getChildren()) {
            if (!(psce instanceof MPartSashContainer) || !(psce.getWidget() instanceof Composite)) continue;
            sashComposite = (Composite)psce.getWidget();
            this.bindWidget((MUIElement)psce, new Rectangle(0, 0, 0, 0));
        }
        if (sashComposite == null) {
            sashComposite = new Composite((Composite)parent, 0);
        }
        sashComposite.setLayout((Layout)new SashLayout(sashComposite, element));
        return sashComposite;
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        SashRenderer.ensureLayoutWeight(element);
        this.forceLayout(parentElement);
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
        try {
            ++this.processedContent;
            super.processContents(container);
        }
        finally {
            --this.processedContent;
            if (this.processedContent == 0) {
                this.forceLayout(container);
            }
        }
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        this.forceLayout(parentElement);
    }

    public Object getUIContainer(MUIElement element) {
        MElementContainer parentElement = element.getParent();
        while (parentElement.getRenderer() == this && !(parentElement.getWidget() instanceof Composite)) {
            parentElement = parentElement.getParent();
        }
        if (parentElement.getWidget() instanceof Composite) {
            return parentElement.getWidget();
        }
        return null;
    }

    private static void ensureLayoutWeight(MUIElement element) {
        int weight = 5000;
        String info = element.getContainerData();
        if (info != null && info.length() > 0) {
            try {
                int value;
                weight = value = Integer.parseInt(info);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        element.setContainerData(Integer.toString(weight));
    }
}

