/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.plugin.core.server;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.internal.Activator;
import org.eclipse.osee.framework.plugin.core.server.ResourceFinder;
import org.osgi.framework.Bundle;

public class BundleResourceFinder
extends ResourceFinder {
    private final ArrayList<Bundle> bundles = new ArrayList();

    public BundleResourceFinder(String[] bundlenames) {
        int i = 0;
        while (i < bundlenames.length) {
            Bundle bundle = Platform.getBundle((String)bundlenames[i]);
            if (bundle != null) {
                this.bundles.add(Platform.getBundle((String)bundlenames[i]));
            } else {
                OseeLog.logf(Activator.class, (Level)Level.SEVERE, (String)"Unable to load bundle [ %s ].  This bundle was not added to the list in BundleResourceFinder.", (Object[])new Object[]{bundlenames[i]});
            }
            ++i;
        }
    }

    @Override
    public byte[] find(String path) throws IOException {
        int i = 0;
        while (i < this.bundles.size()) {
            URL url = this.bundles.get(i).getResource(path);
            if (url != null) {
                return this.getBytes(url.openStream());
            }
            ++i;
        }
        return null;
    }

    @Override
    public void dispose() {
        this.bundles.clear();
    }
}

