/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.core.internal.search.BranchCriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.BranchQueryBuilderImpl;
import org.eclipse.osee.orcs.search.BranchQuery;

public class BranchQueryImpl
extends BranchQueryBuilderImpl<BranchQuery>
implements BranchQuery {
    private final QueryEngine queryEngine;

    public BranchQueryImpl(QueryEngine queryEngine, BranchCriteriaFactory criteriaFactory, QueryData queryData) {
        super(criteriaFactory, queryData);
        this.queryEngine = queryEngine;
    }

    public ResultSet<Branch> getResults() {
        ArrayList branches = new ArrayList();
        this.query(branches);
        return ResultSets.newResultSet(branches);
    }

    public ResultSet<BranchToken> getResultsAsId() {
        ArrayList branches = new ArrayList();
        this.query(branches);
        return ResultSets.newResultSet(branches);
    }

    private void query(List<? super Branch> branches) {
        QueryData queryData = this.build();
        OptionsUtil.setLoadLevel(queryData.getOptions(), LoadLevel.ALL);
        this.queryEngine.runBranchQuery(queryData, branches);
    }

    public int getCount() {
        return this.queryEngine.getBranchCount(this.build());
    }

    public boolean exists() {
        return this.getCount() > 0;
    }

    public boolean isArchived(BranchId branchId) {
        return this.queryEngine.isArchived(branchId);
    }

    public BranchToken getOneOrSentinel() {
        ResultSet<Branch> branches = this.getResults();
        if (branches.size() == 1) {
            return (BranchToken)branches.iterator().next();
        }
        return BranchToken.SENTINEL;
    }

    public List<GammaId> getBranchCategoryGammaId(BranchId branchId, BranchCategoryToken category) {
        ArrayList<GammaId> branchCategories = new ArrayList<GammaId>();
        this.queryEngine.getBranchCategoryGammaIds(branchCategories::add, branchId, category);
        return branchCategories;
    }

    public List<BranchCategoryToken> getBranchCategories(BranchId branchId) {
        ArrayList<BranchCategoryToken> branchCategories = new ArrayList<BranchCategoryToken>();
        this.queryEngine.getBranchCategories(branchCategories::add, branchId);
        return branchCategories;
    }
}

