/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds.criteria;

import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.criteria.BranchCriteria;

public class CriteriaMapAssocArtToRelatedAttributes
extends Criteria
implements BranchCriteria {
    String value = "";
    BranchId relatedBranch = BranchId.SENTINEL;
    List<Pair<ArtifactTypeToken, AttributeTypeToken>> artAttrPairs;

    public CriteriaMapAssocArtToRelatedAttributes(String value, BranchId relatedBranch, List<Pair<ArtifactTypeToken, AttributeTypeToken>> artAttrPairs) {
        this.value = value;
        this.relatedBranch = relatedBranch;
        this.artAttrPairs = artAttrPairs;
    }

    @Override
    public void checkValid(Options options) {
        Conditions.checkExpressionFailOnTrue((this.value == null ? 1 : 0) != 0, (String)"Value cannot be null", (Object[])new Object[0]);
        Conditions.checkExpressionFailOnTrue((this.relatedBranch == null ? 1 : 0) != 0, (String)"Related branch cannot be null", (Object[])new Object[0]);
        Conditions.checkExpressionFailOnTrue((this.getArtAttrPairs() == null ? 1 : 0) != 0, (String)"Related Artifact Types/Attribute Types pairs cannot be null", (Object[])new Object[0]);
        Conditions.checkExpressionFailOnTrue((this.value == "" ? 1 : 0) != 0, (String)"value cannot be empty", (Object[])new Object[0]);
        Conditions.checkExpressionFailOnTrue((this.relatedBranch.getId() == BranchId.SENTINEL.getId() ? 1 : 0) != 0, (String)"Related branch cannot be sentinel", (Object[])new Object[0]);
        Conditions.checkExpressionFailOnTrue((this.getArtAttrPairs().size() == 0 ? 1 : 0) != 0, (String)"Related Artifact Types/Attribute Types pairs cannot be empty", (Object[])new Object[0]);
    }

    @Override
    public String toString() {
        return "CriteriaMapAssocArtToRelatedAttributes [value=" + this.value + "," + "relatedBranch=" + this.relatedBranch.getId() + "]";
    }

    public BranchId getRelatedBranch() {
        return this.relatedBranch;
    }

    public String getRelatedValue() {
        return this.value;
    }

    public List<Pair<ArtifactTypeToken, AttributeTypeToken>> getArtAttrPairs() {
        return this.artAttrPairs;
    }
}

