/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;

public class TableDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public TableDragSourceEffect(Table table) {
        super(table);
    }

    @Override
    public void dragFinished(DragSourceEvent event) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    @Override
    public void dragStart(DragSourceEvent event) {
        event.image = this.getDragSourceImage(event);
    }

    Image getDragSourceImage(DragSourceEvent event) {
        long[] model;
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        Table table = (Table)this.control;
        if (table.isListening(40) || table.isListening(42)) {
            return null;
        }
        long handle = table.handle;
        long selection = GTK.gtk_tree_view_get_selection(handle);
        long list = GTK.gtk_tree_selection_get_selected_rows(selection, model = null);
        if (list == 0L) {
            return null;
        }
        int count = Math.min(10, OS.g_list_length(list));
        long originalList = list;
        Display display = table.getDisplay();
        if (count == 1) {
            long path = OS.g_list_nth_data(list, 0);
            long icon = GTK.gtk_tree_view_create_row_drag_icon(handle, path);
            this.dragSourceImage = Image.gtk_new(display, 1, icon, 0L);
            GTK.gtk_tree_path_free(path);
        } else {
            long cairo;
            int width = 0;
            int height = 0;
            int[] w = new int[1];
            int[] h = new int[1];
            int[] yy = new int[count];
            int[] hh = new int[count];
            long[] icons = new long[count];
            GdkRectangle rect = new GdkRectangle();
            int i = 0;
            while (i < count) {
                long path = OS.g_list_data(list);
                GTK.gtk_tree_view_get_cell_area(handle, path, 0L, rect);
                icons[i] = GTK.gtk_tree_view_create_row_drag_icon(handle, path);
                switch (Cairo.cairo_surface_get_type(icons[i])) {
                    case 0: {
                        w[0] = Cairo.cairo_image_surface_get_width(icons[i]);
                        h[0] = Cairo.cairo_image_surface_get_height(icons[i]);
                        break;
                    }
                    case 3: {
                        w[0] = Cairo.cairo_xlib_surface_get_width(icons[i]);
                        h[0] = Cairo.cairo_xlib_surface_get_height(icons[i]);
                    }
                }
                width = Math.max(width, w[0]);
                height = rect.y + h[0] - yy[0];
                yy[i] = rect.y;
                hh[i] = h[0];
                list = OS.g_list_next(list);
                GTK.gtk_tree_path_free(path);
                ++i;
            }
            long surface = Cairo.cairo_image_surface_create(0, width, height);
            if (surface == 0L) {
                SWT.error(2);
            }
            if ((cairo = Cairo.cairo_create(surface)) == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_set_operator(cairo, 1);
            int i2 = 0;
            while (i2 < count) {
                Cairo.cairo_set_source_surface(cairo, icons[i2], 2.0, yy[i2] - yy[0] + 2);
                Cairo.cairo_rectangle(cairo, 0.0, yy[i2] - yy[0], width, hh[i2]);
                Cairo.cairo_fill(cairo);
                Cairo.cairo_surface_destroy(icons[i2]);
                ++i2;
            }
            Cairo.cairo_destroy(cairo);
            this.dragSourceImage = Image.gtk_new(display, 1, surface, 0L);
        }
        OS.g_list_free(originalList);
        return this.dragSourceImage;
    }
}

