/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.util.internal.dialog;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.util.internal.PatternFilter;
import org.eclipse.nebula.widgets.xviewer.util.internal.Result;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLib;
import org.eclipse.nebula.widgets.xviewer.util.internal.dialog.XCheckedFilteredTree;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class XCheckFilteredTreeDialog
extends MessageDialog {
    protected Label statusLabel;
    private Button okButton;
    private XCheckedFilteredTree treeViewer;
    private final PatternFilter patternFilter;
    private Object input;
    private final IContentProvider contentProvider;
    private final IBaseLabelProvider labelProvider;
    private Collection<? extends Object> initialSelections;
    private final ViewerSorter viewerSorter;

    public XCheckFilteredTreeDialog(String dialogTitle, String dialogMessage, PatternFilter patternFilter, IContentProvider contentProvider, IBaseLabelProvider labelProvider, ViewerSorter viewerSorter) {
        super(Display.getCurrent().getActiveShell(), dialogTitle, null, dialogMessage, 0, new String[]{XViewerText.get("button.ok"), XViewerText.get("button.cancel")}, 0);
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        this.patternFilter = patternFilter;
        this.viewerSorter = viewerSorter;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void createPreCustomArea(Composite parent) {
    }

    public Set<Object> getChecked() {
        if (this.getTreeViewer() == null) {
            return Collections.emptySet();
        }
        return this.getTreeViewer().getChecked();
    }

    public final void setInput(Object input) {
        this.input = input;
        if (this.treeViewer != null) {
            this.treeViewer.getViewer().setInput(input);
        }
    }

    public void setInitialSelections(Collection<? extends Object> initialSelections) {
        this.initialSelections = initialSelections;
        if (this.treeViewer != null) {
            this.treeViewer.setInitalChecked(initialSelections);
        }
    }

    public Object[] getResult() {
        if (this.treeViewer == null) {
            return new Object[0];
        }
        return this.treeViewer.getResult();
    }

    protected Control createCustomArea(Composite parent) {
        this.statusLabel = new Label(parent, 0);
        this.statusLabel.setForeground(Display.getCurrent().getSystemColor(3));
        this.updateStatusLabel();
        this.createPreCustomArea(parent);
        Composite aiComp = new Composite(parent, 0);
        aiComp.setLayout((Layout)XViewerLib.getZeroMarginLayout());
        aiComp.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new XCheckedFilteredTree(aiComp, 2858, this.patternFilter);
        this.treeViewer.getViewer().getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.getViewer().setContentProvider(this.contentProvider);
        this.treeViewer.getViewer().setLabelProvider(this.labelProvider);
        this.treeViewer.getViewer().setSorter(this.viewerSorter);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        this.treeViewer.getViewer().getTree().setLayoutData((Object)gd);
        this.treeViewer.getViewer().addSelectionChangedListener(event -> this.updateStatusLabel());
        if (this.input != null) {
            this.treeViewer.getViewer().setInput(this.input);
        }
        if (this.initialSelections != null) {
            this.treeViewer.setInitalChecked(this.initialSelections);
        }
        return parent;
    }

    protected void updateStatusLabel() {
        Result result = this.isComplete();
        if (result.isFalse()) {
            this.statusLabel.setText(result.getText());
        } else {
            this.statusLabel.setText("");
        }
        this.statusLabel.getParent().layout();
        this.updateButtons();
    }

    protected Control createButtonBar(Composite parent) {
        Control c = super.createButtonBar(parent);
        this.okButton = this.getButton(0);
        this.okButton.setEnabled(false);
        return c;
    }

    protected Result isComplete() {
        return Result.TrueResult;
    }

    private void updateButtons() {
        if (this.okButton != null) {
            this.okButton.setEnabled(this.isComplete().isTrue());
        }
    }

    public XCheckedFilteredTree getTreeViewer() {
        return this.treeViewer;
    }
}

