/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsWorkItemHook;
import org.eclipse.osee.ats.core.access.UserRelatedToAtsObjectSearch;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.access.ArtifactCheck;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsArtifactChecks
implements ArtifactCheck {
    private static final List<Long> Admin_Only_Relation_Type_Ids = Arrays.asList(AtsRelationTypes.TeamWorkflowToReview_Review.getId(), AtsRelationTypes.ActionToWorkflow_Action.getId());
    private static boolean deletionChecksEnabled = true;

    private boolean isDeletionChecksEnabled() {
        return deletionChecksEnabled && !AtsUtil.isInTest();
    }

    public XResultData isModifiableAttribute(ArtifactToken artifact, AttributeTypeToken attributeType, XResultData results) {
        for (IAtsWorkItemHook wiHook : AtsApiService.get().getWorkItemService().getWorkItemHooks()) {
            wiHook.isModifiableAttribute(artifact, attributeType, results);
            if (!results.isErrors()) continue;
            return results;
        }
        return results;
    }

    public XResultData isDeleteableRelation(ArtifactToken artifact, RelationTypeToken relationType, XResultData results) {
        if (this.isDeletionChecksEnabled() && Admin_Only_Relation_Type_Ids.contains(relationType.getId()) && !AtsApiService.get().getUserService().isAtsAdmin()) {
            results.errorf("Deletion of relation type [%s] off artifact [%s] is only permitted by ATS Admin", new Object[]{relationType, artifact});
        }
        return results;
    }

    public XResultData isDeleteable(Collection<? extends ArtifactToken> artifacts, XResultData results) {
        if (this.isDeletionChecksEnabled()) {
            AtsApi atsApi = AtsApiService.get();
            Set<ArtifactToken> allArtifacts = this.getAllArtifacts(atsApi, artifacts, new HashSet<ArtifactToken>());
            if (allArtifacts.isEmpty()) {
                return results;
            }
            boolean isAtsAdmin = atsApi.getUserService().isAtsAdmin();
            boolean isAtsDeleteWorkflowAdmin = atsApi.getUserService().isAtsDeleteWorkflowAdmin();
            this.checkActionableItems(isAtsAdmin, atsApi, allArtifacts, results);
            this.checkTeamDefinitions(isAtsAdmin, atsApi, allArtifacts, results);
            this.checkAtsWorkDefinitions(isAtsAdmin, atsApi, allArtifacts, results);
            this.checkUsers(isAtsAdmin, atsApi, allArtifacts, results);
            this.checkActions(isAtsAdmin, isAtsDeleteWorkflowAdmin, atsApi, allArtifacts, results);
            this.checkWorkPackages(isAtsAdmin, atsApi, allArtifacts, results);
        }
        return results;
    }

    private Set<ArtifactToken> getAllArtifacts(AtsApi atsApi, Collection<? extends ArtifactToken> artifacts, Set<ArtifactToken> allArtifacts) {
        for (ArtifactToken artifactToken : artifacts) {
            if (!artifactToken.getBranch().equals(atsApi.getAtsBranch())) continue;
            allArtifacts.addAll(atsApi.getStoreService().getDescendants(artifactToken));
        }
        return allArtifacts;
    }

    private void checkActions(boolean isAtsAdmin, boolean isAtsDeleteWorkflowAdmin, AtsApi atsApi, Collection<ArtifactToken> artifacts, XResultData results) {
        for (ArtifactToken art : artifacts) {
            String error;
            if (!isAtsAdmin && !isAtsDeleteWorkflowAdmin && this.isWorkflowOrAction(art) && !this.isTask(art)) {
                results.errorf("Deletion of [%s] is only permitted by ATS Admin or ATS Delete Workflow Admin; %s invalid", new Object[]{atsApi.getStoreService().getArtifactTypeName(art), art.toStringWithId()});
            }
            if (!Strings.isValid((String)(error = this.isWorkflowOrActionPermittedByAnyone(atsApi, art, artifacts)))) continue;
            results.errorf("Deletion of artifact type [%s] object %s is not permitted. Error: [%s]", new Object[]{atsApi.getStoreService().getArtifactTypeName(art), art.toStringWithId(), error});
        }
    }

    private String isWorkflowOrActionPermittedByAnyone(AtsApi atsApi, ArtifactToken art, Collection<ArtifactToken> allArtifacts) {
        if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
            for (IAtsTeamWorkflow teamWf : atsApi.getWorkItemService().getTeams((Object)art)) {
                if (allArtifacts.contains(teamWf.getStoreObject())) continue;
                return String.format("Can't delete action %s without deleting workflow %s, use ATS World Editor", art.toStringWithId(), teamWf.toStringWithId());
            }
        }
        if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            IAtsTeamWorkflow teamWf;
            teamWf = atsApi.getWorkItemService().getTeamWf(art);
            IAtsAction action = teamWf.getParentAction();
            Collection children = action.getTeamWorkflows();
            boolean allInList = true;
            for (IAtsTeamWorkflow child : children) {
                if (allArtifacts.contains(child.getStoreObject())) continue;
                allInList = false;
                break;
            }
            if (allInList && !allArtifacts.contains(action.getStoreObject())) {
                return String.format("Can't delete all child workflow(s) of %s without deleting action %s, use ATS World Editor", teamWf.getParentAction().getStoreObject().toStringWithId(), art.toStringWithId());
            }
        }
        return null;
    }

    private boolean isWorkflowOrAction(ArtifactToken art) {
        return art instanceof IAtsWorkItem || art instanceof IAtsAction;
    }

    private boolean isTask(ArtifactToken art) {
        return art instanceof IAtsTask;
    }

    private void checkActionableItems(boolean isAtsAdmin, AtsApi atsApi, Collection<ArtifactToken> artifacts, XResultData results) {
        Set<ArtifactToken> aiIds = this.getActionableItemIdsWithRecurse(new HashSet<ArtifactToken>(), artifacts, atsApi, results);
        if (!aiIds.isEmpty()) {
            List teamWfsRelatedToAis = atsApi.getQueryService().getArtifactsFromTypeAndAttribute(AtsArtifactTypes.TeamWorkflow, (AttributeTypeId)AtsAttributeTypes.ActionableItemReference, aiIds, (BranchId)atsApi.getAtsBranch());
            if (!teamWfsRelatedToAis.isEmpty()) {
                results.errorf("Actionable Items (or children AIs) [%s] selected to delete have related Team Workflows; Delete or re-assign Team Workflows first.", new Object[]{aiIds});
            }
            if (!isAtsAdmin) {
                results.error("Deletion of Actionable Items is only permitted by ATS Admin.");
            }
        }
    }

    private Set<ArtifactToken> getActionableItemIdsWithRecurse(HashSet<ArtifactToken> aiIds, Collection<ArtifactToken> artifacts, AtsApi atsApi, XResultData results) {
        for (ArtifactToken art : artifacts) {
            ActionableItem ai;
            if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem}) || (ai = atsApi.getActionableItemService().getActionableItemById((ArtifactId)art)) == null) continue;
            aiIds.add(ArtifactToken.valueOf((long)ai.getId(), (String)ai.getName()));
            Collection childArts = atsApi.getRelationResolver().getChildren((ArtifactId)ai.getStoreObject());
            if (ai.getChildrenActionableItems().isEmpty()) continue;
            this.getActionableItemIdsWithRecurse(aiIds, childArts, atsApi, results);
        }
        return aiIds;
    }

    private void checkTeamDefinitions(boolean isAtsAdmin, AtsApi atsApi, Collection<ArtifactToken> artifacts, XResultData results) {
        ArrayList<String> ids = new ArrayList<String>();
        for (ArtifactToken art : artifacts) {
            if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition})) continue;
            ids.add(art.getIdString());
        }
        if (!ids.isEmpty()) {
            List artifactListFromIds = atsApi.getQueryService().getArtifactsFromAttributeValues((AttributeTypeId)AtsAttributeTypes.TeamDefinitionReference, ids, (BranchId)atsApi.getAtsBranch(), 5);
            if (artifactListFromIds.size() > 0) {
                results.errorf("Team Definition (or children Team Definitions) [%s] selected to delete have related Team Workflows; Delete or re-assign Team Workflows first.", new Object[]{ids});
            }
            if (!isAtsAdmin) {
                results.error("Deletion of Team Definitions is only permitted by ATS Admin.");
            }
        }
    }

    private void checkWorkPackages(boolean isAtsAdmin, AtsApi atsApi, Collection<ArtifactToken> artifacts, XResultData results) {
        List artifactListFromIds;
        ArrayList<ArtifactToken> ids = new ArrayList<ArtifactToken>();
        for (ArtifactToken art : artifacts) {
            if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.WorkPackage})) continue;
            ids.add(art);
        }
        if (!ids.isEmpty() && (artifactListFromIds = atsApi.getQueryService().getArtifactsFromAttributeValues((AttributeTypeId)AtsAttributeTypes.WorkPackageReference, ids, (BranchId)atsApi.getAtsBranch())).size() > 0) {
            results.errorf("Work Packages [%s] selected to delete have related Work Items; Delete or re-assign Work Packages first.", new Object[]{ids});
        }
    }

    private void checkAtsWorkDefinitions(boolean isAtsAdmin, AtsApi atsApi, Collection<ArtifactToken> artifacts, XResultData results) {
        for (ArtifactToken art : artifacts) {
            if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.WorkDefinition})) continue;
            List artifactListFromTypeAndAttribute = atsApi.getQueryService().getArtifactsFromTypeAndAttribute((ArtifactTypeId)AtsArtifactTypes.WorkDefinition, (AttributeTypeId)AtsAttributeTypes.WorkflowDefinitionReference, art.getIdString(), (BranchId)atsApi.getAtsBranch());
            if (artifactListFromTypeAndAttribute.size() > 0) {
                results.errorf("ATS WorkDefinition [%s] selected to delete has ats.WorkDefinitionReference attributes set to it's name in %d artifact.  These must be changed first.", new Object[]{art, artifactListFromTypeAndAttribute.size()});
            }
            if (isAtsAdmin) continue;
            results.error("Deletion of Work Definitions is only permitted by ATS Admin.");
        }
    }

    private void checkUsers(boolean isAtsAdmin, AtsApi atsApi, Collection<ArtifactToken> artifacts, XResultData results) {
        HashSet<UserToken> users = new HashSet<UserToken>();
        for (ArtifactId artifactId : artifacts) {
            if (!(artifactId instanceof UserToken)) continue;
            if (!isAtsAdmin) {
                results.error("Only Admins can delete users");
                return;
            }
            users.add((UserToken)artifactId);
        }
        for (UserToken userToken : users) {
            UserRelatedToAtsObjectSearch srch = new UserRelatedToAtsObjectSearch(atsApi.getUserService().getUserById((ArtifactId)userToken), false, atsApi);
            if (srch.getResults().size() <= 0) continue;
            results.errorf("User name: \"%s\" userId: \"%s\" selected to delete has related ATS Objects; Un-relate to ATS first before deleting.", new Object[]{userToken.getName(), userToken.getUserId()});
        }
    }

    public static void setDeletionChecksEnabled(boolean deletionChecksEnabled) {
        AtsArtifactChecks.deletionChecksEnabled = deletionChecksEnabled;
    }
}

