/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import java.util.List;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerUtils;

public class ServerHealthTypes {
    private final JdbcClient jdbcClient;

    public ServerHealthTypes(JdbcClient jdbcClient) {
        this.jdbcClient = jdbcClient;
    }

    public String getHtml() {
        List<String> servers = ServerUtils.getServers(this.jdbcClient);
        if (servers.size() == 0) {
            return AHTML.simplePage((String)"No osee.health.servers configured in osee_info table");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<h3>OSEE Health - Server Health - Types</h3>");
        sb.append("Select to see server Types Health<br/><br/>");
        for (String server : servers) {
            String statusUrl = "http://" + server + "/orcs/types/health";
            sb.append(AHTML.getHyperlinkNewTab((String)statusUrl, (String)server));
            sb.append("<br/><br/>");
        }
        String html = AHTML.simplePage((String)sb.toString());
        return html;
    }
}

