/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.text.DateFormat;
import java.util.Arrays;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.activity.api.ThreadStats;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.server.IApplicationServerManager;
import org.eclipse.osee.framework.core.server.IAuthenticationManager;
import org.eclipse.osee.framework.core.server.OseeServerProperties;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.health.ServerStatus;
import org.eclipse.osee.orcs.health.StatusKey;

public class BuildServerStatusOperation {
    private final IApplicationServerManager applicationServerManager;
    private final IAuthenticationManager authManager;
    private final ActivityLog activityLog;
    private final RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
    private final OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();

    public BuildServerStatusOperation(IApplicationServerManager applicationServerManager, IAuthenticationManager authManager, ActivityLog activityLog) {
        this.applicationServerManager = applicationServerManager;
        this.authManager = authManager;
        this.activityLog = activityLog;
    }

    public ServerStatus get() {
        ServerStatus stat = new ServerStatus();
        stat.set(StatusKey.ServerUri, this.applicationServerManager.getServerUri().toString());
        stat.set(StatusKey.ServerId, this.applicationServerManager.getId());
        stat.set(StatusKey.StartTime, DateFormat.getDateTimeInstance(1, 1).format(this.applicationServerManager.getDateStarted()));
        int seconds = (int)(this.runtimeMxBean.getUptime() / 1000L) % 60;
        int minutes = (int)(this.runtimeMxBean.getUptime() / 60000L % 60L);
        int hours = (int)(this.runtimeMxBean.getUptime() / 3600000L % 24L);
        int days = (int)(this.runtimeMxBean.getUptime() / 86400000L);
        stat.set(StatusKey.UpTime, String.format("%s days %s hr %s min %s sec", days, hours, minutes, seconds));
        stat.set(StatusKey.SystemLoad, String.valueOf(this.osMxBean.getSystemLoadAverage()));
        stat.set(StatusKey.CodeLocation, System.getProperty("user.dir"));
        stat.set(StatusKey.BinaryDataPath, OseeServerProperties.getOseeApplicationServerData(null));
        stat.set(StatusKey.AuthenticationScheme, this.authManager.getProtocol());
        stat.set(StatusKey.AuthenticationSchemeSupported, Arrays.deepToString(this.authManager.getProtocols()));
        stat.set(StatusKey.SupportedVersions, Arrays.deepToString(this.applicationServerManager.getVersions()));
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMem = memoryMXBean.getHeapMemoryUsage();
        stat.set(StatusKey.HeapMemoryUsed, Lib.toMBytes((long)heapMem.getUsed()));
        stat.set(StatusKey.HeapMemoryAllocated, Lib.toMBytes((long)heapMem.getCommitted()));
        stat.set(StatusKey.HeapMemoryMax, Lib.toMBytes((long)heapMem.getMax()));
        MemoryUsage nonHeapMem = memoryMXBean.getNonHeapMemoryUsage();
        stat.set(StatusKey.NonHeapMemoryUsed, Lib.toMBytes((long)nonHeapMem.getUsed()));
        stat.set(StatusKey.NonHeapMemoryAllocated, Lib.toMBytes((long)nonHeapMem.getCommitted()));
        stat.set(StatusKey.NonHeapMemoryMax, Lib.toMBytes((long)nonHeapMem.getMax()));
        stat.garbageCollectorStats.addAll(this.activityLog.getGarbageCollectionStats());
        ThreadStats[] threadStats = this.activityLog.getThreadActivity();
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException ex) {
            this.activityLog.createThrowableEntry(CoreActivityTypes.OSEE_ERROR, (Throwable)ex);
        }
        for (String threadStr : this.activityLog.getThreadActivityDelta(threadStats)) {
            stat.add(threadStr);
        }
        return stat;
    }
}

