/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.cache.admin.internal;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.osee.cache.admin.Cache;
import org.eclipse.osee.cache.admin.CacheConfiguration;
import org.eclipse.osee.cache.admin.CacheDataLoader;
import org.eclipse.osee.cache.admin.CacheKeysLoader;
import org.eclipse.osee.cache.admin.internal.CacheProxy;
import org.eclipse.osee.cache.admin.internal.LoadingCacheProxy;
import org.eclipse.osee.framework.jdk.core.type.Pair;

public class CacheFactory {
    public <K, V> Cache<K, V> createCache(CacheConfiguration config) throws Exception {
        Preconditions.checkNotNull((Object)config, (Object)"cacheConfiguration");
        com.google.common.cache.Cache cache = this.createCacheBuilder(config).build();
        CacheProxy toReturn = new CacheProxy(cache);
        return toReturn;
    }

    public <K, V> Cache<K, V> createLoadingCache(CacheConfiguration config, final CacheDataLoader<K, V> dataLoader, CacheKeysLoader<K> keyLoader) throws Exception {
        Preconditions.checkNotNull((Object)config, (Object)"cacheConfiguration");
        Preconditions.checkNotNull(dataLoader, (Object)"cacheDataLoader");
        Preconditions.checkNotNull(keyLoader, (Object)"cacheKeysLoader");
        LoadingCache loadingCache = this.createCacheBuilder(config).build(new CacheLoader<K, V>(){

            public Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
                return dataLoader.load(keys);
            }

            public V load(K key) throws Exception {
                return dataLoader.load(key);
            }

            public ListenableFuture<V> reload(K key, V oldValue) throws Exception {
                Object newValue = dataLoader.reload(key, oldValue);
                return Futures.immediateFuture(newValue);
            }
        });
        LoadingCacheProxy toReturn = new LoadingCacheProxy(loadingCache, keyLoader);
        return toReturn;
    }

    private CacheBuilder<Object, Object> createCacheBuilder(CacheConfiguration config) {
        Pair<Long, TimeUnit> data;
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (config.hasInitialCapacity()) {
            builder = builder.initialCapacity(config.getInitialCapacity());
        }
        if (config.hasMaximumSize()) {
            builder = builder.maximumSize(config.getMaximumSize());
        }
        if (config.isExpireAfterAccess()) {
            data = config.getExpireAfterAccess();
            builder = builder.expireAfterAccess(((Long)data.getFirst()).longValue(), (TimeUnit)((Object)data.getSecond()));
        }
        if (config.isExpireAfterWrite()) {
            data = config.getExpireAfterWrite();
            builder = builder.expireAfterWrite(((Long)data.getFirst()).longValue(), (TimeUnit)((Object)data.getSecond()));
        }
        if (config.isRefreshAfterWrite()) {
            data = config.getRefreshAfterWrite();
            builder = builder.refreshAfterWrite(((Long)data.getFirst()).longValue(), (TimeUnit)((Object)data.getSecond()));
        }
        return builder;
    }
}

