/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.ext;

import com.fasterxml.jackson.jaxrs.base.JsonMappingExceptionMapper;
import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.impl.RuntimeDelegateImpl;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.transport.common.gzip.GZIPFeature;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.eclipse.osee.jaxrs.OrcsParamConverterProvider;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;
import org.eclipse.osee.jaxrs.server.internal.JaxRsUtils;
import org.eclipse.osee.jaxrs.server.internal.JaxRsVisitable;
import org.eclipse.osee.jaxrs.server.internal.applications.AbstractJaxRsApplicationContainer;
import org.eclipse.osee.jaxrs.server.internal.applications.AbstractJaxRsContainer;
import org.eclipse.osee.jaxrs.server.internal.applications.JaxRsApplicationRegistry;
import org.eclipse.osee.jaxrs.server.internal.applications.JaxRsContainerProviderImpl;
import org.eclipse.osee.jaxrs.server.internal.applications.JaxRsFactory;
import org.eclipse.osee.jaxrs.server.internal.applications.JaxRsProvider;
import org.eclipse.osee.jaxrs.server.internal.applications.JaxRsProviders;
import org.eclipse.osee.jaxrs.server.internal.ext.GenericExceptionMapper;
import org.eclipse.osee.jaxrs.server.internal.ext.OseeWebApplicationExceptionMapper;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.ExceptionRegistryOperations;
import org.eclipse.osee.orcs.OrcsApi;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpService;

public final class CxfJaxRsFactory
implements JaxRsFactory {
    private Log logger;
    private HttpService httpService;
    private List<Feature> features;
    private List<? extends Object> providers;
    private Map<String, Object> properties;
    private Map<Object, Object> extensionMappings;
    private OrcsApi orcsApi;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void start(Map<String, Object> props) {
        this.logger.debug("Starting [%s]...", new Object[]{this.getClass().getSimpleName()});
        RuntimeDelegateImpl runtimeDelegate = new RuntimeDelegateImpl();
        RuntimeDelegate.setInstance((RuntimeDelegate)runtimeDelegate);
        ExceptionRegistryOperations exceptionRegistryOperations = this.orcsApi.getExceptionRegistryOperations();
        ArrayList<? extends Object> providers = new ArrayList<Object>();
        providers.add(new OseeWebApplicationExceptionMapper(exceptionRegistryOperations, this.logger));
        providers.add(new GenericExceptionMapper(exceptionRegistryOperations, this.logger));
        providers.add(new OrcsParamConverterProvider(this.orcsApi.tokenService()));
        providers.add(new JacksonJaxbJsonProvider(this.orcsApi.jaxRsApi().getObjectMapper(), JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS));
        providers.add(JsonParseExceptionMapper.class);
        providers.add(JsonMappingExceptionMapper.class);
        this.providers = providers;
        ArrayList<Feature> features = new ArrayList<Feature>();
        LoggingFeature loggingFeature = new LoggingFeature();
        loggingFeature.setPrettyLogging(true);
        features.add((Feature)loggingFeature);
        features.add((Feature)new GZIPFeature());
        this.features = features;
        HashMap<Object, Object> extensionMappings = new HashMap<Object, Object>(6);
        extensionMappings.put("html", "text/html");
        extensionMappings.put("txt", "text/plain");
        extensionMappings.put("xml", "application/xml");
        extensionMappings.put("json", "application/json");
        extensionMappings.put("gzip", "application/gzip");
        extensionMappings.put("zip", "application/zip");
        this.extensionMappings = extensionMappings;
        this.properties = props;
    }

    public void stop() {
        if (this.providers != null) {
            this.providers.clear();
            this.providers = null;
        }
        if (this.features != null) {
            this.features.clear();
            this.features = null;
        }
        if (this.extensionMappings != null) {
            this.extensionMappings.clear();
            this.extensionMappings = null;
        }
        this.properties = null;
    }

    private Map<Object, Object> getExtensionMappings() {
        return this.extensionMappings;
    }

    private List<? extends Object> getProviders() {
        return this.providers;
    }

    private List<Feature> getFeatures() {
        return this.features;
    }

    private Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public JaxRsApplicationRegistry.JaxRsContainerProvider newJaxRsContainerProvider(String contextName) {
        return new JaxRsContainerProviderImpl(this, contextName);
    }

    @Override
    public JaxRsApplicationRegistry.JaxRsContainer newJaxRsContainer(String contextName) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        CxfJaxRsContainer container = new CxfJaxRsContainer(this.logger, this.httpService, props);
        container.setServletContext(contextName);
        this.logger.trace("Create - [%s]", new Object[]{container});
        return container;
    }

    private CxfJaxRsApplicationContainer newApplicationContainer(String applicationContext, JaxRsProviders provider) {
        return new CxfJaxRsApplicationContainer(applicationContext, provider);
    }

    private CXFNonSpringServlet newBaseJaxsRsServlet(JaxRsVisitable visitable) {
        return new CXFNonSpringServlet();
    }

    public Server newCxfServer(CXFNonSpringServlet servlet, String applicationPath, Application application, JaxRsProviders providers) {
        String contextName = servlet.getServletName();
        Bus bus = servlet.getBus();
        if (bus == null) {
            throw new OseeWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, "Error initializing [%s] for application [%s] - bus was null", new Object[]{contextName, application});
        }
        boolean ignoreApplicationPath = true;
        boolean staticSubresourceResolution = true;
        JAXRSServerFactoryBean bean = ResourceUtils.createApplication((Application)application, (boolean)ignoreApplicationPath, (boolean)staticSubresourceResolution, (boolean)staticSubresourceResolution, (Bus)bus);
        if (JaxRsUtils.hasPath(applicationPath)) {
            String string = JaxRsUtils.normalize(applicationPath);
            bean.setAddress(string);
        }
        if (providers.hasProviders()) {
            for (JaxRsProvider jaxRsProvider : providers.getProviders()) {
                bean.setProvider(jaxRsProvider.getProvider());
            }
        }
        bean.setProviders(this.getProviders());
        bean.setFeatures(this.getFeatures());
        bean.setProperties(this.getProperties());
        bean.setExtensionMappings(this.getExtensionMappings());
        bean.setBindingId("http://apache.org/cxf/binding/jaxrs");
        bean.setTransportId("http://cxf.apache.org/transports/http");
        bean.setBus(bus);
        bean.setStart(false);
        Server server = bean.create();
        return server;
    }

    private final class CxfJaxRsApplicationContainer
    extends AbstractJaxRsApplicationContainer {
        private final AtomicBoolean isRegistered;
        private final JaxRsProviders providers;
        private volatile Server server;

        public CxfJaxRsApplicationContainer(String applicationContext, JaxRsProviders providers) {
            super(applicationContext);
            this.isRegistered = new AtomicBoolean(false);
            this.providers = providers;
        }

        public void startContainer(CXFNonSpringServlet servlet) {
            if (!this.isRegistered.getAndSet(true)) {
                Server newServer = CxfJaxRsFactory.this.newCxfServer(servlet, this.getApplicationContext(), this.getApplication(), this.providers);
                if (newServer != null) {
                    newServer.start();
                }
                this.server = newServer;
            }
        }

        public void stopContainer() {
            if (this.isRegistered.getAndSet(false) && this.server != null) {
                this.server.stop();
                this.server.destroy();
            }
        }
    }

    private final class CxfJaxRsContainer
    extends AbstractJaxRsContainer<CXFNonSpringServlet, CxfJaxRsApplicationContainer, JaxRsProvider> {
        public CxfJaxRsContainer(Log logger, HttpService httpService, Dictionary<String, Object> props) {
            super(logger, httpService, props);
        }

        @Override
        protected CxfJaxRsApplicationContainer createApplicationContainer(String applicationContext) {
            return CxfJaxRsFactory.this.newApplicationContainer(applicationContext, this);
        }

        @Override
        protected CXFNonSpringServlet createBaseJaxsRsServlet(JaxRsVisitable visitable) {
            return CxfJaxRsFactory.this.newBaseJaxsRsServlet(visitable);
        }

        @Override
        protected void startContainer(CxfJaxRsApplicationContainer container) {
            CXFNonSpringServlet baseServlet = (CXFNonSpringServlet)this.getBaseServlet();
            container.startContainer(baseServlet);
        }

        @Override
        protected void stopContainer(CxfJaxRsApplicationContainer container) {
            container.stopContainer();
        }

        @Override
        protected JaxRsProvider createJaxRsProvider(Bundle bundle, Object provider) {
            return new JaxRsFeatureImpl(bundle, provider);
        }
    }

    private static final class JaxRsFeatureImpl
    implements JaxRsProvider {
        private final Bundle bundle;
        private final Object provider;

        public JaxRsFeatureImpl(Bundle bundle, Object provider) {
            this.bundle = bundle;
            this.provider = provider;
        }

        @Override
        public Bundle getBundle() {
            return this.bundle;
        }

        @Override
        public Object getProvider() {
            return this.provider;
        }
    }
}

