/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.osee.framework.jdk.core.type.IPropertyStore;
import org.eclipse.osee.framework.jdk.core.type.PropertyStoreWriter;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class PropertyStore
implements IPropertyStore,
Serializable {
    private static final String EMPTY_STRING = new String();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final long serialVersionUID = 9076969425223251739L;
    private static final String EXCEPTION_MESSAGE = "No setting found for key: [%s]";
    private String storeId;
    private final Map<String, Object> storageData;
    private final Map<String, Object> storageArrays;
    private final Map<String, Object> storageProperties;

    private PropertyStore(String storeId, Map<String, Object> storageData, Map<String, Object> storageArrays, Map<String, Object> storageProperties) {
        this.storeId = storeId;
        this.storageData = storageData;
        this.storageArrays = storageArrays;
        this.storageProperties = storageProperties;
    }

    public PropertyStore(String storeId) {
        this(storeId, new TreeMap<String, Object>(), new TreeMap<String, Object>(), new TreeMap<String, Object>());
    }

    public PropertyStore() {
        this(EMPTY_STRING);
    }

    public PropertyStore(Map<String, Object> properties) {
        this(Integer.toString(properties.hashCode()), properties, new TreeMap<String, Object>(), new TreeMap<String, Object>());
    }

    @Override
    public String get(String key) {
        String result = EMPTY_STRING;
        if (this.storageData.containsKey(key)) {
            result = (String)this.storageData.get(key);
        }
        return result;
    }

    @Override
    public String[] getArray(String key) {
        String[] value = (String[])this.storageArrays.get(key);
        if (value == null) {
            value = EMPTY_STRING_ARRAY;
        }
        return value;
    }

    @Override
    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.get(key));
    }

    @Override
    public double getDouble(String key) throws NumberFormatException {
        String setting = this.get(key);
        if (!Strings.isValid(setting)) {
            throw new NumberFormatException(String.format(EXCEPTION_MESSAGE, key));
        }
        return Double.valueOf(setting);
    }

    @Override
    public float getFloat(String key) throws NumberFormatException {
        String setting = this.get(key);
        if (!Strings.isValid(setting)) {
            throw new NumberFormatException(String.format(EXCEPTION_MESSAGE, key));
        }
        return Float.valueOf(setting).floatValue();
    }

    @Override
    public int getInt(String key) throws NumberFormatException {
        String setting = this.get(key);
        if (!Strings.isValid(setting)) {
            throw new NumberFormatException(String.format(EXCEPTION_MESSAGE, key));
        }
        return Integer.valueOf(setting);
    }

    @Override
    public long getLong(String key) throws NumberFormatException {
        String setting = this.get(key);
        if (!Strings.isValid(setting)) {
            throw new NumberFormatException(String.format(EXCEPTION_MESSAGE, key));
        }
        return Long.valueOf(setting);
    }

    @Override
    public PropertyStore getPropertyStore(String key) {
        return (PropertyStore)this.storageProperties.get(key);
    }

    public void put(String key, PropertyStore store) {
        if (store == null) {
            this.storageProperties.remove(key);
        } else {
            this.storageProperties.put(key, store);
        }
    }

    @Override
    public void put(String key, String[] value) {
        if (value == null) {
            value = EMPTY_STRING_ARRAY;
        }
        this.storageArrays.put(key, value);
    }

    @Override
    public void put(String key, double value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, float value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, int value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, long value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, String value) {
        if (value == null) {
            value = EMPTY_STRING;
        }
        this.storageData.put(key, value);
    }

    @Override
    public void put(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public String getId() {
        return this.storeId;
    }

    void setId(String name) {
        if (name == null) {
            name = EMPTY_STRING;
        }
        this.storeId = name;
    }

    Map<String, Object> getItems() {
        return this.storageData;
    }

    Map<String, Object> getArrays() {
        return this.storageArrays;
    }

    Map<String, Object> getPropertyStores() {
        return this.storageProperties;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Id:[%s] Data:%s Arrays:{", this.getId(), this.storageData.toString()));
        int cnt = 0;
        for (String key : new TreeSet<String>(this.storageArrays.keySet())) {
            if (cnt != 0) {
                builder.append(" ");
            }
            builder.append((Object)key);
            builder.append("=");
            builder.append(Arrays.deepToString((String[])this.storageArrays.get(key)));
            if (++cnt >= this.storageArrays.size()) continue;
            builder.append(",");
        }
        builder.append("}");
        return builder.toString();
    }

    public void load(String input) throws Exception {
        PropertyStoreWriter storeWriter = new PropertyStoreWriter();
        storeWriter.load(this, new StringReader(input));
    }

    @Override
    public void load(InputStream inputStream) throws Exception {
        PropertyStoreWriter storeWriter = new PropertyStoreWriter();
        storeWriter.load(this, inputStream);
    }

    public void load(Reader reader) throws Exception {
        PropertyStoreWriter storeWriter = new PropertyStoreWriter();
        storeWriter.load(this, reader);
    }

    public String save() throws Exception {
        StringWriter writer = new StringWriter();
        this.save(writer);
        return writer.toString();
    }

    public void save(Writer writer) throws Exception {
        PropertyStoreWriter storeWriter = new PropertyStoreWriter();
        storeWriter.save(this, writer);
    }

    @Override
    public void save(OutputStream outputStream) throws Exception {
        PropertyStoreWriter storeWriter = new PropertyStoreWriter();
        storeWriter.save(this, outputStream);
    }

    @Override
    public Set<String> arrayKeySet() {
        List items = Collections.castAll(this.storageArrays.keySet());
        return Collections.toSet(items);
    }

    @Override
    public Set<String> keySet() {
        List items = Collections.castAll(this.storageData.keySet());
        return Collections.toSet(items);
    }

    @Override
    public Set<String> innerStoresKeySet() {
        List items = Collections.castAll(this.storageProperties.keySet());
        return Collections.toSet(items);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PropertyStore) {
            PropertyStore castObj = (PropertyStore)obj;
            return castObj.storeId.equals(this.storeId) && castObj.storageData.equals(this.storageData) && this.areStorageArraysEqual(castObj);
        }
        return false;
    }

    private boolean areStorageArraysEqual(PropertyStore other) {
        boolean result;
        boolean bl = result = other.storageArrays.size() == this.storageArrays.size();
        if (result) {
            for (Map.Entry<String, Object> expectedEntry : this.storageArrays.entrySet()) {
                Object actualValue;
                String[] actualArray;
                Object expectedValue = expectedEntry.getValue();
                String[] expArray = (String[])expectedValue;
                if (!(result &= this.checkArrays(expArray, actualArray = (String[])(actualValue = other.storageArrays.get(expectedEntry.getKey()))))) break;
            }
        }
        return result;
    }

    private boolean checkArrays(String[] expArray, String[] actualArray) {
        boolean result;
        boolean bl = result = expArray.length == actualArray.length;
        if (result) {
            int index = 0;
            while (index < expArray.length) {
                result &= expArray[index].equals(actualArray[index]);
                ++index;
            }
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.storeId.hashCode();
        result = 31 * result + this.getPropertiesHashCode(this.storageData);
        result = 31 * result + this.getPropertiesHashCode(this.storageArrays);
        return result;
    }

    public int getPropertiesHashCode(Map<String, Object> properties) {
        int result = 0;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            result += entry.getKey().hashCode();
            Object value = entry.getValue();
            if (value instanceof String[]) {
                result += Arrays.deepHashCode((String[])value);
                continue;
            }
            result += value.hashCode();
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.keySet().isEmpty() && this.innerStoresKeySet().isEmpty() && this.arrayKeySet().isEmpty();
    }

    public void clear() {
        this.storageData.clear();
        this.storageArrays.clear();
    }
}

