/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.client.internal;

import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;

public class Options
implements Cloneable {
    private DeletionFlag includeDeleted;
    private TransactionId transactionId;

    public Options() {
        this.reset();
    }

    public void reset() {
        this.includeDeleted = DeletionFlag.EXCLUDE_DELETED;
        this.transactionId = TransactionId.SENTINEL;
    }

    public boolean areDeletedIncluded() {
        return this.includeDeleted.areDeletedAllowed();
    }

    public void setIncludeDeleted(boolean enabled) {
        this.includeDeleted = DeletionFlag.allowDeleted((boolean)enabled);
    }

    public DeletionFlag getIncludeDeleted() {
        return this.includeDeleted;
    }

    public void setFromTransaction(TransactionId transactionId) {
        this.transactionId = transactionId;
    }

    public TransactionId getFromTransaction() {
        return this.transactionId;
    }

    public void setHeadTransaction() {
        this.transactionId = TransactionId.SENTINEL;
    }

    public boolean isHeadTransaction() {
        return this.transactionId.equals(TransactionId.SENTINEL);
    }

    public boolean isHistorical() {
        return !this.isHeadTransaction();
    }

    public Options clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        Options clone = new Options();
        clone.includeDeleted = this.includeDeleted;
        clone.transactionId = this.transactionId;
        return clone;
    }

    public String toString() {
        return "Options [includeDeleted=" + this.includeDeleted + ", transactionId=" + this.transactionId + "]";
    }
}

