/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class HttpProcessor {
    private HttpProcessor() {
    }

    public static AcquireResult acquire(URL url, OutputStream outputStream, int soTimeout) throws Exception {
        AcquireResult result = new AcquireResult();
        int statusCode = -1;
        InputStream inputStream = null;
        try {
            try {
                Client client = ClientBuilder.newClient();
                WebTarget target = client.target(url.toString());
                Response response = target.request().get();
                statusCode = response.getStatus();
                result.setEncoding("UTF-8");
                result.setContentType("text/html");
                if (statusCode == 200 || statusCode == 202) {
                    inputStream = (InputStream)response.readEntity(InputStream.class);
                    Lib.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)outputStream);
                } else {
                    String responseString = (String)response.readEntity(String.class);
                    result.setResult(responseString);
                }
            }
            catch (Exception ex) {
                throw new Exception(String.format("Error acquiring resource: [%s] - status code: [%s]", url, statusCode), ex);
            }
        }
        catch (Throwable throwable) {
            Lib.close(inputStream);
            result.setCode(statusCode);
            throw throwable;
        }
        Lib.close((AutoCloseable)inputStream);
        result.setCode(statusCode);
        return result;
    }

    public static final class AcquireResult {
        private int code = -1;
        private String encoding = "";
        private String contentType = "";
        private String result;

        private AcquireResult() {
        }

        public boolean wasSuccessful() {
            return this.code == 200 || this.code == 202;
        }

        public int getCode() {
            return this.code;
        }

        private void setCode(int code) {
            this.code = code;
        }

        public String getEncoding() {
            return this.encoding;
        }

        private void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getContentType() {
            return this.contentType;
        }

        private void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }
    }
}

