/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class FileSelector
extends Composite {
    private final Label radSingleFile;
    private final Text txtSingleFile;
    private final Button btnSingleFile;
    private final String defaultPath;
    private final String[] allowedExtensions;

    public FileSelector(Composite parent, int style, String name, String defaultPath, Listener listener, String ... allowedExtensions) {
        super(parent, style);
        this.defaultPath = defaultPath;
        this.allowedExtensions = allowedExtensions;
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(768));
        Group composite = new Group((Composite)this, style);
        composite.setText(name);
        GridLayout gd = new GridLayout();
        gd.numColumns = 3;
        composite.setLayout((Layout)gd);
        composite.setLayoutData((Object)new GridData(768));
        this.radSingleFile = new Label((Composite)composite, 0);
        this.radSingleFile.setText("File:");
        this.txtSingleFile = new Text((Composite)composite, 2052);
        this.txtSingleFile.setLayoutData((Object)new GridData(768));
        this.txtSingleFile.addListener(24, listener);
        this.btnSingleFile = new Button((Composite)composite, 8);
        this.btnSingleFile.setText("&Browse...");
        this.btnSingleFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file = FileSelector.this.selectFile();
                if (file != null && file.isFile()) {
                    FileSelector.this.txtSingleFile.setText(file.getPath());
                }
            }
        });
    }

    public File getFile() {
        return new File(this.getText());
    }

    public String getText() {
        return this.txtSingleFile.getText();
    }

    public void setText(String text) {
        this.txtSingleFile.setText(text);
    }

    private File selectFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 4100);
        dialog.setFilterExtensions(this.allowedExtensions);
        dialog.setFilterPath(this.defaultPath);
        String path = dialog.open();
        return path != null ? new File(path) : null;
    }
}

