/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.memory;

import java.util.Iterator;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.memory.IMemoryRenderingBindingsListener;
import org.eclipse.debug.ui.memory.IMemoryRenderingBindingsProvider;

public abstract class AbstractMemoryRenderingBindingsProvider
implements IMemoryRenderingBindingsProvider {
    private ListenerList<IMemoryRenderingBindingsListener> fListeners;

    @Override
    public void addListener(IMemoryRenderingBindingsListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
    }

    @Override
    public void removeListener(IMemoryRenderingBindingsListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
        }
    }

    protected void fireBindingsChanged() {
        if (this.fListeners == null) {
            return;
        }
        Iterator iterator = this.fListeners.iterator();
        while (iterator.hasNext()) {
            IMemoryRenderingBindingsListener iMemoryRenderingBindingsListener;
            final IMemoryRenderingBindingsListener listener = iMemoryRenderingBindingsListener = (IMemoryRenderingBindingsListener)iterator.next();
            ISafeRunnable runnable = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    DebugUIPlugin.log(exception);
                }

                public void run() throws Exception {
                    listener.memoryRenderingBindingsChanged();
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }
}

