/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.branch;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.branch.BranchData;
import org.eclipse.osee.ats.api.commit.CommitConfigItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.core.util.AbstractAtsBranchService;
import org.eclipse.osee.ats.rest.internal.branch.AtsBranchOperations;
import org.eclipse.osee.ats.rest.internal.workitem.operations.AtsBranchCommitOperation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.core.exception.OseeWrappedException;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArchiveOperation;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class AtsBranchServiceImpl
extends AbstractAtsBranchService {
    private final OrcsApi orcsApi;
    private final TransactionQuery txQuery;
    private final HashCollectionSet<ArtifactId, TransactionRecord> commitArtifactIdMap = new HashCollectionSet(true, HashSet::new);

    public AtsBranchServiceImpl(AtsApi atsServices, OrcsApi orcsApi, ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy) {
        super(atsServices, teamWorkflowProvidersLazy);
        this.orcsApi = orcsApi;
        this.txQuery = orcsApi.getQueryFactory().transactionQuery();
    }

    public BranchToken getCommittedWorkingBranch(IAtsTeamWorkflow teamWf) {
        BranchQuery query = this.orcsApi.getQueryFactory().branchQuery();
        ArtifactId artId = ArtifactId.valueOf((Long)teamWf.getId());
        return (BranchToken)((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)query.andIsOfType(new BranchType[]{BranchType.WORKING})).andStateIs(new BranchState[]{BranchState.COMMITTED})).excludeArchived()).andAssociatedArtId(artId)).getResults().getExactlyOne();
    }

    public BranchToken getWorkingBranchExcludeStates(IAtsTeamWorkflow teamWf, BranchState ... negatedBranchStates) {
        BranchQuery branchQuery = this.orcsApi.getQueryFactory().branchQuery();
        if (negatedBranchStates.length > 0) {
            LinkedList<BranchState> statesToSearch = new LinkedList<BranchState>(Arrays.asList(BranchState.values()));
            statesToSearch.removeAll(Arrays.asList(negatedBranchStates));
            branchQuery.andStateIs(statesToSearch.toArray(new BranchState[statesToSearch.size()]));
        }
        branchQuery.andIsOfType(new BranchType[]{BranchType.WORKING});
        ArtifactId artId = ArtifactId.valueOf((Long)teamWf.getId());
        branchQuery.andAssociatedArtId(artId);
        return (BranchToken)branchQuery.getResultsAsId().getAtMostOneOrNull();
    }

    public BranchType getBranchType(BranchId branch) {
        return this.getBranch(branch).getBranchType();
    }

    public BranchState getBranchState(BranchId branch) {
        if (branch instanceof Branch) {
            return ((Branch)branch).getBranchState();
        }
        BranchQuery query = this.orcsApi.getQueryFactory().branchQuery();
        Branch fullBranch = (Branch)((BranchQuery)query.andId(branch)).getResults().getExactlyOne();
        return fullBranch.getBranchState();
    }

    public boolean isMergeBranchExists(IAtsTeamWorkflow teamWf, BranchId destinationBranch) {
        return this.isMergeBranchExists(teamWf, (BranchId)this.getWorkingBranch(teamWf), destinationBranch);
    }

    public boolean isMergeBranchExists(IAtsTeamWorkflow teamWf, BranchId workingBranch, BranchId destinationBranch) {
        if (workingBranch.isInvalid()) {
            return false;
        }
        BranchQuery query = this.orcsApi.getQueryFactory().branchQuery();
        if ((query = (BranchQuery)query.andIsMergeFor(workingBranch, destinationBranch)) == null) {
            return false;
        }
        return query.exists();
    }

    public Branch getBranch(BranchId branch) {
        if (branch instanceof Branch) {
            return (Branch)branch;
        }
        return (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branch)).getResults().getExactlyOne();
    }

    public boolean branchExists(BranchId branch) {
        BranchQuery query = this.orcsApi.getQueryFactory().branchQuery();
        return ((BranchQuery)query.andId(branch)).exists();
    }

    public boolean isArchived(BranchId branch) {
        if (branch instanceof Branch) {
            return ((Branch)branch).isArchived();
        }
        return this.getBranch(branch).isArchived();
    }

    public void archiveBranch(BranchId branch) {
        try {
            this.orcsApi.getBranchOps().archiveUnarchiveBranch(branch, ArchiveOperation.ARCHIVE).call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public Collection<TransactionRecord> getCommittedArtifactTransactionIds(IAtsTeamWorkflow teamWf) {
        ArtifactId artId = ArtifactId.valueOf((Long)teamWf.getId());
        if (!this.commitArtifactIdMap.containsKey((Object)artId)) {
            this.txQuery.andCommitId(teamWf.getArtifactId());
            this.txQuery.getResults().forEach(tx -> {
                Collection collection = this.commitArtifactIdMap.put((Object)artId, (Object)new TransactionRecord(tx.getId(), tx.getBranch(), tx.getComment(), tx.getDate(), tx.getAuthor(), tx.getCommitArt(), tx.getTxType(), tx.getBuildId()));
            });
        }
        return this.commitArtifactIdMap.safeGetValues((Object)artId);
    }

    public BranchId getParentBranch(BranchId branch) {
        if (branch instanceof Branch) {
            return ((Branch)branch).getParentBranch();
        }
        BranchQuery query = this.orcsApi.getQueryFactory().branchQuery();
        Branch fullBranch = (Branch)((BranchQuery)query.andId(branch)).getResults().getExactlyOne();
        return fullBranch.getParentBranch();
    }

    public TransactionToken getBaseTransaction(BranchId branch) {
        TransactionQuery txQuery = this.orcsApi.getQueryFactory().transactionQuery();
        return (TransactionToken)((TransactionQuery)((TransactionQuery)txQuery.andBranch(new BranchId[]{branch})).andIs(new TransactionDetailsType[]{TransactionDetailsType.Baselined})).getResults().getExactlyOne();
    }

    public void setBranchName(BranchToken branch, String name) {
        try {
            this.orcsApi.getBranchOps().changeBranchName((BranchId)branch, name).call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public String getBranchName(BranchId branchId) {
        return this.getBranch(branchId).getName();
    }

    public Result moveWorkingBranch(IAtsTeamWorkflow fromTeamWf, IAtsTeamWorkflow toTeamWf, String newBranchName) {
        throw new UnsupportedOperationException("Not yet supported on server");
    }

    public Collection<BranchId> getBranches(BranchArchivedState archivedState, BranchType branchTypes) {
        LinkedList<BranchId> branches = new LinkedList<BranchId>();
        for (Branch branch : ((BranchQuery)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andIsOfType(new BranchType[]{branchTypes})).excludeArchived()).getResults()) {
            branches.add((BranchId)branch);
        }
        return branches;
    }

    public ArtifactId getAssociatedArtifactId(BranchId branch) {
        if (branch instanceof Branch) {
            return ((Branch)branch).getAssociatedArtifact();
        }
        return ((Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branch)).getResults().getExactlyOne()).getAssociatedArtifact();
    }

    public List<ChangeItem> getChangeData(TransactionId transaction) {
        TransactionQuery transQuery = this.orcsApi.getQueryFactory().transactionQuery();
        TransactionToken transTok = (TransactionToken)((TransactionQuery)transQuery.andTxId(transaction)).getTokens().iterator().next();
        TransactionReadable startTx = (TransactionReadable)((TransactionQuery)transQuery.andIsPriorTx(transTok)).getResults().getAtMostOneOrDefault((Object)TransactionReadable.SENTINEL);
        List results = this.orcsApi.getTransactionFactory().compareTxs((TransactionId)startTx, transaction);
        return results;
    }

    public List<ChangeItem> getChangeData(BranchId branch) {
        TransactionQuery transactionQuery2 = this.orcsApi.getQueryFactory().transactionQuery();
        TransactionQuery transactionQuery3 = this.orcsApi.getQueryFactory().transactionQuery();
        BranchId parentBranch = this.atsApi.getBranchService().getParentBranch(branch);
        TransactionReadable startTx = (TransactionReadable)((TransactionQuery)transactionQuery2.andIsHead(branch)).getResults().getExactlyOne();
        TransactionReadable endTx = (TransactionReadable)((TransactionQuery)transactionQuery3.andIsHead(parentBranch)).getResults().getExactlyOne();
        List results = this.orcsApi.getTransactionFactory().compareTxs((TransactionId)startTx, (TransactionId)endTx);
        return results;
    }

    public void setAssociatedArtId(BranchId branch, ArtifactId artifact) {
        try {
            this.orcsApi.getBranchOps().associateBranchToArtifact(branch, artifact).call();
        }
        catch (Exception ex) {
            throw new OseeWrappedException((Throwable)ex, "Error setting associated branch %s to artifact %s", new Object[]{branch, artifact});
        }
    }

    public boolean isBaselinBranchConfigured(CommitConfigItem commitConfigArt) {
        return commitConfigArt.getBaselineBranchId().isValid();
    }

    public XResultData deleteBranch(BranchId branch) {
        throw new UnsupportedOperationException("Not supported on server");
    }

    public BranchData createBranch(BranchData branchData) {
        AtsBranchOperations ops = new AtsBranchOperations(this.atsApi, this.orcsApi);
        return ops.createBranch(branchData);
    }

    public XResultData commitBranch(IAtsTeamWorkflow teamWf, BranchId destinationBranch, AtsUser asUser, XResultData rd) {
        AtsBranchCommitOperation commitOp = new AtsBranchCommitOperation(asUser, teamWf, this.atsApi, this.orcsApi, false, destinationBranch, rd);
        return commitOp.run();
    }
}

