/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.server.internal.JaxRsUtils;

public class OAuth2Configuration {
    public static final String NAMESPACE = "jaxrs.oauth2.provider";
    public static final String OAUTH2_PROVIDER__SERVICE_ENABLED = OAuth2Configuration.qualify("enabled");
    public static final String OAUTH2_PROVIDER__ACCESS_TOKEN_EXPIRATION = OAuth2Configuration.qualify("access.token.expiration");
    public static final String OAUTH2_PROVIDER__CODE_GRANT_EXPIRATION = OAuth2Configuration.qualify("code.grant.expiration");
    public static final String OAUTH2_PROVIDER__REFRESH_TOKEN_EXPIRATION = OAuth2Configuration.qualify("refresh.token.expiration");
    public static final String OAUTH2_PROVIDER__SESSION_TOKEN_EXPIRATION = OAuth2Configuration.qualify("session.token.expiration");
    public static final String OAUTH2_PROVIDER__NONCE_ALLOWED_WINDOW = OAuth2Configuration.qualify("nonce.allowed.window");
    public static final String OAUTH2_PROVIDER__LOGIN_REDIRECT_URI = OAuth2Configuration.qualify("login.redirect.uri");
    public static final String OAUTH2_PROVIDER__LOGIN_REDIRECT_ERROR_URI = OAuth2Configuration.qualify("login.redirect.error.uri");
    public static final String OAUTH2_PROVIDER__IGNORE_LOGIN_REDIRECT_BASE_PATH = OAuth2Configuration.qualify("ignore.login.redirect.base.path");
    public static final String OAUTH2_PROVIDER__REALM = OAuth2Configuration.qualify("realm");
    public static final String OAUTH2_PROVIDER__AUDIENCE_IS_ENDPOINT_ADDRESS = OAuth2Configuration.qualify("audience.is.endpoint.address");
    public static final String OAUTH2_PROVIDER__BLOCK_UNSECURED_REQUESTS = OAuth2Configuration.qualify("block.unsecured.requests");
    public static final String OAUTH2_PROVIDER__CAN_SUPPORT_PUBLIC_CLIENTS = OAuth2Configuration.qualify("can.support.public.clients");
    public static final String OAUTH2_PROVIDER__USE_DEFAULT_LOGIN_PAGE = OAuth2Configuration.qualify("use.default.login.page");
    public static final String OAUTH2_PROVIDER__FILTER_CHECKS_FORM_DATA = OAuth2Configuration.qualify("filter.checks.form.data.for.token");
    public static final String OAUTH2_PROVIDER__HAWK_TOKEN_SUPPORTED = OAuth2Configuration.qualify("hawk.token.supported");
    public static final String OAUTH2_PROVIDER__PARTIAL_MATCH_SCOPE_VALIDATION = OAuth2Configuration.qualify("partial.match.scope.validation");
    public static final String OAUTH2_PROVIDER__REFRESH_TOKENS_ALLOWED = OAuth2Configuration.qualify("refresh.tokens.allowed");
    public static final String OAUTH2_PROVIDER__REPORT_CLIENT_ID = OAuth2Configuration.qualify("report.client.id");
    public static final String OAUTH2_PROVIDER__USE_REGISTERED_REDIRECT_URI = OAuth2Configuration.qualify("use.registered.redirect.uri");
    public static final String OAUTH2_PROVIDER__USE_USER_SUBJECT = OAuth2Configuration.qualify("use.user.subject");
    public static final String OAUTH2_PROVIDER__WRITE_CUSTOM_ERRORS = OAuth2Configuration.qualify("write.custom.errors");
    public static final String OAUTH2_PROVIDER__WRITE_OPTIONAL_PARAMETERS = OAuth2Configuration.qualify("write.optional.parameters");
    public static final String OAUTH2_PROVIDER__SECRET_KEY_ALGORITHM = OAuth2Configuration.qualify("secret.key.algorithm");
    public static final String OAUTH2_PROVIDER__ENCODED_SECRET_KEY = OAuth2Configuration.qualify("secret.key");
    public static final boolean DEFAULT_OAUTH2_PROVIDER__SERVICE_ENABLED = false;
    public static final long DEFAULT_OAUTH2_PROVIDER__ACCESS_TOKEN_EXPIRATION = 600000L;
    public static final long DEFAULT_OAUTH2_PROVIDER__CODE_GRANT_EXPIRATION = 60000L;
    public static final long DEFAULT_OAUTH2_PROVIDER__REFRESH_TOKEN_EXPIRATION = 1800000L;
    public static final long DEFAULT_OAUTH2_PROVIDER__SESSION_TOKEN_EXPIRATION = 60L;
    public static final long DEFAULT_OAUTH2_PROVIDER__NONCE_ALLOWED_WINDOW = 2000L;
    public static final URI DEFAULT_OAUTH2_PROVIDER__LOGIN_REDIRECT_URI = null;
    public static final boolean DEFAULT_OAUTH2_PROVIDER__IGNORE_LOGIN_REDIRECT_BASE_PATH = false;
    public static final URI DEFAULT_OAUTH2_PROVIDER__LOGIN_ERROR_REDIRECT_URI = null;
    public static final boolean DEFAULT_OAUTH2_PROVIDER__IGNORE_LOGIN_ERROR_REDIRECT_BASE_PATH = false;
    public static final String DEFAULT_OAUTH2_PROVIDER__REALM = "OAuth2-OSEE";
    public static final boolean DEFAULT_OAUTH2_PROVIDER__AUDIENCE_IS_ENDPOINT_ADDRESS = false;
    public static final boolean DEFAULT_OAUTH2_PROVIDER__BLOCK_UNSECURED_REQUESTS = false;
    public static final boolean DEFAULT_OAUTH2_PROVIDER__CAN_SUPPORT_PUBLIC_CLIENTS = true;
    public static final boolean DEFAULT_OAUTH2_PROVIDER__USE_DEFAULT_LOGIN_PAGE = true;
    public static final boolean DEFAULT_OAUTH2_PROVIDER__FILTER_CHECKS_FORM_DATA = false;
    public static final boolean DEFAULT_OAUTH2_PROVIDER__HAWK_TOKEN_SUPPORTED = false;
    public static final boolean DEFAULT_OAUTH2_PROVIDER__PARTIAL_MATCH_SCOPE_VALIDATION = false;
    public static final boolean DEFAULT_OAUTH2_PROVIDER__REFRESH_TOKENS_ALLOWED = true;
    public static final boolean DEFAULT_OAUTH2_PROVIDER__REPORT_CLIENT_ID = true;
    public static final boolean DEFAULT_OAUTH2_PROVIDER__USE_REGISTERED_REDIRECT_URI = true;
    public static final boolean DEFAULT_OAUTH2_PROVIDER__USE_USER_SUBJECT = false;
    public static final boolean DEFAULT_OAUTH2_PROVIDER__WRITE_CUSTOM_ERRORS = true;
    public static final boolean DEFAULT_OAUTH2_PROVIDER__WRITE_OPTIONAL_PARAMETERS = true;
    public static final String DEFAULT_OAUTH2_PROVIDER__SECRET_KEY_ALGORITHM = null;
    public static final String DEFAULT_OAUTH2_PROVIDER__ENCODED_SECRET_KEY = null;
    private final Map<String, Object> props;

    private static String qualify(String value) {
        return String.format("%s.%s", NAMESPACE, value);
    }

    public static OAuth2Configuration fromProperties(Map<String, Object> props) {
        OAuth2Configuration config = new OAuth2Configuration(props);
        return config;
    }

    private OAuth2Configuration(Map<String, Object> props) {
        this.props = props;
    }

    public boolean isEnabled() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_PROVIDER__SERVICE_ENABLED, false);
    }

    public boolean isServiceEnabled() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_PROVIDER__SERVICE_ENABLED, false);
    }

    public long getSessionTokenExpiration() {
        return JaxRsUtils.getLong(this.props, OAUTH2_PROVIDER__SESSION_TOKEN_EXPIRATION, 60L);
    }

    public long getAccessTokenExpiration() {
        return JaxRsUtils.getLong(this.props, OAUTH2_PROVIDER__ACCESS_TOKEN_EXPIRATION, 600000L);
    }

    public long getCodeGrantExpiration() {
        return JaxRsUtils.getLong(this.props, OAUTH2_PROVIDER__CODE_GRANT_EXPIRATION, 60000L);
    }

    public long getRefreshTokenExpiration() {
        return JaxRsUtils.getLong(this.props, OAUTH2_PROVIDER__REFRESH_TOKEN_EXPIRATION, 1800000L);
    }

    public long getNonceAllowedWindow() {
        return JaxRsUtils.getLong(this.props, OAUTH2_PROVIDER__NONCE_ALLOWED_WINDOW, 2000L);
    }

    public URI getLoginRedirectURI() {
        URI loginRedirectURI = DEFAULT_OAUTH2_PROVIDER__LOGIN_REDIRECT_URI;
        String value = JaxRsUtils.get(this.props, OAUTH2_PROVIDER__LOGIN_REDIRECT_URI, null);
        if (Strings.isValid((String)value)) {
            try {
                loginRedirectURI = new URI(value);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return loginRedirectURI;
    }

    public URI getLoginRedirectErrorURI() {
        URI loginRedirectErrorURI = DEFAULT_OAUTH2_PROVIDER__LOGIN_ERROR_REDIRECT_URI;
        String value = JaxRsUtils.get(this.props, OAUTH2_PROVIDER__LOGIN_REDIRECT_ERROR_URI, null);
        if (Strings.isValid((String)value)) {
            try {
                loginRedirectErrorURI = new URI(value);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return loginRedirectErrorURI;
    }

    public boolean isIgnoreLoginRedirectBasePath() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_PROVIDER__IGNORE_LOGIN_REDIRECT_BASE_PATH, false);
    }

    public String getRealm() {
        return JaxRsUtils.get(this.props, OAUTH2_PROVIDER__REALM, DEFAULT_OAUTH2_PROVIDER__REALM);
    }

    public boolean isAudienceIsEndpointAddress() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_PROVIDER__AUDIENCE_IS_ENDPOINT_ADDRESS, false);
    }

    public boolean isBlockUnsecureRequests() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_PROVIDER__BLOCK_UNSECURED_REQUESTS, false);
    }

    public boolean isCanSupportPublicClients() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_PROVIDER__CAN_SUPPORT_PUBLIC_CLIENTS, true);
    }

    public boolean isFilterChecksFormDataForToken() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_PROVIDER__FILTER_CHECKS_FORM_DATA, false);
    }

    public boolean isHawkTokenSupported() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_PROVIDER__HAWK_TOKEN_SUPPORTED, false);
    }

    public boolean isPartialMatchScopeValidation() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_PROVIDER__PARTIAL_MATCH_SCOPE_VALIDATION, false);
    }

    public boolean isRefreshTokenAllowed() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_PROVIDER__REFRESH_TOKENS_ALLOWED, true);
    }

    public boolean isReportClientId() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_PROVIDER__REPORT_CLIENT_ID, true);
    }

    public boolean isUseRegisteredRedirectUriIfPossible() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_PROVIDER__USE_REGISTERED_REDIRECT_URI, true);
    }

    public boolean isUseUserSubject() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_PROVIDER__USE_USER_SUBJECT, false);
    }

    public boolean isWriteCustomErrors() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_PROVIDER__WRITE_CUSTOM_ERRORS, true);
    }

    public boolean isWriteOptionalParameters() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_PROVIDER__WRITE_OPTIONAL_PARAMETERS, true);
    }

    public String getSecretKeyAlgorithm() {
        return JaxRsUtils.get(this.props, OAUTH2_PROVIDER__SECRET_KEY_ALGORITHM, DEFAULT_OAUTH2_PROVIDER__SECRET_KEY_ALGORITHM);
    }

    public String getEncodedSecretKey() {
        return JaxRsUtils.get(this.props, OAUTH2_PROVIDER__ENCODED_SECRET_KEY, DEFAULT_OAUTH2_PROVIDER__ENCODED_SECRET_KEY);
    }
}

