/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.osee.framework.core.exceptionregistry.ExceptionRegistryEntry;

class ExceptionRegistry {
    Set<ExceptionRegistryEntry> set = new HashSet<ExceptionRegistryEntry>();

    ExceptionRegistry() {
    }

    void add(ExceptionRegistryEntry exceptionRegistryEntry) {
        this.set.add(exceptionRegistryEntry);
    }

    void clear() {
        this.set.clear();
    }

    void remove(ExceptionRegistryEntry exceptionRegistryEntry) {
        this.set.remove(exceptionRegistryEntry);
    }

    boolean okToLog(Throwable throwable) {
        String primaryKey = throwable.getClass().getName();
        Throwable cause = throwable.getCause();
        String secondaryKey = Objects.nonNull(cause) ? cause.getClass().getName() : "(none)";
        return !this.set.contains(new ExceptionRegistryEntry(primaryKey, secondaryKey));
    }

    List<ExceptionRegistryEntry> getList() {
        return new ArrayList<ExceptionRegistryEntry>(this.set);
    }
}

