/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.concurrent.ThreadLocalRandom;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.PLGenericDBObject;

public class NodeViewData
extends PLGenericDBObject {
    private String Description;
    private ApplicabilityToken applicability;
    private String interfaceNodeNumber;
    private String interfaceNodeGroupId;
    private String interfaceNodeBgColor = this.generateColor() ? "#81d4fa" : "#c5e1a5";
    private String interfaceNodeAddress = "";
    private String interfaceNodeNameAbbrev = "";
    private String interfaceNodeCodeGenName = "";
    private String InterfaceNodeType = "";
    private String notes = "";
    private boolean interfaceNodeCodeGen = false;
    private boolean interfaceNodeBuildCodeGen = false;
    private boolean interfaceNodeToolUse = false;

    public NodeViewData(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public NodeViewData(ArtifactReadable art) {
        super(art);
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
    }

    public NodeViewData(Long id, String name, String nodeNumber, String nodeGroupId) {
        super(id, name);
        this.setInterfaceNodeNumber(nodeNumber);
        this.setInterfaceNodeGroupId(nodeGroupId);
    }

    public NodeViewData(InterfaceNode node) {
        super(node.getId(), node.getName());
        this.setInterfaceNodeNumber(node.getNodeNumber());
        this.setInterfaceNodeGroupId(node.getNodeGroupId());
        this.setInterfaceNodeNameAbbrev(node.getInterfaceNodeNameAbbrev());
        this.setInterfaceNodeCodeGenName(node.getInterfaceNodeCodeGenName());
        this.setInterfaceNodeType(node.getInterfaceNodeType());
        this.setNotes(node.getNotes());
        this.setInterfaceNodeCodeGen(node.isInterfaceNodeCodeGen());
        this.setInterfaceNodeBuildCodeGen(node.isInterfaceNodeBuildCodeGen());
        this.setInterfaceNodeToolUse(node.isInterfaceNodeToolUse());
    }

    public NodeViewData() {
    }

    public String getinterfaceNodeBgColor() {
        return this.interfaceNodeBgColor;
    }

    public void setinterfaceNodeBgColor(String color) {
        this.interfaceNodeBgColor = color;
    }

    @JsonIgnore
    private boolean generateColor() {
        return ThreadLocalRandom.current().nextInt(1, 3) > 1;
    }

    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String description) {
        this.Description = description;
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }

    public String getInterfaceNodeAddress() {
        return this.interfaceNodeAddress;
    }

    public void setInterfaceNodeAddress(String interfaceNodeAddress) {
        this.interfaceNodeAddress = interfaceNodeAddress;
    }

    public String getInterfaceNodeNumber() {
        return this.interfaceNodeNumber;
    }

    public void setInterfaceNodeNumber(String nodeNumber) {
        this.interfaceNodeNumber = nodeNumber;
    }

    public String getInterfaceNodeGroupId() {
        return this.interfaceNodeGroupId;
    }

    public void setInterfaceNodeGroupId(String interfaceNodeGroupId) {
        this.interfaceNodeGroupId = interfaceNodeGroupId;
    }

    public String getInterfaceNodeNameAbbrev() {
        return this.interfaceNodeNameAbbrev;
    }

    public void setInterfaceNodeNameAbbrev(String interfaceNodeNameAbbrev) {
        this.interfaceNodeNameAbbrev = interfaceNodeNameAbbrev;
    }

    public String getInterfaceNodeCodeGenName() {
        return this.interfaceNodeCodeGenName;
    }

    public void setInterfaceNodeCodeGenName(String interfaceNodeCodeGenName) {
        this.interfaceNodeCodeGenName = interfaceNodeCodeGenName;
    }

    public String getInterfaceNodeType() {
        return this.InterfaceNodeType;
    }

    public void setInterfaceNodeType(String interfaceNodeType) {
        this.InterfaceNodeType = interfaceNodeType;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean isInterfaceNodeCodeGen() {
        return this.interfaceNodeCodeGen;
    }

    public void setInterfaceNodeCodeGen(boolean interfaceNodeCodeGen) {
        this.interfaceNodeCodeGen = interfaceNodeCodeGen;
    }

    public boolean isInterfaceNodeBuildCodeGen() {
        return this.interfaceNodeBuildCodeGen;
    }

    public void setInterfaceNodeBuildCodeGen(boolean interfaceNodeBuildCodeGen) {
        this.interfaceNodeBuildCodeGen = interfaceNodeBuildCodeGen;
    }

    public boolean isInterfaceNodeToolUse() {
        return this.interfaceNodeToolUse;
    }

    public void setInterfaceNodeToolUse(boolean interfaceNodeToolUse) {
        this.interfaceNodeToolUse = interfaceNodeToolUse;
    }
}

