/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.mim.InterfaceConnectionViewApi;
import org.eclipse.osee.mim.InterfaceGraphEndpoint;
import org.eclipse.osee.mim.InterfaceNodeViewApi;
import org.eclipse.osee.mim.types.ClusterView;
import org.eclipse.osee.mim.types.ConnectionView;
import org.eclipse.osee.mim.types.GraphView;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.NodeView;

public class InterfaceGraphEndpointImpl
implements InterfaceGraphEndpoint {
    private final BranchId branch;
    private final InterfaceNodeViewApi interfaceNodeApi;
    private final InterfaceConnectionViewApi interfaceConnectionApi;

    public InterfaceGraphEndpointImpl(BranchId branch, InterfaceNodeViewApi interfaceNodeApi, InterfaceConnectionViewApi interfaceConnectionViewApi) {
        this.branch = branch;
        this.interfaceNodeApi = interfaceNodeApi;
        this.interfaceConnectionApi = interfaceConnectionViewApi;
    }

    @Override
    public GraphView getAllNodesAndEdges(ArtifactId viewId) {
        try {
            GraphView graph = new GraphView();
            graph.setEdges(new LinkedList<ConnectionView>());
            graph.setNodes(new LinkedList<NodeView>());
            graph.setClusters(new LinkedList<ClusterView>());
            Collection<InterfaceNode> nodes = this.interfaceNodeApi.getAccessor().getAll(this.branch, viewId);
            Collection<InterfaceConnection> edges = this.interfaceConnectionApi.getAll(this.branch, viewId);
            for (InterfaceNode node : nodes) {
                graph.addNode(new NodeView(node));
                if (node.getNodeGroupId().isEmpty()) continue;
                String clusterId = node.getNodeGroupId();
                ClusterView cluster = graph.getClusters().stream().filter(c -> c.getId().equals(clusterId)).findFirst().orElse(null);
                if (cluster == null) {
                    cluster = new ClusterView(clusterId);
                    graph.getClusters().add(cluster);
                }
                cluster.getChildNodeIds().add(node.getIdString());
            }
            graph.getClusters().removeIf(c -> c.getChildNodeIds().size() < 2);
            for (InterfaceConnection connection : edges) {
                if (connection.getNodes().size() <= 1) continue;
                graph.addEdges(new ConnectionView(connection));
            }
            return graph;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }
}

