/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.console.admin.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.console.admin.ConsoleCommand;
import org.eclipse.osee.console.admin.internal.CommandDispatcher;
import org.eclipse.osee.console.admin.internal.CommandProviderImpl;
import org.eclipse.osee.console.admin.internal.ConsoleAdminUtils;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.logger.Log;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ConsoleAdmin {
    private final Map<ConsoleCommand, Map<String, String>> pending = new ConcurrentHashMap<ConsoleCommand, Map<String, String>>();
    private Log logger;
    private ExecutorAdmin executorAdmin;
    private CommandDispatcher dispatcher;
    private Thread thread;
    private ServiceRegistration<?> cmdRef;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setExecutorAdmin(ExecutorAdmin executorAdmin) {
        this.executorAdmin = executorAdmin;
    }

    public ExecutorAdmin getExecutorAdmin() {
        return this.executorAdmin;
    }

    public Log getLogger() {
        return this.logger;
    }

    public void start(BundleContext context) throws Exception {
        this.dispatcher = new CommandDispatcher(this.getLogger(), this.getExecutorAdmin());
        this.thread = new Thread("Register Pending Osee Console Commands"){

            @Override
            public void run() {
                for (Map.Entry<ConsoleCommand, Map<String, String>> entry : ConsoleAdmin.this.pending.entrySet()) {
                    ConsoleAdmin.this.register(entry.getKey(), entry.getValue());
                }
                ConsoleAdmin.this.pending.clear();
            }
        };
        this.thread.start();
        CommandProviderImpl command = new CommandProviderImpl();
        command.setConsoleAdmin(this);
        this.cmdRef = context.registerService(CommandProvider.class.getName(), (Object)command, null);
    }

    public void stop(BundleContext context) {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
        if (this.cmdRef != null) {
            this.cmdRef.unregister();
            this.cmdRef = null;
        }
    }

    private boolean isReady() {
        return this.getDispatcher() != null && this.getLogger() != null;
    }

    public void addCommand(ConsoleCommand reference, Map<String, String> props) {
        if (this.isReady()) {
            this.register(reference, props);
        } else {
            this.pending.put(reference, props);
        }
    }

    public void removeCommand(ConsoleCommand reference, Map<String, String> props) {
        if (this.isReady()) {
            this.unregister(reference, props);
        } else {
            this.pending.remove(reference);
        }
    }

    private void unregister(ConsoleCommand reference, Map<String, String> props) {
        String componentName = ConsoleAdminUtils.getComponentName(props);
        String contextName = ConsoleAdminUtils.getContextName(props);
        this.getDispatcher().unregister(componentName);
        this.getLogger().debug("De-registering command for [%s] with alias [%s]", new Object[]{componentName, contextName});
    }

    private void register(ConsoleCommand consoleCommand, Map<String, String> props) {
        String componentName = ConsoleAdminUtils.getComponentName(props);
        String contextName = ConsoleAdminUtils.getContextName(props);
        try {
            this.getDispatcher().register(componentName, consoleCommand);
            this.getLogger().debug("Registered command for [%s] with alias [%s]", new Object[]{componentName, contextName});
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public CommandDispatcher getDispatcher() {
        return this.dispatcher;
    }
}

