/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.ast;

import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.TextContainer;
import com.vladsch.flexmark.util.misc.BitFieldSet;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.builder.BasedSegmentBuilder;
import com.vladsch.flexmark.util.sequence.builder.ISequenceBuilder;
import com.vladsch.flexmark.util.sequence.builder.SegmentOptimizer;
import com.vladsch.flexmark.util.sequence.builder.SequenceBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpaceInsertingSequenceBuilder
implements ISequenceBuilder<SpaceInsertingSequenceBuilder, BasedSequence> {
    final SequenceBuilder out;
    Node lastNode;
    boolean needEol;
    final boolean addSpacesBetweenNodes;
    boolean addSpaces;

    @NotNull
    public static SpaceInsertingSequenceBuilder emptyBuilder(@NotNull BasedSequence base) {
        return new SpaceInsertingSequenceBuilder(SequenceBuilder.emptyBuilder((BasedSequence)base), false);
    }

    @NotNull
    public static SpaceInsertingSequenceBuilder emptyBuilder(@NotNull BasedSequence base, @NotNull SegmentOptimizer optimizer) {
        return new SpaceInsertingSequenceBuilder(SequenceBuilder.emptyBuilder((BasedSequence)base, (SegmentOptimizer)optimizer), false);
    }

    @NotNull
    public static SpaceInsertingSequenceBuilder emptyBuilder(@NotNull BasedSequence base, int options) {
        return new SpaceInsertingSequenceBuilder(SequenceBuilder.emptyBuilder((BasedSequence)base, (int)options), BitFieldSet.any((long)options, (long)TextContainer.F_ADD_SPACES_BETWEEN_NODES));
    }

    @NotNull
    public static SpaceInsertingSequenceBuilder emptyBuilder(@NotNull BasedSequence base, int options, @NotNull SegmentOptimizer optimizer) {
        return new SpaceInsertingSequenceBuilder(SequenceBuilder.emptyBuilder((BasedSequence)base, (int)options, (SegmentOptimizer)optimizer), BitFieldSet.any((long)options, (long)TextContainer.F_ADD_SPACES_BETWEEN_NODES));
    }

    @NotNull
    public static SpaceInsertingSequenceBuilder emptyBuilder(@NotNull SequenceBuilder builder) {
        return new SpaceInsertingSequenceBuilder(builder, false);
    }

    private SpaceInsertingSequenceBuilder(SequenceBuilder out, boolean addSpacesBetweenNodes) {
        this.out = out;
        this.addSpacesBetweenNodes = addSpacesBetweenNodes;
    }

    public SequenceBuilder getOut() {
        return this.out;
    }

    public char charAt(int index) {
        return this.out.charAt(index);
    }

    public boolean isNeedEol() {
        return this.needEol;
    }

    public void setNeedEol(boolean needEol) {
        this.needEol = needEol;
    }

    public Node getLastNode() {
        return this.lastNode;
    }

    public void setLastNode(Node lastNode) {
        if (lastNode instanceof Document) {
            return;
        }
        if (this.lastNode != null && this.lastNode.getEndOffset() < lastNode.getStartOffset()) {
            BasedSequence sequence = this.getBaseSequence().subSequence(this.lastNode.getEndOffset(), lastNode.getStartOffset());
            this.needEol = ((BasedSequence)sequence.trim(CharPredicate.SPACE_TAB)).length() > 0 && ((BasedSequence)sequence.trim(CharPredicate.WHITESPACE)).isEmpty();
        }
        this.addSpaces = this.addSpacesBetweenNodes;
        this.lastNode = lastNode;
    }

    public boolean needSpace() {
        for (int partIndex = this.out.getSegmentBuilder().size(); partIndex >= 0; --partIndex) {
            CharSequence sequence;
            Object part = this.out.getSegmentBuilder().getPart(partIndex);
            if (part instanceof Range) {
                if (!((Range)part).isNotNull() || (sequence = this.getBaseSequence().subSequence(((Range)part).getStart(), ((Range)part).getEnd())).length() <= 0) continue;
                return !CharPredicate.WHITESPACE.test(sequence.charAt(sequence.length() - 1));
            }
            if (part instanceof CharSequence) {
                sequence = (CharSequence)part;
                if (sequence.length() <= 0) continue;
                return !CharPredicate.WHITESPACE.test(sequence.charAt(sequence.length() - 1));
            }
            throw new IllegalStateException("Invalid part type " + part.getClass().getSimpleName());
        }
        return false;
    }

    public void appendEol() {
        this.append('\n');
        this.needEol = false;
    }

    public boolean needEol() {
        if (this.needEol) {
            return true;
        }
        for (int partIndex = this.out.getSegmentBuilder().size(); partIndex >= 0; --partIndex) {
            CharSequence sequence;
            Object part = this.out.getSegmentBuilder().getPart(partIndex);
            if (part instanceof Range) {
                if (!((Range)part).isNotNull() || (sequence = this.getBaseSequence().subSequence(((Range)part).getStart(), ((Range)part).getEnd())).length() <= 0) continue;
                return !CharPredicate.EOL.test(sequence.charAt(sequence.length() - 1));
            }
            if (part instanceof CharSequence) {
                sequence = (CharSequence)part;
                if (sequence.length() <= 0) continue;
                return !CharPredicate.EOL.test(sequence.charAt(sequence.length() - 1));
            }
            throw new IllegalStateException("Invalid part type " + part.getClass().getSimpleName());
        }
        return false;
    }

    @NotNull
    public BasedSequence getBaseSequence() {
        return this.out.getBaseSequence();
    }

    @NotNull
    public BasedSegmentBuilder getSegmentBuilder() {
        return this.out.getSegmentBuilder();
    }

    @Nullable
    public BasedSequence getSingleBasedSequence() {
        return this.out.getSingleBasedSequence();
    }

    @NotNull
    public SpaceInsertingSequenceBuilder getBuilder() {
        return new SpaceInsertingSequenceBuilder(this.out.getBuilder(), this.addSpacesBetweenNodes);
    }

    @NotNull
    public SpaceInsertingSequenceBuilder append(@Nullable CharSequence chars, int startIndex, int endIndex) {
        if (this.addSpaces && chars != null && startIndex < endIndex && !CharPredicate.WHITESPACE.test(chars.charAt(startIndex)) && this.needSpace()) {
            this.out.append(' ');
            this.addSpaces = false;
        }
        this.out.append(chars, startIndex, endIndex);
        return this;
    }

    @NotNull
    public SpaceInsertingSequenceBuilder append(char c) {
        if (this.addSpaces && !CharPredicate.WHITESPACE.test(c) && this.needSpace()) {
            this.out.append(' ');
            this.addSpaces = false;
        }
        this.out.append(c);
        return this;
    }

    @NotNull
    public SpaceInsertingSequenceBuilder append(char c, int count) {
        if (this.addSpaces && !CharPredicate.WHITESPACE.test(c) && this.needSpace()) {
            this.out.append(' ');
            this.addSpaces = false;
        }
        this.out.append(c, count);
        return this;
    }

    @NotNull
    public SpaceInsertingSequenceBuilder append(int startOffset, int endOffset) {
        if (this.addSpaces && startOffset < endOffset && !CharPredicate.WHITESPACE.test(this.out.getBaseSequence().charAt(startOffset)) && this.needSpace()) {
            this.out.append(' ');
            this.addSpaces = false;
        }
        this.out.append(startOffset, endOffset);
        return this;
    }

    @NotNull
    public SpaceInsertingSequenceBuilder append(@NotNull Range chars) {
        return this.append(chars.getStart(), chars.getEnd());
    }

    @NotNull
    public SpaceInsertingSequenceBuilder addRange(@NotNull Range range) {
        return this.append(range.getStart(), range.getEnd());
    }

    @NotNull
    public SpaceInsertingSequenceBuilder addByOffsets(int startOffset, int endOffset) {
        return this.append(startOffset, endOffset);
    }

    @NotNull
    public SpaceInsertingSequenceBuilder addByLength(int startOffset, int textLength) {
        return this.append(startOffset, startOffset + textLength);
    }

    @NotNull
    public BasedSequence toSequence() {
        return this.out.toSequence();
    }

    public int length() {
        return this.out.length();
    }

    @NotNull
    public String toStringWithRanges() {
        return this.out.toStringWithRanges();
    }

    public String toString() {
        return this.out.toString();
    }

    public String toStringNoAddedSpaces() {
        return this.out.toStringNoAddedSpaces();
    }

    @NotNull
    public SpaceInsertingSequenceBuilder addAll(Iterable<? extends CharSequence> sequences) {
        return this.append((Iterable)sequences);
    }

    @NotNull
    public SpaceInsertingSequenceBuilder append(Iterable<? extends CharSequence> sequences) {
        for (CharSequence charSequence : sequences) {
            this.append(charSequence);
        }
        return this;
    }

    @NotNull
    public SpaceInsertingSequenceBuilder add(@Nullable CharSequence chars) {
        return this.append(chars);
    }

    @NotNull
    public SpaceInsertingSequenceBuilder append(@Nullable CharSequence chars) {
        return chars == null ? this : this.append(chars, 0, chars.length());
    }

    @NotNull
    public SpaceInsertingSequenceBuilder append(@Nullable CharSequence chars, int startIndex) {
        return chars == null ? this : this.append(chars, startIndex, chars.length());
    }
}

