/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.workflow.WorkState;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.api.workflow.state.IAtsWorkStateFactory;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class AtsWorkStateFactory
implements IAtsWorkStateFactory {
    public Pattern storagePattern = Pattern.compile("^(.*?);(.*?);(.*?);(.*?)$");
    public Pattern userPattern = Pattern.compile("<(.*?)>");
    private final IAtsUserService userService;

    public AtsWorkStateFactory(IAtsUserService userService) {
        this.userService = userService;
    }

    public String toStoreStr(IAtsStateManager stateMgr, String stateName) {
        StringBuffer sb = new StringBuffer(stateName);
        sb.append(";");
        sb.append(this.getStorageString(stateMgr.getAssignees(stateName)));
        sb.append(";;");
        return sb.toString();
    }

    public WorkState fromStoreStr(String storeStr) {
        WorkState state = WorkState.create((String)"Unknown");
        if (Strings.isValid((String)storeStr)) {
            Matcher m = this.storagePattern.matcher(storeStr);
            if (m.find()) {
                state.setName(m.group(1));
                if (!m.group(3).equals("")) {
                    state.setHoursSpent(Float.valueOf(m.group(3)).doubleValue());
                }
                if (!m.group(4).equals("")) {
                    state.setPercentComplete(Integer.valueOf(m.group(4)).intValue());
                }
                String userStr = m.group(2);
                List<AtsUser> users = this.getUsers(userStr);
                state.setAssignees(users);
            } else {
                throw new OseeArgumentException("Can't unpack state data [%s]", new Object[]{storeStr});
            }
        }
        return state;
    }

    public String getStorageString(Collection<AtsUser> users) {
        StringBuffer sb = new StringBuffer();
        for (AtsUser u : users) {
            sb.append("<" + u.getUserId() + ">");
        }
        return sb.toString();
    }

    public List<AtsUser> getUsers(String sorageString) {
        ArrayList<AtsUser> users = new ArrayList<AtsUser>();
        Matcher m = this.userPattern.matcher(sorageString);
        while (m.find()) {
            String userId = m.group(1);
            if (!Strings.isValid((String)userId)) {
                throw new IllegalArgumentException("Blank userId specified.");
            }
            try {
                String uId = m.group(1);
                AtsUser u = this.userService.getUserByUserId(uId);
                Conditions.checkNotNull((Object)u, (String)("userById " + uId));
                users.add(u);
            }
            catch (Exception ex) {
                OseeLog.log(AtsWorkStateFactory.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return users;
    }
}

