/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.column.ev;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumn;
import org.eclipse.osee.ats.api.column.IWorkPackageColumn;
import org.eclipse.osee.ats.api.ev.IAtsEarnedValueServiceProvider;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public abstract class AbstractRelatedWorkPackageColumn
implements AtsColumn,
IWorkPackageColumn {
    private final IAtsEarnedValueServiceProvider earnedValueServiceProvider;
    private Map<ArtifactId, ArtifactToken> idToWorkPackage = new HashMap<ArtifactId, ArtifactToken>();
    protected final AtsApi atsApi;

    public AbstractRelatedWorkPackageColumn(IAtsEarnedValueServiceProvider earnedValueServiceProvider, AtsApi atsApi) {
        this.earnedValueServiceProvider = earnedValueServiceProvider;
        this.atsApi = atsApi;
    }

    public void setIdToWorkPackageCache(Map<ArtifactId, ArtifactToken> idToWorkPackage) {
        this.idToWorkPackage = idToWorkPackage;
    }

    public String getColumnText(IAtsObject atsObject) {
        String result = "";
        try {
            ArtifactId workPackageId;
            if (atsObject instanceof IAtsWorkItem && (workPackageId = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackageId((IAtsWorkItem)atsObject)).isValid()) {
                IAtsWorkPackage workPkg;
                IAtsWorkPackage workPkg2;
                ArtifactToken wpArt;
                if (this.idToWorkPackage != null && (wpArt = this.idToWorkPackage.get(workPackageId)) != null && Strings.isInValid((String)(result = this.getColumnValue(wpArt))) && (workPkg2 = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackage((ArtifactId)wpArt)) != null) {
                    result = this.getColumnValue(workPkg2);
                }
                if (Strings.isInValid((String)result) && (workPkg = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackage((IAtsWorkItem)atsObject)) != null) {
                    result = this.getColumnValue(workPkg);
                    if (this.idToWorkPackage != null) {
                        this.idToWorkPackage.put(workPackageId, workPkg.getStoreObject());
                    }
                }
            }
        }
        catch (OseeCoreException ex) {
            result = "!Error - " + ex.getLocalizedMessage();
        }
        return result;
    }

    protected abstract String getColumnValue(ArtifactToken var1);

    protected abstract String getColumnValue(IAtsWorkPackage var1);
}

