/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing.templatemanager;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.osee.define.operations.publishing.templatemanager.AbstractPublishingTemplateCache;
import org.eclipse.osee.define.operations.publishing.templatemanager.ArtifactPublishingTemplate;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateCache;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;

class ArtifactPublishingTemplateCache
extends AbstractPublishingTemplateCache {
    private static ArtifactPublishingTemplateCache artifactPublishingTemplateCache = null;
    private final OrcsApi orcsApi;

    private ArtifactPublishingTemplateCache(Log logger, OrcsApi orcsApi) {
        super(logger);
        this.orcsApi = orcsApi;
    }

    static synchronized PublishingTemplateCache create(Log logger, OrcsApi orcsApi) {
        return Objects.nonNull(artifactPublishingTemplateCache) ? artifactPublishingTemplateCache : (artifactPublishingTemplateCache = new ArtifactPublishingTemplateCache(logger, orcsApi));
    }

    Optional<ArtifactPublishingTemplate> createPublishingTemplate(ArtifactReadable artifactReadable) {
        try {
            return Optional.of(new ArtifactPublishingTemplate(artifactReadable));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, "ArtifactPublishingTemplateCache::createPublishingTemplate, Invalid Publishing Template.", new Object[0]);
            return Optional.empty();
        }
    }

    @Override
    public synchronized void loadTemplates() {
        if (Objects.isNull(this.list)) {
            this.list = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.RendererTemplateWholeWord}).getResults().getList().stream().map(this::createPublishingTemplate).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toUnmodifiableList());
        }
    }
}

