/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.type.CountingMap;
import org.eclipse.osee.jdbc.ObjectType;
import org.eclipse.osee.jdbc.SqlTable;
import org.eclipse.osee.orcs.core.ds.DynamicData;
import org.eclipse.osee.orcs.core.ds.DynamicObject;
import org.eclipse.osee.orcs.core.ds.ResultObjectDescription;
import org.eclipse.osee.orcs.core.ds.SelectSet;
import org.eclipse.osee.orcs.db.internal.sql.ObjectField;
import org.eclipse.osee.orcs.db.internal.sql.SqlAliasManager;

public final class SqlFieldResolver {
    private final SqlAliasManager aliasManager;
    private final List<DynamicData> unresolved = new ArrayList<DynamicData>();
    private final CountingMap<String> counter = new CountingMap();
    private final Iterable<SelectSet> selectSets;
    private boolean selectsProcessed;
    private static final String OBJECT_FIELD = "sql.object.field";
    private static final String COLUMN_INFO = "sql.column.info";

    public SqlFieldResolver(SqlAliasManager aliasManager, Iterable<SelectSet> selectSets) {
        this.aliasManager = aliasManager;
        this.selectSets = selectSets;
    }

    public void reset() {
        this.counter.clear();
        this.unresolved.clear();
        this.selectsProcessed = false;
    }

    public boolean hasUnresolvedFields() {
        return this.unresolved != null && !this.unresolved.isEmpty();
    }

    public Iterable<DynamicData> getUnresolved() {
        return this.unresolved;
    }

    public Iterable<String> getSortFields() {
        LinkedHashMap<ObjectField, String> fieldToColumn = new LinkedHashMap<ObjectField, String>();
        for (SelectSet selectSet : this.selectSets) {
            DynamicData data = selectSet.getData();
            if (data == null) continue;
            this.loadRequiredFields(data, fieldToColumn);
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        HashSet<ObjectField.Family> processed = new HashSet<ObjectField.Family>();
        for (Map.Entry entry : fieldToColumn.entrySet()) {
            ObjectField key = (ObjectField)((Object)entry.getKey());
            ObjectField.Family family = key.getFamily();
            if (!processed.add(family)) continue;
            for (ObjectField field : ObjectField.getRequiredFieldsFor(family)) {
                String column = (String)fieldToColumn.get((Object)field);
                toReturn.add(column);
            }
        }
        return toReturn;
    }

    private void loadRequiredFields(DynamicData data, Map<ObjectField, String> fieldToColumn) {
        if (data instanceof DynamicObject) {
            DynamicObject object = (DynamicObject)data;
            for (DynamicData child : object.getChildren()) {
                this.loadRequiredFields(child, fieldToColumn);
            }
        } else {
            ObjectField objectField = SqlFieldResolver.getObjectField(data);
            if (objectField != null && objectField.isRequired()) {
                String uniqueId = SqlFieldResolver.getColumnUniqueId(data);
                fieldToColumn.put(objectField, uniqueId);
            }
        }
    }

    public ResultObjectDescription getResult() {
        final ArrayList<DynamicData> datas = new ArrayList<DynamicData>();
        for (SelectSet selectSet : this.selectSets) {
            DynamicData data = selectSet.getData();
            if (data == null) continue;
            datas.add(data);
        }
        return new ResultObjectDescription(){

            public Iterable<? extends DynamicData> getDynamicData() {
                return datas;
            }
        };
    }

    private String getQualifiedName(String alias, String columnName) {
        return String.format("%s.%s", alias, columnName);
    }

    public void resolve() {
        if (!this.selectsProcessed) {
            this.selectsProcessed = true;
            this.processSelects();
        } else {
            this.processUnresolved();
        }
    }

    private void processSelects() {
        for (SelectSet selectSet : this.selectSets) {
            DynamicData data = selectSet.getData();
            if (data == null) continue;
            this.processData(data);
        }
    }

    private void processData(DynamicData data) {
        if (data instanceof DynamicObject) {
            DynamicObject object = (DynamicObject)data;
            for (DynamicData child : object.getChildren()) {
                this.processData(child);
            }
            this.addRequiredFields(object);
        } else {
            this.processField(data, false);
        }
    }

    private void addRequiredFields(DynamicObject object) {
        ObjectField.Family family = null;
        int level = object.getLevel();
        HashSet<ObjectField> fields = new HashSet<ObjectField>();
        for (DynamicData child : object.getChildren()) {
            ObjectField objectField;
            String fieldId = (String)child.getGuid();
            if (fieldId == null || (objectField = ObjectField.fromString(fieldId)) == null) continue;
            family = objectField.getFamily();
            fields.add(objectField);
            level = child.getLevel();
        }
        if (family != null && !fields.isEmpty()) {
            Set<ObjectField> required = ObjectField.getRequiredFieldsFor(family);
            Sets.SetView missing = Sets.difference(required, fields);
            int index = 0;
            for (ObjectField field : missing) {
                String fieldId = field.name();
                DynamicData data = new DynamicData(fieldId, null);
                data.setLevel(level);
                data.setFieldName(fieldId);
                this.processField(data, true);
                object.addChild(index++, data);
            }
        }
    }

    private void processField(DynamicData data, boolean hidden) {
        String fieldId = (String)data.getGuid();
        if (fieldId != null) {
            ObjectField field = SqlFieldResolver.getObjectField(data);
            if (field == null) {
                field = ObjectField.fromString(fieldId);
                SqlFieldResolver.setObjectField(data, field);
            }
            int level = data.getLevel();
            data.setPrimaryKey(field.isPrimaryKey());
            data.setHidden(hidden);
            SqlTable table = field.getTable();
            ObjectType type = field.getType();
            String alias = this.aliasManager.getFirstAlias(level, table, type);
            if (alias != null) {
                this.resolve(data, field, alias);
            } else {
                this.unresolved.add(data);
            }
        }
    }

    private void resolve(DynamicData data, ObjectField field, String alias) {
        String[] columnNames;
        LinkedHashMap columnData = Maps.newLinkedHashMap();
        String[] stringArray = columnNames = field.getColumnNames();
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            String columnUuid = field.isComposite() ? String.format("%s_%s", columnName, this.nextColumnIndex(columnName)) : String.format("%s_%s", field.name(), this.nextColumnIndex(columnName));
            String qualifiedColumn = this.getQualifiedName(alias, columnName);
            columnData.put(columnUuid, qualifiedColumn);
            ++n2;
        }
        SqlFieldResolver.setColumnInfo(data, columnData);
    }

    private int nextColumnIndex(String columnName) {
        this.counter.put((Object)columnName);
        return this.counter.get((Object)columnName);
    }

    private void processUnresolved() {
        Iterator<DynamicData> iterator = this.getUnresolved().iterator();
        while (iterator.hasNext()) {
            DynamicData data = iterator.next();
            ObjectField field = SqlFieldResolver.getObjectField(data);
            int level = data.getLevel();
            String alias = this.aliasManager.getFirstAlias(level, field.getTable(), field.getType());
            if (alias == null) continue;
            this.resolve(data, field, alias);
            iterator.remove();
        }
    }

    public static void setObjectField(DynamicData data, ObjectField field) {
        data.put(OBJECT_FIELD, (Object)field);
    }

    public static ObjectField getObjectField(DynamicData data) {
        return (ObjectField)((Object)data.getObject(OBJECT_FIELD));
    }

    public static void setColumnInfo(DynamicData data, Map<String, String> columnData) {
        data.put(COLUMN_INFO, columnData);
    }

    public static Map<String, String> getColumnInfo(DynamicData data) {
        Map<String, String> columnData = (Map<String, String>)data.getObject(COLUMN_INFO);
        return columnData != null ? columnData : Collections.emptyMap();
    }

    public static Collection<String> getColumnUniqueIds(DynamicData data) {
        return SqlFieldResolver.getColumnInfo(data).keySet();
    }

    public static String getColumnUniqueId(DynamicData data) {
        return (String)Iterables.getFirst(SqlFieldResolver.getColumnUniqueIds(data), null);
    }
}

