/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerUtils;

public class ServerHealthBalancers {
    private final JdbcClient jdbcClient;

    public ServerHealthBalancers(JdbcClient jdbcClient) {
        this.jdbcClient = jdbcClient;
    }

    public String getHtml() {
        List<String> servers = ServerUtils.getServers(this.jdbcClient);
        if (servers.size() == 0) {
            return AHTML.simplePage((String)"No application.servers configured in osee.json file");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<h3>Load Blancer Status</h3>");
        sb.append(AHTML.beginMultiColumnTable((int)95, (int)3));
        LinkedList<String> headers = new LinkedList<String>();
        headers = new LinkedList();
        headers.add("Name");
        headers.add("Alive");
        sb.append(AHTML.addHeaderRowMultiColumnTable(headers));
        this.getBlanacerManagers(sb, servers);
        sb.append(AHTML.endMultiColumnTable());
        String html = AHTML.simplePage((String)sb.toString());
        return html;
    }

    private void getBlanacerManagers(StringBuilder sb, List<String> servers) {
        ArrayList<String> mgrVisited = new ArrayList<String>();
        for (String server : servers) {
            LinkedList<String> values = new LinkedList<String>();
            if (!mgrVisited.contains(server = server.replaceFirst(":.*$", ""))) {
                String balMgrUrl = "http://" + server + "/balancer-manager";
                values.add(AHTML.getHyperlinkNewTab((String)balMgrUrl, (String)server));
                try {
                    String results = ServerUtils.getUrlResults(balMgrUrl);
                    if (results.contains("Load Balancer Manager")) {
                        values.add(ServerUtils.getImage("greenDot.png", balMgrUrl));
                    } else {
                        values.add(ServerUtils.getImage("redDot.png", balMgrUrl));
                    }
                }
                catch (Exception exception) {
                    values.add(ServerUtils.getImage("redDot.png", balMgrUrl));
                }
                mgrVisited.add(server);
            }
            sb.append(AHTML.addRowMultiColumnTable((String[])values.toArray(new String[values.size()])));
        }
    }
}

