/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.JsonArtifact;
import org.eclipse.osee.framework.core.data.JsonAttribute;
import org.eclipse.osee.framework.core.data.JsonRelation;
import org.eclipse.osee.framework.core.data.JsonRelations;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionResult;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UpdateBranchData;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.dto.ChangeReportRowDto;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Compare;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.data.ArchiveOperation;
import org.eclipse.osee.orcs.data.CreateBranchData;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.rest.internal.OrcsRestUtil;
import org.eclipse.osee.orcs.rest.internal.branch.UpdateBranchOperation;
import org.eclipse.osee.orcs.rest.model.BranchCommitOptions;
import org.eclipse.osee.orcs.rest.model.BranchEndpoint;
import org.eclipse.osee.orcs.rest.model.BranchQueryData;
import org.eclipse.osee.orcs.rest.model.NewBranch;
import org.eclipse.osee.orcs.rest.model.NewTransaction;
import org.eclipse.osee.orcs.rest.model.Transaction;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class BranchEndpointImpl
implements BranchEndpoint {
    private final OrcsApi orcsApi;
    private final ActivityLog activityLog;
    private final OrcsBranch branchOps;
    private static final String OTHER_EDIT_SQL = "select txs.mod_type, br.branch_id from osee_attribute att, osee_txs txs, osee_branch br where att.art_id = ? and att.gamma_id = txs.gamma_id and txs.branch_id = br.branch_id and txs.transaction_id <> br.baseline_transaction_id and txs.tx_current <> 0 and  br.branch_id <> ? and br.branch_type = ? and br.branch_state = ? AND NOT EXISTS (SELECT 1 FROM osee_txs txs1 WHERE txs1.branch_id = br.branch_id AND txs1.transaction_id = br.baseline_transaction_id AND txs1.gamma_id = txs.gamma_id AND txs1.mod_type = txs.mod_type)";
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpHeaders httpHeaders;

    public BranchEndpointImpl(OrcsApi orcsApi, ActivityLog activityLog) {
        this.orcsApi = orcsApi;
        this.activityLog = activityLog;
        this.branchOps = orcsApi.getBranchOps();
    }

    public HttpHeaders getHeaders() {
        return this.httpHeaders;
    }

    public void setHeaders(HttpHeaders httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    private QueryFactory newQuery() {
        return this.orcsApi.getQueryFactory();
    }

    private BranchQuery newBranchQuery() {
        return this.newQuery().branchQuery();
    }

    private TransactionQuery newTxQuery() {
        return this.newQuery().transactionQuery();
    }

    private TransactionReadable getTxByBranchAndId(BranchId branch, TransactionId txId) {
        return (TransactionReadable)((TransactionQuery)((TransactionQuery)this.newTxQuery().andBranch(new BranchId[]{branch})).andTxId(txId)).getResults().getExactlyOne();
    }

    private TransactionFactory newTxFactory() {
        return this.orcsApi.getTransactionFactory();
    }

    public List<Branch> getBranches(BranchQueryData options) {
        ResultSet<Branch> results = this.searchBranches(options);
        return results.getList();
    }

    public List<Branch> getBranches(String branchUuids, String branchTypes, String branchStates, boolean deleted, boolean archived, String nameEquals, String namePattern, Long childOf, Long ancestorOf, BranchCategoryToken category) {
        int n;
        int n2;
        String[] stringArray;
        BranchQueryData options = new BranchQueryData();
        options.setBranchIds((Collection)Collections.fromString((String)branchUuids, (String)",", BranchId::valueOf));
        if (Strings.isValid((String)branchTypes)) {
            LinkedList<BranchType> branchTypeVals = new LinkedList<BranchType>();
            stringArray = branchTypes.split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String branchType = stringArray[n];
                branchTypeVals.add(BranchType.fromName((String)branchType.toUpperCase()));
                ++n;
            }
            options.setBranchTypes(branchTypeVals);
        }
        if (Strings.isValid((String)branchStates)) {
            LinkedList<BranchState> branchStateVals = new LinkedList<BranchState>();
            stringArray = branchStates.split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String branchState = stringArray[n];
                branchStateVals.add(BranchState.fromName((String)branchState.toUpperCase()));
                ++n;
            }
            options.setBranchStates(branchStateVals);
        }
        options.setIncludeDeleted(deleted);
        options.setIncludeArchived(archived);
        if (Strings.isValid((String)nameEquals)) {
            options.setNameEquals(nameEquals);
        }
        if (Strings.isValid((String)namePattern)) {
            options.setNamePattern(namePattern);
        }
        if (childOf != null) {
            options.setIsChildOf(childOf);
        }
        if (ancestorOf != null) {
            options.setIsAncestorOf(ancestorOf);
        }
        if (category != null) {
            options.setCategory(category);
        }
        return this.getBranches(options);
    }

    public List<Branch> getBaselineBranches() {
        return ((BranchQuery)((BranchQuery)((BranchQuery)this.newBranchQuery().includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.BASELINE})).getResults().getList();
    }

    public List<Branch> getWorkingBranches() {
        return ((BranchQuery)((BranchQuery)((BranchQuery)this.newBranchQuery().includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.WORKING})).getResults().getList();
    }

    public List<Branch> getWorkingBranches(String value, List<String> artAttrPairs, BranchId mapBranchId) {
        BranchQuery query = (BranchQuery)((BranchQuery)((BranchQuery)this.newBranchQuery().includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.WORKING});
        if (!value.isEmpty() && !artAttrPairs.isEmpty() && mapBranchId.isValid()) {
            ArrayList<Pair> pairs = new ArrayList<Pair>();
            for (String artAttrType : artAttrPairs) {
                pairs.add(new Pair((Object)ArtifactTypeToken.valueOf((String)artAttrType.substring(0, artAttrType.indexOf(","))), (Object)AttributeTypeToken.valueOf((String)artAttrType.substring(artAttrType.indexOf(",") + 1))));
            }
            query = (BranchQuery)query.mapAssocArtIdToRelatedAttributes(value, mapBranchId, pairs);
        }
        return query.getResults().getList();
    }

    public Branch getBranchById(BranchId branch) {
        return (Branch)((BranchQuery)((BranchQuery)((BranchQuery)this.newBranchQuery().andId(branch)).includeArchived()).includeDeleted()).getResults().getExactlyOne();
    }

    public List<Branch> getBranchesByCategory(BranchCategoryToken id) {
        if (this.newBranchQuery().andIsOfCategory(id) == null) {
            throw new OseeCoreException("Branch Query is of category returns null", new Object[0]);
        }
        return ((BranchQuery)this.newBranchQuery().andIsOfCategory(id)).getResults().getList();
    }

    public List<Branch> getBranchesByCategoryAndType(String type, BranchCategoryToken category) {
        return ((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)this.newBranchQuery().includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.fromName((String)type.toUpperCase())})).andIsOfCategory(category)).getResults().getList();
    }

    public List<BranchCategoryToken> getBranchCategories(BranchId branch) {
        return this.newBranchQuery().getBranchCategories(branch);
    }

    public XResultData setBranchCategory(BranchId branch, BranchCategoryToken category) {
        if (!this.getBranchCategories(branch).contains(category)) {
            return this.branchOps.setBranchCategory(branch, category);
        }
        XResultData result = new XResultData();
        result.setTitle("Setting branch category");
        result.error("Branch already has category: " + category.getName());
        return result;
    }

    public XResultData deleteBranchCategory(BranchId branch, BranchCategoryToken category) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        return this.branchOps.deleteBranchCategory(branch, category);
    }

    public List<Transaction> getAllBranchTxs(BranchId branch) {
        return OrcsRestUtil.asTransactions((ResultSet<? extends TransactionReadable>)((TransactionQuery)this.newTxQuery().andBranch(new BranchId[]{branch})).getResults());
    }

    public Transaction getBranchTx(BranchId branchUuid, TransactionId txId) {
        return OrcsRestUtil.asTransaction(this.getTxByBranchAndId(branchUuid, txId));
    }

    public Transaction getBranchLatestTx(BranchId branch) {
        return OrcsRestUtil.asTransaction((TransactionReadable)((TransactionQuery)this.newTxQuery().andIsHead(branch)).getResults().getExactlyOne());
    }

    public List<JsonArtifact> getArtifactDetailsByType(BranchId branchId, String artifactTypes) {
        return this.getArtifactDetailsByType(branchId, ArtifactId.SENTINEL, artifactTypes);
    }

    public List<JsonArtifact> getArtifactDetailsByType(BranchId branchId, ArtifactId viewId, String artifactTypes) {
        ArrayList<JsonArtifact> arts = new ArrayList<JsonArtifact>();
        List typesLong = Collections.fromString((String)artifactTypes, (String)",", Long::valueOf);
        ArrayList<ArtifactTypeToken> types = new ArrayList<ArtifactTypeToken>();
        for (Long typeId : typesLong) {
            types.add(this.orcsApi.tokenService().getArtifactType(typeId));
        }
        List artifacts = null;
        artifacts = viewId.isValid() ? this.orcsApi.getQueryFactory().fromBranch(branchId, viewId).andIsOfType(types).getResults().getList() : this.orcsApi.getQueryFactory().fromBranch(branchId).andIsOfType(types).getResults().getList();
        for (ArtifactReadable art : artifacts) {
            JsonArtifact jArt = new JsonArtifact();
            jArt.setType(art.getArtifactType());
            jArt.setTypeName(art.getArtifactType().getName());
            jArt.setId(ArtifactId.create((Id)art));
            jArt.setName(art.getName());
            ArrayList<JsonAttribute> attrList = new ArrayList<JsonAttribute>();
            List list = art.getAttributes().getList();
            for (AttributeReadable attr : list) {
                JsonAttribute attrRep = new JsonAttribute();
                attrRep.setTypeId((AttributeTypeId)attr.getAttributeType());
                attrRep.setTypeName(attr.getAttributeType().getName());
                if (attr.getAttributeType().getMediaType().startsWith("application")) {
                    attrRep.setValue("<large>");
                } else {
                    attrRep.setValue(attr.getDisplayableString());
                }
                attrList.add(attrRep);
            }
            jArt.setAttrs(attrList);
            arts.add(jArt);
        }
        return arts;
    }

    public List<ChangeItem> compareBranches(BranchId branch, BranchId branch2) {
        TransactionToken sourceTx = (TransactionToken)((TransactionQuery)this.newTxQuery().andIsHead(branch)).getResults().getExactlyOne();
        TransactionToken destinationTx = (TransactionToken)((TransactionQuery)this.newTxQuery().andIsHead(branch2)).getResults().getExactlyOne();
        List data = this.branchOps.compareBranch(sourceTx, destinationTx);
        try {
            this.activityLog.createEntry(CoreActivityTypes.BRANCH_OPERATION, ActivityLog.INITIAL_STATUS, new Object[]{String.format("Branch Operation Compare Branches {sourceTx: %s, destTx: %s}", sourceTx.toString(), destinationTx.toString())});
        }
        catch (OseeCoreException ex) {
            OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return data;
    }

    public List<ChangeReportRowDto> getBranchChangeReport(BranchId branch1, BranchId branch2) {
        TransactionToken sourceTx = (TransactionToken)((TransactionQuery)this.newTxQuery().andIsHead(branch1)).getResults().getExactlyOne();
        TransactionToken destinationTx = (TransactionToken)((TransactionQuery)this.newTxQuery().andIsHead(branch2)).getResults().getExactlyOne();
        return this.orcsApi.getTransactionFactory().getTxChangeReport(branch1, branch2, (TransactionId)sourceTx, (TransactionId)destinationTx);
    }

    public List<ChangeReportRowDto> getBranchTxChangeReport(BranchId branch1, TransactionId tx1, TransactionId tx2) {
        return this.orcsApi.getTransactionFactory().getTxChangeReport(branch1, BranchId.SENTINEL, tx1, tx2);
    }

    public BranchId createBranch(NewBranch data) {
        return this.createBranch(new CreateBranchData(), data);
    }

    public BranchId createBranchWithId(BranchId branch, NewBranch data) {
        if (branch.isInvalid()) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "branchUuid [%d] uuid must be > 0", new Object[]{branch});
        }
        CreateBranchData createData = new CreateBranchData(branch);
        return this.createBranch(createData, data);
    }

    public XResultData createBranchValidation(NewBranch data) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        CreateBranchData branchData = new CreateBranchData();
        this.createBranchData(branchData, data);
        return this.branchOps.createBranchValidation(branchData);
    }

    public UpdateBranchData updateBranch(BranchId branch, UpdateBranchData branchData) {
        UpdateBranchOperation op = new UpdateBranchOperation(branchData, this.orcsApi);
        return op.run();
    }

    private BranchId createBranch(CreateBranchData createData, NewBranch data) {
        this.createBranchData(createData, data);
        Branch result = this.branchOps.createBranch(createData);
        try {
            this.activityLog.createEntry(CoreActivityTypes.BRANCH_OPERATION, ActivityLog.INITIAL_STATUS, new Object[]{String.format("Branch Operation Create Branch {branchId: %s, branchName: %s}", createData.getBranch(), data.getBranchName())});
        }
        catch (OseeCoreException ex) {
            OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return result;
    }

    private void createBranchData(CreateBranchData createData, NewBranch data) {
        createData.setName(data.getBranchName());
        createData.setBranchType(data.getBranchType());
        createData.setCreationComment(data.getCreationComment());
        createData.setAssociatedArtifact(data.getAssociatedArtifact());
        createData.setFromTransaction(data.getSourceTransaction());
        createData.setParentBranch(data.getParentBranch());
        createData.setCategories(this.orcsApi.getQueryFactory().branchQuery().getBranchCategories(data.getParentBranch()));
        createData.setMergeDestinationBranchId(data.getMergeDestinationBranchId());
        createData.setMergeAddressingQueryId(data.getMergeAddressingQueryId());
        createData.setTxCopyBranchType(data.isTxCopyBranchType());
    }

    public TransactionResult commitBranch(BranchId branch, BranchId destinationBranch, BranchCommitOptions options) {
        Branch srcBranch = this.getBranchById(branch);
        Branch destBranch = this.getBranchById(destinationBranch);
        TransactionResult tr = new TransactionResult();
        tr.getResults().logf("Commiting Branch\n", new Object[0]);
        tr.getResults().logf("Source Branch [%s]\n", new Object[]{branch});
        tr.getResults().logf("Destination Branch [%s]\n", new Object[]{destBranch});
        tr.getResults().logf("Options [%s]\n\n", new Object[]{options});
        Callable op = this.branchOps.commitBranch(options.getCommitter(), (BranchId)srcBranch, (BranchId)destBranch);
        try {
            TransactionToken tx = (TransactionToken)OrcsRestUtil.executeCallable(op);
            tr.setTx(tx);
        }
        catch (Exception ex) {
            tr.getResults().errorf("Exception commiting branch [%s]", new Object[]{Lib.exceptionToString((Exception)ex)});
            return tr;
        }
        if (options.isArchive()) {
            Callable op2 = this.branchOps.archiveUnarchiveBranch((BranchId)srcBranch, ArchiveOperation.ARCHIVE);
            OrcsRestUtil.executeCallable(op2);
        }
        try {
            this.activityLog.createEntry(CoreActivityTypes.BRANCH_OPERATION, ActivityLog.INITIAL_STATUS, new Object[]{String.format("Branch Operation Commit Branch {branchId: %s srcBranch: %s destBranch: %s}", branch, srcBranch, destBranch)});
        }
        catch (OseeCoreException ex) {
            tr.getResults().errorf("Exception logging activity [%s]", new Object[]{Lib.exceptionToString((Exception)((Object)ex))});
            return tr;
        }
        return tr;
    }

    public Response archiveBranch(BranchId branchId) {
        Branch branch = this.getBranchById(branchId);
        boolean modified = false;
        if (!branch.isArchived()) {
            try {
                Callable op = this.branchOps.archiveUnarchiveBranch((BranchId)branch, ArchiveOperation.ARCHIVE);
                OrcsRestUtil.executeCallable(op);
            }
            catch (Exception ex) {
                this.orcsApi.getActivityLog().createThrowableEntry(CoreActivityTypes.BRANCH_OPERATION, (Throwable)ex, "Archive of branch " + branchId.getIdString());
                return OrcsRestUtil.asResponse(modified);
            }
            modified = true;
            try {
                this.activityLog.createEntry(CoreActivityTypes.BRANCH_OPERATION, ActivityLog.INITIAL_STATUS, new Object[]{String.format("Branch Operation Archive Branch {branchId: %s}", branchId)});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response unarchiveBranch(BranchId branchId) {
        Branch branch = this.getBranchById(branchId);
        boolean modified = false;
        if (branch.isArchived()) {
            try {
                Callable op = this.branchOps.archiveUnarchiveBranch((BranchId)branch, ArchiveOperation.UNARCHIVE);
                OrcsRestUtil.executeCallable(op);
            }
            catch (Exception ex) {
                this.orcsApi.getActivityLog().createThrowableEntry(CoreActivityTypes.BRANCH_OPERATION, (Throwable)ex, "Unarchive of branch " + branchId.getIdString());
                return OrcsRestUtil.asResponse(modified);
            }
            modified = true;
            try {
                this.activityLog.createEntry(CoreActivityTypes.BRANCH_OPERATION, ActivityLog.INITIAL_STATUS, new Object[]{String.format("Branch Operation Unarchive Branch {branchId: %s}", branchId)});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response writeTx(BranchId branch, NewTransaction data) {
        String comment = data.getComment();
        TransactionFactory txFactory = this.newTxFactory();
        TransactionBuilder txBuilder = txFactory.createTransaction(branch, null, comment);
        TransactionToken txId = txBuilder.commit();
        TransactionReadable tx = (TransactionReadable)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andTxId((TransactionId)txId)).getResults().getExactlyOne();
        if (tx.isValid()) {
            URI location = this.uriInfo.getRequestUriBuilder().path("{tx-id}").build(new Object[]{tx});
            return Response.created((URI)location).entity((Object)OrcsRestUtil.asTransaction(tx)).build();
        }
        throw new OseeArgumentException("No Data Modified", new Object[0]);
    }

    public Response setBranchName(BranchId branchId, String newName) {
        Branch branch = this.getBranchById(branchId);
        boolean modified = false;
        if (Compare.isDifferent((Object)branch.getName(), (Object)newName)) {
            Callable op = this.branchOps.changeBranchName((BranchId)branch, newName);
            OrcsRestUtil.executeCallable(op);
            modified = true;
            try {
                this.activityLog.createEntry(CoreActivityTypes.BRANCH_OPERATION, ActivityLog.INITIAL_STATUS, new Object[]{String.format("Branch Operation Set Branch Name {branchId: %s prevName: %s newName: %s}", branchId, branch.getName(), newName)});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response setBranchType(BranchId branchId, BranchType newType) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        Branch branch = this.getBranchById(branchId);
        boolean modified = false;
        if (Compare.isDifferent((Object)branch.getBranchType(), (Object)newType)) {
            try {
                this.activityLog.createEntry(CoreActivityTypes.BRANCH_OPERATION, ActivityLog.INITIAL_STATUS, new Object[]{String.format("Branch Operation Set Branch Type {branchUUID: %s prevType: %s newType: %s}", branchId, branch.getBranchType(), newType)});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
            Callable op = this.branchOps.changeBranchType((BranchId)branch, newType);
            OrcsRestUtil.executeCallable(op);
            modified = true;
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response setBranchState(BranchId branchId, BranchState newState) {
        Branch branch = this.getBranchById(branchId);
        boolean modified = false;
        if (Compare.isDifferent((Object)branch.getBranchState(), (Object)newState)) {
            Callable op = this.branchOps.changeBranchState((BranchId)branch, newState);
            OrcsRestUtil.executeCallable(op);
            modified = true;
            try {
                this.activityLog.createEntry(CoreActivityTypes.BRANCH_OPERATION, ActivityLog.INITIAL_STATUS, new Object[]{String.format("Branch Operation Branch State Changed {branchId: %s prevState: %s newState: %s}", branchId, branch.getBranchType(), newState)});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public void setBranchPermission(ArtifactId subject, BranchId branch, PermissionEnum permission) {
        this.branchOps.setBranchPermission(subject, branch, permission);
    }

    public Response associateBranchToArtifact(BranchId branchId, ArtifactId artifact) {
        Branch branch = this.getBranchById(branchId);
        boolean modified = false;
        if (Compare.isDifferent((Object)branch.getAssociatedArtifact(), (Object)artifact)) {
            try {
                this.activityLog.createEntry(CoreActivityTypes.BRANCH_OPERATION, ActivityLog.INITIAL_STATUS, new Object[]{String.format("Branch Operation Associate Branch to Artifact {branchId: %s prevArt: %s newArt: %s}", branchId, branch.getAssociatedArtifact(), artifact)});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
            Callable op = this.branchOps.associateBranchToArtifact((BranchId)branch, artifact);
            OrcsRestUtil.executeCallable(op);
            modified = true;
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response setTxComment(BranchId branch, TransactionId txId, String comment) {
        TransactionReadable tx = this.getTxByBranchAndId(branch, txId);
        boolean modified = false;
        if (Compare.isDifferent((Object)tx.getComment(), (Object)comment)) {
            try {
                this.activityLog.createEntry(CoreActivityTypes.BRANCH_OPERATION, ActivityLog.INITIAL_STATUS, new Object[]{String.format("Branch Operation Set Tx Comment {branchId: %s prevComment: %s newComment: %s}", branch, tx.getComment(), comment)});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
            TransactionFactory txFactory = this.newTxFactory();
            txFactory.setTransactionComment((TransactionId)tx, comment);
            modified = true;
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response purgeBranch(BranchId branchId, boolean recurse) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.AccountAdmin});
        boolean modified = false;
        Branch branch = this.getBranchById(branchId);
        if (branch != null) {
            Callable op = this.branchOps.purgeBranch((BranchId)branch, recurse);
            OrcsRestUtil.executeCallable(op);
            modified = true;
        }
        try {
            this.activityLog.createEntry(CoreActivityTypes.BRANCH_OPERATION, ActivityLog.INITIAL_STATUS, new Object[]{String.format("Branch Operation Purge Branch {branchId: %s}", branchId)});
        }
        catch (OseeCoreException ex) {
            OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response unCommitBranch(BranchId branch, BranchId destinationBranch) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Response unassociateBranch(BranchId branchId) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        Branch branch = this.getBranchById(branchId);
        boolean modified = false;
        if (branch.getAssociatedArtifact().isValid()) {
            Callable op = this.branchOps.unassociateBranch((BranchId)branch);
            OrcsRestUtil.executeCallable(op);
            modified = true;
            try {
                this.activityLog.createEntry(CoreActivityTypes.BRANCH_OPERATION, ActivityLog.INITIAL_STATUS, new Object[]{String.format("Branch Operation Unassociate Branch {branchId: %s}", branchId)});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response purgeTxs(BranchId branch, String txIds) {
        ResultSet results;
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        boolean modified = false;
        List txsToDelete = Collections.fromString((String)txIds, TransactionId::valueOf);
        if (!txsToDelete.isEmpty() && !(results = ((TransactionQuery)((TransactionQuery)this.newTxQuery().andBranch(new BranchId[]{branch})).andTxIds((Collection)txsToDelete)).getResults()).isEmpty()) {
            this.checkAllTxFoundAreOnBranch("Purge Transaction", branch, txsToDelete, (ResultSet<? extends TransactionId>)results);
            ArrayList list = Lists.newArrayList((Iterable)results);
            Callable op = this.newTxFactory().purgeTransaction((Collection)list);
            OrcsRestUtil.executeCallable(op);
            modified = true;
            try {
                this.activityLog.createEntry(CoreActivityTypes.BRANCH_OPERATION, ActivityLog.INITIAL_STATUS, new Object[]{String.format("Branch Operation Purge Txs {branchId: %s, txsToDelete: %s}", branch, txIds)});
            }
            catch (OseeCoreException ex) {
                OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return OrcsRestUtil.asResponse(modified);
    }

    private void checkAllTxFoundAreOnBranch(String opName, BranchId branch, List<TransactionId> txIds, ResultSet<? extends TransactionId> result) {
        List difference;
        if (txIds.size() != result.size() && !(difference = Collections.setComplement(txIds, (Collection)result.getList())).isEmpty()) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "%s Error - The following transactions from %s were not found on branch [%s] - txs %s - Please remove them from the request and try again.", new Object[]{opName, txIds, branch, difference});
        }
    }

    private ResultSet<Branch> searchBranches(BranchQueryData options) {
        BranchQuery query = this.orcsApi.getQueryFactory().branchQuery();
        if (options != null) {
            BranchCategoryToken category;
            Long childOf;
            Long ancestorOf;
            String namePatternIgnoreCase;
            String namePattern;
            Collection branchTypes;
            Collection branchStates;
            Collection branchIds = options.getBranchIds();
            if (Conditions.hasValues((Collection)branchIds)) {
                query.andIds(branchIds);
            }
            if (Conditions.hasValues((Collection)(branchStates = options.getBranchStates()))) {
                query.andStateIs(branchStates.toArray(new BranchState[branchStates.size()]));
            }
            if (Conditions.hasValues((Collection)(branchTypes = options.getBranchTypes()))) {
                query.andIsOfType(branchTypes.toArray(new BranchType[branchTypes.size()]));
            }
            if (options.isIncludeArchived()) {
                query.includeArchived();
            } else {
                query.excludeArchived();
            }
            if (options.isIncludeDeleted()) {
                query.includeDeleted();
            } else {
                query.excludeDeleted();
            }
            String nameEquals = options.getNameEquals();
            if (Strings.isValid((String)nameEquals)) {
                query.andNameEquals(nameEquals);
            }
            if (Strings.isValid((String)(namePattern = options.getNamePattern()))) {
                query.andNamePattern(namePattern);
            }
            if (Strings.isValid((String)(namePatternIgnoreCase = options.getNamePatternIgnoreCase()))) {
                query.andNamePatternIgnoreCase(namePatternIgnoreCase);
            }
            if ((ancestorOf = options.getIsAncestorOf()) > 0L) {
                BranchId ancestorOfToken = BranchId.valueOf((Long)ancestorOf);
                query.andIsAncestorOf(ancestorOfToken);
            }
            if ((childOf = options.getIsChildOf()) > 0L) {
                BranchId childOfToken = BranchId.valueOf((Long)childOf);
                query.andIsChildOf(childOfToken);
            }
            if ((category = options.getCategory()).isValid()) {
                query.andIsOfCategory(category);
            }
        }
        return query.getResults();
    }

    public Response logBranchActivity(String comment) {
        try {
            this.activityLog.createEntry(CoreActivityTypes.BRANCH_OPERATION, ActivityLog.INITIAL_STATUS, new Object[]{comment});
        }
        catch (OseeCoreException ex) {
            OseeLog.log(ActivityLog.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return Response.ok().build();
    }

    public BranchToken createProgramBranch(BranchId branch, String branchName) {
        BranchToken branchToken = branch.isValid() ? BranchToken.create((BranchId)branch, (String)branchName) : BranchToken.create((String)branchName);
        return this.branchOps.createProgramBranch(branchToken);
    }

    public JsonRelations getRelationsByType(BranchId branch, String relationTypes) {
        String query = "select * from osee_relation_link rel, osee_txs txs where txs.branch_id = ? and rel.gamma_id = txs.gamma_id and rel_link_type_id = ? and txs.mod_type in (1,2,6) and tx_current = 1";
        JsonRelations relations = new JsonRelations();
        HashSet artIds = new HashSet();
        String[] stringArray = relationTypes.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String relTypeId = stringArray[n2];
            if (Strings.isNumeric((String)(relTypeId = relTypeId.replaceAll(" ", "")))) {
                this.orcsApi.getJdbcService().getClient().runQuery(chStmt -> {
                    Object object = relations.add(this.getJaxRelation((JdbcStatement)chStmt, artIds));
                }, query, new Object[]{branch.getId(), Long.valueOf(relTypeId)});
            }
            ++n2;
        }
        HashMap<ArtifactReadable, ArtifactReadable> artifactMap = new HashMap<ArtifactReadable, ArtifactReadable>();
        for (ArtifactReadable art : this.orcsApi.getQueryFactory().fromBranch(branch).andIds(artIds).getResults().getList()) {
            artifactMap.put(art, art);
        }
        for (JsonRelation rel : relations.getRelations()) {
            RelationTypeToken relationType = this.orcsApi.tokenService().getRelationType(Long.valueOf(rel.getTypeId()));
            rel.setTypeName(relationType.getName());
            ArtifactReadable art = (ArtifactReadable)artifactMap.get(ArtifactId.valueOf((String)rel.getArtA()));
            rel.setArtAName(art.getName());
            ArtifactReadable art2 = (ArtifactReadable)artifactMap.get(ArtifactId.valueOf((String)rel.getArtB()));
            rel.setArtBName(art2.getName());
        }
        return relations;
    }

    private JsonRelation getJaxRelation(JdbcStatement chStmt, Set<ArtifactId> artIds) {
        JsonRelation rel = new JsonRelation();
        String artA = chStmt.getString("a_art_id");
        artIds.add(ArtifactId.valueOf((String)artA));
        rel.setArtA(artA);
        String artB = chStmt.getString("b_art_id");
        artIds.add(ArtifactId.valueOf((String)artB));
        rel.setArtB(artB);
        rel.setTypeId(chStmt.getString("rel_link_type_id"));
        return rel;
    }

    public Collection<BranchId> getOtherBranchesWithModifiedArtifacts(BranchId branchId, ArtifactId artifactId) {
        HashSet<BranchId> setOfBranchIds = new HashSet<BranchId>();
        this.orcsApi.getJdbcService().getClient().runQuery(chStmt -> {
            boolean bl = setOfBranchIds.add(this.getBranchId((JdbcStatement)chStmt));
        }, OTHER_EDIT_SQL, new Object[]{artifactId, branchId, BranchType.WORKING, BranchState.MODIFIED});
        return setOfBranchIds;
    }

    private BranchId getBranchId(JdbcStatement chStmt) {
        long modifiedOnBranchId = chStmt.getLong("branch_id");
        return BranchId.valueOf((Long)modifiedOnBranchId);
    }

    public boolean undoLatest(BranchId branch) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        return this.undo((TransactionId)((TransactionQuery)this.newTxQuery().andIsHead(branch)).getResultsAsIds().getOneOrDefault((Object)TransactionId.SENTINEL));
    }

    public boolean undo(BranchId branch, TransactionId transaction) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        return this.undo(transaction);
    }

    private boolean undo(TransactionId tx) {
        return this.orcsApi.getTransactionFactory().purgeTxs(tx.getIdString());
    }
}

