/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.vcast.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.vcast.VCastDataStore;
import org.eclipse.osee.vcast.model.VCastBranchCoverage;
import org.eclipse.osee.vcast.model.VCastBranchData;
import org.eclipse.osee.vcast.model.VCastCoverageType;
import org.eclipse.osee.vcast.model.VCastFunction;
import org.eclipse.osee.vcast.model.VCastInstrumentedFile;
import org.eclipse.osee.vcast.model.VCastMcdcCoverage;
import org.eclipse.osee.vcast.model.VCastMcdcCoverageCondition;
import org.eclipse.osee.vcast.model.VCastMcdcCoveragePair;
import org.eclipse.osee.vcast.model.VCastMcdcCoveragePairRow;
import org.eclipse.osee.vcast.model.VCastMcdcData;
import org.eclipse.osee.vcast.model.VCastMcdcDataCondition;
import org.eclipse.osee.vcast.model.VCastProject;
import org.eclipse.osee.vcast.model.VCastProjectFile;
import org.eclipse.osee.vcast.model.VCastResult;
import org.eclipse.osee.vcast.model.VCastSetting;
import org.eclipse.osee.vcast.model.VCastSourceFile;
import org.eclipse.osee.vcast.model.VCastSourceFileJoin;
import org.eclipse.osee.vcast.model.VCastStatementCoverage;
import org.eclipse.osee.vcast.model.VCastStatementData;
import org.eclipse.osee.vcast.model.VCastVersion;
import org.eclipse.osee.vcast.model.VCastWritable;

public class VCastDataStoreImpl
implements VCastDataStore {
    private final JdbcClient client;
    private boolean isMCDC;
    private boolean isBranchCoverage;

    public VCastDataStoreImpl(JdbcClient client) {
        this.client = client;
    }

    private JdbcStatement getStatement() {
        JdbcConnection connection = this.client.getConnection();
        return this.client.getStatement(connection, true);
    }

    @Override
    public Collection<VCastBranchCoverage> getAllBranchCoverages() {
        ArrayList<VCastBranchCoverage> toReturn = new ArrayList<VCastBranchCoverage>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM branch_coverage", new Object[0]);
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                Integer function_id = stmt.getInt("function_id");
                Integer line = stmt.getInt("line");
                Integer num_conditions = stmt.getInt("num_conditions");
                Integer true_count = stmt.getInt("true_count");
                Integer false_count = stmt.getInt("false_count");
                Integer max_true_count = stmt.getInt("max_true_count");
                Integer max_false_count = stmt.getInt("max_false_count");
                toReturn.add(new VCastBranchCoverage(id, function_id, line, num_conditions, true_count, false_count, max_true_count, max_false_count));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastBranchData> getAllBranchData() {
        ArrayList<VCastBranchData> toReturn = new ArrayList<VCastBranchData>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM branch_data", new Object[0]);
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                Long branch_id = stmt.getLong("branch_id");
                Integer result_id = stmt.getInt("result_id");
                Integer result_line = stmt.getInt("result_line");
                Boolean taken = stmt.getBoolean("taken");
                toReturn.add(new VCastBranchData(id, branch_id, result_id, result_line, taken));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastFunction> getAllFunctions() {
        ArrayList<VCastFunction> toReturn = new ArrayList<VCastFunction>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM functions", new Object[0]);
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                Integer instrumented_file_id = stmt.getInt("instrumented_file_id");
                Integer findex = stmt.getInt("findex");
                String name = stmt.getString("name");
                String canonical_name = stmt.getString("canonical_name");
                Integer total_lines = stmt.getInt("total_lines");
                Integer complexity = stmt.getInt("complexity");
                Integer numPairsOrPaths = stmt.getInt("num_pairs_or_paths");
                toReturn.add(new VCastFunction(id, instrumented_file_id, findex, name, canonical_name, total_lines, complexity, numPairsOrPaths));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastInstrumentedFile> getAllInstrumentedFiles(Map<String, File> idToFileName) {
        ArrayList<VCastInstrumentedFile> toReturn = new ArrayList<VCastInstrumentedFile>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM instrumented_files if", new Object[0]);
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                Integer source_file_id = stmt.getInt("source_file_id");
                Integer project_id = stmt.getInt("project_id");
                Integer unit_index = stmt.getInt("unit_index");
                Integer coverage_type = stmt.getInt("coverage_type");
                String LIS_file = idToFileName.get(source_file_id.toString()).getName();
                Integer checksum = stmt.getInt("checksum");
                toReturn.add(new VCastInstrumentedFile(id, source_file_id, project_id, unit_index, VCastCoverageType.valueOf(coverage_type), LIS_file, checksum));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastInstrumentedFile> getAllInstrumentedFiles() {
        ArrayList<VCastInstrumentedFile> toReturn = new ArrayList<VCastInstrumentedFile>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM instrumented_files if", new Object[0]);
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                Integer source_file_id = stmt.getInt("source_file_id");
                Integer project_id = stmt.getInt("project_id");
                Integer unit_index = stmt.getInt("unit_index");
                Integer coverage_type = stmt.getInt("coverage_type");
                String LIS_file = stmt.getString("LIS_file");
                Integer checksum = stmt.getInt("checksum");
                toReturn.add(new VCastInstrumentedFile(id, source_file_id, project_id, unit_index, VCastCoverageType.valueOf(coverage_type), LIS_file, checksum));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastMcdcCoverage> getAllMcdcCoverages() {
        ArrayList<VCastMcdcCoverage> toReturn = new ArrayList<VCastMcdcCoverage>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM mcdc_coverage", new Object[0]);
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                Integer function_id = stmt.getInt("function_id");
                Integer line = stmt.getInt("line");
                Integer source_line = stmt.getInt("source_line");
                Integer num_conditions = stmt.getInt("num_conditions");
                String actual_expr = stmt.getString("actual_expr");
                String simplified_expr = stmt.getString("simplified_expr");
                toReturn.add(new VCastMcdcCoverage(id, function_id, line, source_line, num_conditions, actual_expr, simplified_expr));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastMcdcCoverageCondition> getAllMcdcCoverageConditions() {
        ArrayList<VCastMcdcCoverageCondition> toReturn = new ArrayList<VCastMcdcCoverageCondition>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM mcdc_coverage_conditions", new Object[0]);
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                Integer mcdc_id = stmt.getInt("mcdc_id");
                Integer cond_index = stmt.getInt("cond_index");
                Integer true_count = stmt.getInt("true_count");
                Integer false_count = stmt.getInt("false_count");
                Integer max_true_count = stmt.getInt("max_true_count");
                Integer max_false_count = stmt.getInt("max_false_count");
                String cond_variable = stmt.getString("cond_variable");
                String cond_expr = stmt.getString("cond_expr");
                toReturn.add(new VCastMcdcCoverageCondition(id, mcdc_id, cond_index, true_count, false_count, max_true_count, max_false_count, cond_variable, cond_expr));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastMcdcCoveragePairRow> getAllMcdcCoveragePairRows() {
        ArrayList<VCastMcdcCoveragePairRow> toReturn = new ArrayList<VCastMcdcCoveragePairRow>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM mcdc_coverage_pair_rows", new Object[0]);
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                Integer mcdc_id = stmt.getInt("mcdc_id");
                Integer row_value = stmt.getInt("row_value");
                Integer row_result = stmt.getInt("row_result");
                Integer hit_count = stmt.getInt("hit_count");
                Integer max_hit_count = stmt.getInt("max_hit_count");
                toReturn.add(new VCastMcdcCoveragePairRow(id, mcdc_id, row_value, row_result, hit_count, max_hit_count));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastMcdcCoveragePair> getAllMcdcCoveragePairs() {
        ArrayList<VCastMcdcCoveragePair> toReturn = new ArrayList<VCastMcdcCoveragePair>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM mcdc_coverage_pairs", new Object[0]);
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                Integer mcdc_cond_id = stmt.getInt("mcdc_cond_id");
                Integer pair_row1 = stmt.getInt("pair_row1");
                Integer pair_row2 = stmt.getInt("pair_row2");
                toReturn.add(new VCastMcdcCoveragePair(id, mcdc_cond_id, pair_row1, pair_row2));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastMcdcData> getAllMcdcData() {
        ArrayList<VCastMcdcData> toReturn = new ArrayList<VCastMcdcData>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM mcdc_data", new Object[0]);
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                Integer mcdc_id = stmt.getInt("mcdc_id");
                Integer result_id = stmt.getInt("result_id");
                Integer result_line = stmt.getInt("result_line");
                Integer pair_value = stmt.getInt("pair_value");
                Integer used_value = stmt.getInt("used_value");
                toReturn.add(new VCastMcdcData(id, mcdc_id, result_id, result_line, pair_value, used_value));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastMcdcDataCondition> getAllMcdcDataConditions() {
        ArrayList<VCastMcdcDataCondition> toReturn = new ArrayList<VCastMcdcDataCondition>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM mcdc_data_conditions", new Object[0]);
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                Integer mcdc_data_id = stmt.getInt("mcdc_data_id");
                Integer cond_index = stmt.getInt("cond_index");
                Boolean cond_value = stmt.getBoolean("cond_value");
                toReturn.add(new VCastMcdcDataCondition(id, mcdc_data_id, cond_index, cond_value));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastProjectFile> getAllProjectFiles() {
        ArrayList<VCastProjectFile> toReturn = new ArrayList<VCastProjectFile>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM project_files", new Object[0]);
            while (stmt.next()) {
                Integer project_id = stmt.getInt("project_id");
                Integer source_file_id = stmt.getInt("source_file_id");
                Integer instrumented_file_id = stmt.getInt("instrumented_file_id");
                Integer timestamp = stmt.getInt("timestamp");
                String build_md5sum = stmt.getString("build_md5sum");
                toReturn.add(new VCastProjectFile(project_id, source_file_id, instrumented_file_id, timestamp, build_md5sum));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastProject> getAllProjects() {
        ArrayList<VCastProject> toReturn = new ArrayList<VCastProject>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM projects", new Object[0]);
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                String name = stmt.getString("name");
                String path = stmt.getString("path");
                toReturn.add(new VCastProject(id, name, path));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastResult> getAllResults() {
        ArrayList<VCastResult> toReturn = new ArrayList<VCastResult>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM results", new Object[0]);
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                String name = stmt.getString("name");
                Integer project_id = stmt.getInt("project_id");
                String path = stmt.getString("path");
                path = path.replaceAll("imported_results", "IMPORTED_RESULTS");
                String fullname = stmt.getString("fullname");
                boolean enabled = stmt.getBoolean("enabled");
                boolean imported = stmt.getBoolean("imported");
                toReturn.add(new VCastResult(id, name, project_id, path, fullname, enabled, imported));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastSetting> getAllSettings() {
        ArrayList<VCastSetting> toReturn = new ArrayList<VCastSetting>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM settings", new Object[0]);
            while (stmt.next()) {
                String setting = stmt.getString("setting");
                String value = stmt.getString("value");
                toReturn.add(new VCastSetting(setting, value));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastSourceFile> getAllSourceFiles() {
        ArrayList<VCastSourceFile> toReturn = new ArrayList<VCastSourceFile>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM source_files", new Object[0]);
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                String path = stmt.getString("path");
                String display_name = stmt.getString("display_name");
                Integer checksum = stmt.getInt("checksum");
                String display_path = stmt.getString("display_path");
                toReturn.add(new VCastSourceFile(id, path, display_name, checksum, display_path));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastStatementCoverage> getAllStatementCoverages() {
        ArrayList<VCastStatementCoverage> toReturn = new ArrayList<VCastStatementCoverage>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM statement_coverage", new Object[0]);
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                Integer function_id = stmt.getInt("function_id");
                Integer line = stmt.getInt("line");
                Integer hit_count = stmt.getInt("hit_count");
                Integer max_hit_count = stmt.getInt("max_hit_count");
                toReturn.add(new VCastStatementCoverage(id, function_id, line, hit_count, max_hit_count));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastStatementData> getAllStatementData() {
        ArrayList<VCastStatementData> toReturn = new ArrayList<VCastStatementData>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM statement_data", new Object[0]);
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                Integer statement_id = stmt.getInt("statement_id");
                Integer result_id = stmt.getInt("result_id");
                Integer result_line = stmt.getInt("result_line");
                Boolean hit = stmt.getBoolean("hit");
                toReturn.add(new VCastStatementData(id, statement_id, result_id, result_line, hit));
            }
        }
        return toReturn;
    }

    @Override
    public VCastVersion getVersion() {
        VCastVersion toReturn = null;
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM version", new Object[0]);
            if (stmt.next()) {
                Integer vestmtion = stmt.getInt("version");
                String date_created = stmt.getString("date_created");
                toReturn = new VCastVersion(vestmtion, date_created);
            }
        }
        return toReturn;
    }

    @Override
    public VCastWritable getWritable() {
        VCastWritable toReturn = null;
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM writable", new Object[0]);
            if (stmt.next()) {
                Integer is_writable = stmt.getInt("is_writable");
                toReturn = new VCastWritable(is_writable);
            }
        }
        return toReturn;
    }

    @Override
    public VCastSourceFileJoin getSourceFileJoin(VCastInstrumentedFile instrumentedFile) {
        VCastSourceFileJoin toReturn = null;
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT sf.id, sf.path, sf.display_name, sf.checksum, sf.display_path, ifs.unit_index FROM source_files sf join instrumented_files ifs WHERE  sf.id = ifs.source_file_id AND sf.id=?", new Object[]{instrumentedFile.getSourceFileId()});
            if (stmt.next()) {
                Integer id = stmt.getInt("id");
                Integer unit_index = stmt.getInt("unit_index");
                String path = stmt.getString("path");
                String display_name = stmt.getString("display_name");
                Integer checksum = stmt.getInt("checksum");
                String display_path = stmt.getString("display_path");
                toReturn = new VCastSourceFileJoin(id, path, display_name, checksum, display_path, unit_index);
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastFunction> getFunctions(VCastInstrumentedFile instrumentedFile) {
        ArrayList<VCastFunction> toReturn = new ArrayList<VCastFunction>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM functions f WHERE instrumented_file_id=?", new Object[]{instrumentedFile.getId()});
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                Integer findex = stmt.getInt("findex");
                String name = stmt.getString("name");
                String canonical_name = stmt.getString("canonical_name");
                Integer total_lines = stmt.getInt("total_lines");
                Integer complexity = stmt.getInt("complexity");
                Integer numPairsOrPaths = stmt.getInt("num_pairs_or_paths");
                toReturn.add(new VCastFunction(id, instrumentedFile.getId(), findex, name, canonical_name, total_lines, complexity, numPairsOrPaths));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastStatementCoverage> getStatementCoverageLines(VCastFunction function) {
        if (this.isMCDC) {
            return this.getStatementCoverageLinesWithMCDC(function);
        }
        if (this.isBranchCoverage) {
            return this.getStatementCoverageLinesWithBranch(function);
        }
        ArrayList<VCastStatementCoverage> toReturn = new ArrayList<VCastStatementCoverage>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM statement_coverage sc WHERE function_id=?", new Object[]{function.getId()});
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                Integer line = stmt.getInt("line");
                Integer hit_count = stmt.getInt("hit_count");
                Integer max_hit_count = stmt.getInt("max_hit_count");
                toReturn.add(new VCastStatementCoverage(id, function.getId(), line, hit_count, max_hit_count));
            }
        }
        return toReturn;
    }

    private Collection<VCastStatementCoverage> getStatementCoverageLinesWithBranch(VCastFunction function) {
        ArrayList<VCastStatementCoverage> toReturn = new ArrayList<VCastStatementCoverage>();
        try (JdbcStatement stmt = this.getStatement();){
            try {
                String query = "with temp as (SELECT sc.id, sc.function_id, sc.hit_count, sc.max_hit_count, sc.line, branch.num_conditions FROM statement_coverage sc left outer join branch_coverage branch on sc.function_id = branch.function_id and sc.line=branch.line where branch.function_id = ?) SELECT id, function_id, hit_count, max_hit_count, line, num_conditions from temp union all  select sc2.id, sc2.function_id, sc2.hit_count, sc2.max_hit_count, sc2.line, 0 from statement_coverage sc2 where not exists  (select 1 from temp where sc2.function_id = temp.function_id and sc2.line=temp.line) and sc2.function_id=?";
                stmt.runPreparedQuery(query, new Object[]{function.getId(), function.getId()});
                while (stmt.next()) {
                    Integer id = stmt.getInt("id");
                    Integer line = stmt.getInt("line");
                    Integer hit_count = stmt.getInt("hit_count");
                    Integer max_hit_count = stmt.getInt("max_hit_count");
                    Integer num_conditions = stmt.getInt("num_conditions");
                    toReturn.add(new VCastStatementCoverage(id, function.getId(), line, hit_count, max_hit_count, num_conditions));
                }
            }
            catch (Exception ex) {
                System.out.println(ex);
                stmt.close();
            }
        }
        return toReturn;
    }

    private Collection<VCastStatementCoverage> getStatementCoverageLinesWithMCDC(VCastFunction function) {
        ArrayList<VCastStatementCoverage> toReturn = new ArrayList<VCastStatementCoverage>();
        try (JdbcStatement stmt = this.getStatement();){
            try {
                String query = "WITH temp as (SELECT sc.id as sc_id, mcdc.id as mcdc_id, sc.hit_count, sc.max_hit_count, sc.line, mcdc.simplified_expr, mcdc.num_conditions FROM statement_coverage sc left outer join mcdc_coverage mcdc on (sc.line = mcdc.line and sc.function_id = mcdc.function_id) where sc.function_id = ?) select temp.sc_id, temp.mcdc_id, temp.line, temp.hit_count, temp.max_hit_count, temp.simplified_expr, temp.num_conditions, mcdc_c.cond_index, mcdc_c.cond_variable, mcdc_c.cond_expr from temp left outer join mcdc_coverage_conditions mcdc_c on temp.mcdc_id = mcdc_c.mcdc_id";
                stmt.runPreparedQuery(query, new Object[]{function.getId()});
                while (stmt.next()) {
                    String variableFullName;
                    Integer id = stmt.getInt("temp.sc_id");
                    Integer line = stmt.getInt("temp.line");
                    Integer mcdc_id = stmt.getInt("temp.mcdc_id");
                    Integer hit_count = stmt.getInt("temp.hit_count");
                    Integer max_hit_count = stmt.getInt("temp.max_hit_count");
                    String simp_expr = stmt.getString("temp.simplified_expr");
                    Integer num_conditions = stmt.getInt("temp.num_conditions");
                    String variable = stmt.getString("mcdc_c.cond_variable");
                    String cond_expr = stmt.getString("mcdc_c.cond_expr");
                    Integer cond_index = stmt.getInt("mcdc_c.cond_index");
                    boolean isMCDCPair = false;
                    if (variable != null) {
                        isMCDCPair = true;
                        if (variable.isEmpty() || num_conditions == 1) {
                            num_conditions = -1;
                            variableFullName = "RESULT";
                            cond_expr = simp_expr;
                        } else {
                            num_conditions = (num_conditions - 2) / 2;
                            variableFullName = String.format("%d (P%s)", cond_index, variable.toLowerCase());
                        }
                    } else {
                        variableFullName = null;
                    }
                    toReturn.add(new VCastStatementCoverage(id, function.getId(), line, hit_count, max_hit_count, isMCDCPair, variableFullName, cond_expr, num_conditions, cond_index, this.queryMcdcPairs(mcdc_id)));
                }
            }
            catch (Exception ex) {
                System.out.println(ex);
                stmt.close();
            }
        }
        return toReturn;
    }

    private ArrayList<VCastMcdcCoveragePairRow> queryMcdcPairs(int mcdcId) {
        ArrayList<VCastMcdcCoveragePairRow> mcdcCoveragePairRows = new ArrayList<VCastMcdcCoveragePairRow>();
        try (JdbcStatement rowStmt = this.getStatement();){
            try {
                String query = "SELECT * FROM mcdc_coverage_pair_rows WHERE mcdc_id = ?";
                rowStmt.runPreparedQuery(query, new Object[]{mcdcId});
                while (rowStmt.next()) {
                    Integer id = rowStmt.getInt("id");
                    Integer mcdc_id = rowStmt.getInt("mcdc_id");
                    Integer row_value = rowStmt.getInt("row_value");
                    Integer row_result = rowStmt.getInt("row_result");
                    Integer hit_count = rowStmt.getInt("hit_count");
                    Integer max_hit_count = rowStmt.getInt("max_hit_count");
                    VCastMcdcCoveragePairRow pairRow = new VCastMcdcCoveragePairRow(id, mcdc_id, row_value, row_result, hit_count, max_hit_count);
                    mcdcCoveragePairRows.add(pairRow);
                }
            }
            catch (Exception ex) {
                System.out.println(ex);
                rowStmt.close();
            }
        }
        return mcdcCoveragePairRows;
    }

    @Override
    public Collection<VCastStatementData> getStatementData(VCastStatementCoverage statementCoverage) {
        ArrayList<VCastStatementData> toReturn = new ArrayList<VCastStatementData>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM statement_data WHERE statement_id=?", new Object[]{statementCoverage.getId()});
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                Integer statement_id = stmt.getInt("statement_id");
                Integer result_id = stmt.getInt("result_id");
                Integer result_line = stmt.getInt("result_line");
                Boolean hit = stmt.getBoolean("hit");
                toReturn.add(new VCastStatementData(id, statement_id, result_id, result_line, hit));
            }
        }
        return toReturn;
    }

    @Override
    public Collection<VCastResult> getResults(VCastStatementData statementDataItem) {
        ArrayList<VCastResult> toReturn = new ArrayList<VCastResult>();
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT * FROM results WHERE id=?", new Object[]{statementDataItem.getResultId()});
            while (stmt.next()) {
                Integer id = stmt.getInt("id");
                String name = stmt.getString("name");
                Integer project_id = stmt.getInt("project_id");
                String path = stmt.getString("path");
                String fullname = stmt.getString("fullname");
                boolean enabled = stmt.getBoolean("enabled");
                boolean imported = stmt.getBoolean("imported");
                toReturn.add(new VCastResult(id, name, project_id, path, fullname, enabled, imported));
            }
        }
        return toReturn;
    }

    @Override
    public void setIsMCDC() {
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT COUNT(1) FROM mcdc_coverage", new Object[0]);
            if (stmt.next() && stmt.getInt("count(1)") > 0) {
                this.isMCDC = true;
            }
        }
    }

    @Override
    public boolean getIsMCDC() {
        return this.isMCDC;
    }

    @Override
    public void setIsBranch() {
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery("SELECT COUNT(1) FROM branch_coverage", new Object[0]);
            if (stmt.next() && stmt.getInt("count(1)") > 0) {
                this.isBranchCoverage = true;
            }
        }
    }

    @Override
    public boolean getIsBranchCoverage() {
        return this.isBranchCoverage;
    }
}

