/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DoubleKeyHashMap<KeyOne, KeyTwo, Value> {
    private final HashMap<KeyOne, HashMap<KeyTwo, Value>> k1ToHashMap = new HashMap();

    public Map<KeyOne, KeyTwo> keySet() {
        HashMap<KeyOne, KeyTwo> keySet = new HashMap<KeyOne, KeyTwo>();
        for (KeyOne one : this.k1ToHashMap.keySet()) {
            for (KeyTwo two : this.k1ToHashMap.get(one).keySet()) {
                keySet.put(one, two);
            }
        }
        return keySet;
    }

    public Collection<Value> get(KeyOne k1) {
        HashMap<KeyTwo, Value> o = this.k1ToHashMap.get(k1);
        if (o == null) {
            return null;
        }
        return o.values();
    }

    public Value get(KeyOne k1, KeyTwo k2) {
        HashMap<KeyTwo, Value> o = this.k1ToHashMap.get(k1);
        if (o != null) {
            return o.get(k2);
        }
        return null;
    }

    public Value put(KeyOne k1, KeyTwo k2, Value v) {
        Object returnV = null;
        HashMap<Object, Object> o = this.k1ToHashMap.get(k1);
        if (o != null) {
            returnV = o.put(k2, v);
        } else {
            o = new HashMap(20);
            returnV = o.put(k2, v);
            this.k1ToHashMap.put(k1, o);
        }
        return (Value)returnV;
    }

    public Value remove(KeyOne k1, KeyTwo k2) {
        Value value = null;
        HashMap<KeyTwo, Value> o = this.k1ToHashMap.get(k1);
        if (o != null) {
            value = o.remove(k2);
            if (o.isEmpty()) {
                this.k1ToHashMap.remove(k1);
            }
        }
        return value;
    }

    public String toString() {
        return this.k1ToHashMap.toString();
    }

    public int size() {
        return this.k1ToHashMap.size();
    }

    public Collection<Value> allValues() {
        HashSet<Value> values = new HashSet<Value>();
        for (HashMap<KeyTwo, Value> map : this.k1ToHashMap.values()) {
            values.addAll(map.values());
        }
        return values;
    }

    public Collection<Value> allValues(KeyOne key) {
        HashMap<KeyTwo, Value> map = this.k1ToHashMap.get(key);
        if (map != null) {
            return new HashSet<Value>(map.values());
        }
        return new HashSet();
    }

    public Map<KeyTwo, Value> getSubHash(KeyOne k1) {
        return this.k1ToHashMap.get(k1);
    }

    public boolean containsKey(KeyOne k1, KeyTwo k2) {
        return this.k1ToHashMap.containsKey(k1) && this.k1ToHashMap.get(k1).containsKey(k2);
    }

    public void clear() {
        this.k1ToHashMap.clear();
    }

    public boolean isEmpty() {
        return this.k1ToHashMap.isEmpty();
    }

    public Set<KeyOne> getKeySetOne() {
        return this.k1ToHashMap.keySet();
    }

    public Collection<? extends Map<KeyTwo, Value>> getInnerMaps() {
        return this.k1ToHashMap.values();
    }
}

