/*********************************************************************
 * Copyright (c) 2023 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/
package org.eclipse.osee.orcs.rest.model.transaction;

/**
 * @author David W. Miller
 * @author autogenerated by jsonschema2pojo
 */
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({"id", "typeName", "name", "applicabilityId", "typeId", "attributes", "relations"})
public class CreateArtifact {

   @JsonProperty("id")
   private String id;
   @JsonProperty("typeName")
   private String typeName;
   @JsonProperty("name")
   private String name;
   @JsonProperty("applicabilityId")
   private String applicabilityId;
   @JsonProperty("typeId")
   private String typeId;
   @JsonProperty("attributes")
   private List<Attribute> attributes;
   @JsonProperty("relations")
   private List<Relation> relations;
   @JsonIgnore
   private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

   @JsonProperty("id")
   public String getId() {
      return id;
   }

   @JsonProperty("id")
   public void setId(String id) {
      this.id = id;
   }

   @JsonProperty("typeName")
   public String getTypeName() {
      return typeName;
   }

   @JsonProperty("typeName")
   public void setTypeName(String typeName) {
      this.typeName = typeName;
   }

   @JsonProperty("name")
   public String getName() {
      return name;
   }

   @JsonProperty("name")
   public void setName(String name) {
      this.name = name;
   }

   @JsonProperty("applicabilityId")
   public String getApplicabilityId() {
      return applicabilityId;
   }

   @JsonProperty("applicabilityId")
   public void setApplicabilityId(String applicabilityId) {
      this.applicabilityId = applicabilityId;
   }

   @JsonProperty("typeId")
   public String getTypeId() {
      return typeId;
   }

   @JsonProperty("typeId")
   public void setTypeId(String typeId) {
      this.typeId = typeId;
   }

   @JsonProperty("attributes")
   public List<Attribute> getAttributes() {
      return attributes;
   }

   @JsonProperty("attributes")
   public void setAttributes(List<Attribute> attributes) {
      this.attributes = attributes;
   }

   @JsonProperty("relations")
   public List<Relation> getRelations() {
      return relations;
   }

   @JsonProperty("relations")
   public void setRelations(List<Relation> relations) {
      this.relations = relations;
   }

   @JsonAnyGetter
   public Map<String, Object> getAdditionalProperties() {
      return this.additionalProperties;
   }

   @JsonAnySetter
   public void setAdditionalProperty(String name, Object value) {
      this.additionalProperties.put(name, value);
   }

}
