/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.jdk.core.util.DoubleMap;

public class DoubleHashMap<Kp, Ks, V>
implements DoubleMap<Kp, Ks, V> {
    static final int defaultInitialCapacity = 16;
    static final float defaultLoadFactor = 0.75f;
    private final HashMap<Kp, Map<Ks, V>> primaryMap;
    private final int secondaryInitialCapacity;
    private final float secondaryLoadFactor;

    public DoubleHashMap() {
        this.primaryMap = new HashMap(16, 0.75f);
        this.secondaryInitialCapacity = 16;
        this.secondaryLoadFactor = 0.75f;
    }

    public DoubleHashMap(int initialCapacity, float loadFactor) {
        this.primaryMap = new HashMap(initialCapacity, loadFactor);
        this.secondaryInitialCapacity = initialCapacity;
        this.secondaryLoadFactor = loadFactor;
    }

    public DoubleHashMap(int primaryInitialCapacity, float primaryLoadFactor, int secondaryInitialCapacity, float secondaryLoadFactor) {
        this.primaryMap = new HashMap(primaryInitialCapacity, primaryLoadFactor);
        this.secondaryInitialCapacity = secondaryInitialCapacity;
        this.secondaryLoadFactor = secondaryLoadFactor;
    }

    @Override
    public boolean containsKey(Kp primaryKey) {
        return this.primaryMap.containsKey(primaryKey);
    }

    @Override
    public boolean containsKey(Kp primaryKey, Ks secondaryKey) {
        Map<Ks, V> secondaryMap = this.primaryMap.get(primaryKey);
        return secondaryMap != null ? secondaryMap.containsKey(secondaryKey) : false;
    }

    @Override
    public Optional<V> get(Kp primaryKey, Ks secondaryKey) {
        Map<Ks, V> secondaryMap = this.primaryMap.get(primaryKey);
        return secondaryMap != null ? Optional.ofNullable(secondaryMap.get(secondaryKey)) : Optional.empty();
    }

    @Override
    public Optional<Map<Ks, V>> get(Kp primaryKey) {
        return Optional.ofNullable(this.primaryMap.get(primaryKey));
    }

    @Override
    public Set<Kp> keySet() {
        return this.primaryMap.keySet();
    }

    @Override
    public Optional<Set<Ks>> keySet(Kp primaryKey) {
        Map<Ks, V> secondaryMap = this.primaryMap.get(primaryKey);
        return secondaryMap != null ? Optional.of(secondaryMap.keySet()) : Optional.empty();
    }

    @Override
    public Optional<V> put(Kp primaryKey, Ks secondaryKey, V value) {
        Map<Ks, V> secondaryMap = this.primaryMap.get(primaryKey);
        if (secondaryMap == null) {
            secondaryMap = new HashMap<Ks, V>(this.secondaryInitialCapacity, this.secondaryLoadFactor);
            this.primaryMap.put(primaryKey, secondaryMap);
            secondaryMap.put(secondaryKey, value);
            return Optional.empty();
        }
        V priorValue = secondaryMap.put(secondaryKey, value);
        return Optional.ofNullable(priorValue);
    }

    @Override
    public int size() {
        return this.primaryMap.values().stream().collect(Collectors.summingInt(Map::size));
    }

    @Override
    public Optional<Integer> size(Kp primaryKey) {
        Map<Ks, V> secondaryMap = this.primaryMap.get(primaryKey);
        return secondaryMap != null ? Optional.of(secondaryMap.size()) : Optional.empty();
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){
            Iterator<Map<Ks, V>> primaryIterator;
            Iterator<V> secondaryIterator;
            {
                this.primaryIterator = DoubleHashMap.this.primaryMap.values().iterator();
                this.secondaryIterator = this.primaryIterator.hasNext() ? this.primaryIterator.next().values().iterator() : null;
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        if (secondaryIterator == null) {
                            return false;
                        }
                        if (secondaryIterator.hasNext()) {
                            return true;
                        }
                        if (primaryIterator.hasNext()) {
                            secondaryIterator = primaryIterator.next().values().iterator();
                            return this.hasNext();
                        }
                        secondaryIterator = null;
                        return false;
                    }

                    @Override
                    public V next() {
                        if (secondaryIterator == null) {
                            throw new NoSuchElementException();
                        }
                        return secondaryIterator.next();
                    }
                };
            }

            @Override
            public int size() {
                return DoubleHashMap.this.size();
            }
        };
    }

    @Override
    public Optional<Collection<V>> values(Kp primaryKey) {
        Map<Ks, V> secondaryMap = this.primaryMap.get(primaryKey);
        return secondaryMap != null ? Optional.of(secondaryMap.values()) : Optional.empty();
    }
}

