/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.notify.AtsNotificationCollector;
import org.eclipse.osee.ats.api.notify.AtsNotificationEvent;
import org.eclipse.osee.ats.api.notify.AtsWorkItemNotificationEvent;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IExecuteListener;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsRelationChange;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public abstract class AbstractAtsChangeSet
implements IAtsChangeSet {
    protected String comment;
    protected final Set<AtsRelationChange> relations = new CopyOnWriteArraySet<AtsRelationChange>();
    protected final Set<IAtsObject> atsObjects = new CopyOnWriteArraySet<IAtsObject>();
    protected final Set<ArtifactId> artifacts = new CopyOnWriteArraySet<ArtifactId>();
    protected final Set<IAtsObject> deleteAtsObjects = new CopyOnWriteArraySet<IAtsObject>();
    protected final Set<ArtifactId> deleteArtifacts = new CopyOnWriteArraySet<ArtifactId>();
    protected final Set<IExecuteListener> listeners = new CopyOnWriteArraySet<IExecuteListener>();
    protected final AtsUser asUser;
    protected final AtsNotificationCollector notifications = new AtsNotificationCollector();
    protected final List<IAtsWorkItem> workItemsCreated = new ArrayList<IAtsWorkItem>();
    protected boolean execptionIfEmpty = true;
    protected BranchToken branch;
    protected Set<ArtifactId> ids = new HashSet<ArtifactId>();
    protected Map<String, String> seqNameToStartNum = new HashMap<String, String>();

    public AbstractAtsChangeSet(String comment, BranchToken branch, AtsUser asUser) {
        this.comment = comment;
        this.branch = branch;
        this.asUser = asUser;
        Conditions.checkNotNullOrEmpty((String)comment, (String)"comment");
        Conditions.checkNotNull((Object)branch, (String)"branch");
        Conditions.checkNotNull((Object)asUser, (String)"user");
        Conditions.assertTrue((boolean)branch.isValid(), (String)"%s is not a valid branch", (Object[])new Object[]{branch});
    }

    public Set<ArtifactId> getIds() {
        return this.ids;
    }

    public void add(Object obj) {
        Conditions.checkNotNull((Object)obj, (String)"object");
        if (obj instanceof Collection) {
            for (Object object : (Collection)obj) {
                this.add(object);
            }
        } else if (obj instanceof IAtsObject) {
            IAtsObject atsObj = (IAtsObject)obj;
            if (atsObj.getStoreObject() != null && !atsObj.getStoreObject().getBranch().equals(this.branch)) {
                throw new OseeArgumentException("Can't add %s from branch %s to conflicting branch %s in same transaction", new Object[]{atsObj.toStringWithId(), atsObj.getStoreObject().getBranchIdString(), this.branch.getIdString()});
            }
            this.atsObjects.add((IAtsObject)obj);
            this.ids.add(((IAtsObject)obj).getArtifactId());
        } else if (obj instanceof ArtifactToken) {
            ArtifactToken artTok = (ArtifactToken)obj;
            if (!artTok.getBranch().equals(this.branch)) {
                throw new OseeArgumentException("Can't add %s from branch %s to conflicting branch %s in same transaction", new Object[]{artTok.toStringWithId(), artTok.getBranchIdString(), this.branch.getIdString()});
            }
            this.artifacts.add((ArtifactId)((ArtifactToken)obj));
            this.ids.add((ArtifactId)((ArtifactToken)obj));
        } else if (obj instanceof ArtifactId) {
            this.artifacts.add((ArtifactId)obj);
            this.ids.add((ArtifactId)obj);
        } else if (obj instanceof AtsRelationChange) {
            AtsRelationChange relation = (AtsRelationChange)obj;
            this.relations.add(relation);
            for (Object ob : relation.getObjects()) {
                this.add(ob);
            }
        } else {
            throw new OseeArgumentException("Object not supported: " + obj, new Object[0]);
        }
    }

    public void addAll(Object ... objects) {
        Conditions.checkNotNull((Object)objects, (String)"objects");
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.add(obj);
            ++n2;
        }
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void clear() {
        this.relations.clear();
        this.atsObjects.clear();
        this.artifacts.clear();
        this.deleteArtifacts.clear();
        this.deleteAtsObjects.clear();
        this.listeners.clear();
        this.seqNameToStartNum.clear();
    }

    public void reset(String comment) {
        this.clear();
        this.comment = comment;
    }

    public boolean isEmpty() {
        return this.artifacts.isEmpty() && this.deleteArtifacts.isEmpty() && this.atsObjects.isEmpty() && this.deleteAtsObjects.isEmpty() && this.relations.isEmpty();
    }

    public void addExecuteListener(IExecuteListener listener) {
        Conditions.checkNotNull((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    public void addToDelete(Object obj) {
        Conditions.checkNotNull((Object)obj, (String)"object");
        if (obj instanceof Collection) {
            for (Object object : (Collection)obj) {
                this.add(object);
            }
        } else if (obj instanceof IAtsObject) {
            this.deleteAtsObjects.add((IAtsObject)obj);
        } else if (obj instanceof ArtifactId) {
            this.deleteArtifacts.add((ArtifactId)obj);
        } else {
            throw new OseeArgumentException("Object not supported: " + obj, new Object[0]);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public AtsNotificationCollector getNotifications() {
        return this.notifications;
    }

    public ArtifactToken createArtifact(ArtifactToken token) {
        ArtifactTypeToken typeToken = token.getArtifactType();
        if (typeToken.isInvalid()) {
            throw new OseeArgumentException("Artifact Type Token %s is invalid for artifact creation", new Object[]{typeToken.toStringWithId()});
        }
        return this.createArtifact(token.getArtifactType(), token.getName(), token.getId());
    }

    public void deleteArtifact(IAtsWorkItem task) {
        this.deleteArtifact((ArtifactId)task.getStoreObject());
    }

    public void addWorkflowCreated(IAtsTeamWorkflow teamWf) {
        this.workItemsCreated.add((IAtsWorkItem)teamWf);
    }

    public TransactionToken executeIfNeeded() {
        this.execptionIfEmpty = false;
        return this.execute();
    }

    public AtsUser getAsUser() {
        return this.asUser;
    }

    public void unrelate(IAtsObject atsObject, RelationTypeSide relationSide, IAtsObject atsObjec2) {
        this.unrelate((ArtifactId)atsObject.getStoreObject(), relationSide, (ArtifactId)atsObjec2.getStoreObject());
    }

    public void unrelate(ArtifactId artifact, RelationTypeSide relationSide, IAtsObject atsObject) {
        this.unrelate(artifact, relationSide, (ArtifactId)atsObject.getStoreObject());
    }

    public void unrelate(IAtsObject atsObject, RelationTypeSide relationSide, ArtifactId artifact) {
        this.unrelate((ArtifactId)atsObject.getStoreObject(), relationSide, artifact);
    }

    public void setSoleAttributeFromString(IAtsObject atsObject, AttributeTypeGeneric<?> attributeType, String value) {
        this.setSoleAttributeFromString((ArtifactId)atsObject.getStoreObject(), attributeType, value);
    }

    public void setRelation(Object object1, RelationTypeSide relationSide, Object object2) {
        this.setRelations(object1, relationSide, Collections.singleton(object2));
    }

    public void addChild(ArtifactId parent, ArtifactId child) {
        this.relate(parent, CoreRelationTypes.DefaultHierarchical_Child, child);
    }

    public void setName(ArtifactToken artifact, String name) {
        this.setSoleAttributeValue((ArtifactId)artifact, (AttributeTypeToken)CoreAttributeTypes.Name, name);
    }

    public void setName(IAtsObject atsObject, String name) {
        this.setSoleAttributeValue(atsObject, (AttributeTypeToken)CoreAttributeTypes.Name, name);
    }

    public void addWorkItemNotificationEvent(AtsWorkItemNotificationEvent workItemNotificationEvent) {
        this.notifications.getWorkItemNotificationEvents().add(workItemNotificationEvent);
    }

    public void addNotificationEvent(AtsNotificationEvent notifyEvent) {
        this.notifications.getNotificationEvents().add(notifyEvent);
    }

    public List<IAtsWorkItem> getWorkItemsCreated() {
        return this.workItemsCreated;
    }

    public void addChild(IAtsObject parent, IAtsObject child) {
        this.add(new AtsRelationChange(parent, CoreRelationTypes.DefaultHierarchical_Child, Collections.singleton(child), AtsRelationChange.RelationOperation.Add));
    }

    public ArtifactId getStoredArtifact(Id id) {
        for (ArtifactId art : this.artifacts) {
            if (!art.getId().equals(id.getId())) continue;
            return art;
        }
        return null;
    }

    public IAtsObject getStoredAtsObject(Id id) {
        for (IAtsObject obj : this.atsObjects) {
            if (!obj.equals(id)) continue;
            return obj;
        }
        return null;
    }

    public ArtifactToken createArtifact(ArtifactToken parent, ArtifactToken artifact) {
        ArtifactToken art = this.createArtifact(artifact);
        if (parent != null) {
            this.addChild((ArtifactId)parent, (ArtifactId)art);
        }
        return art;
    }

    public BranchId getBranch() {
        return this.branch;
    }

    public void addTag(IAtsObject atsObject, String tag) {
        if (atsObject.getTags() != null && !atsObject.getTags().contains(tag)) {
            this.addAttribute(atsObject, (AttributeTypeToken)CoreAttributeTypes.StaticId, tag);
        }
    }

    public void addAtsIdSequence(String seqName, String seqStart) {
        this.seqNameToStartNum.put(seqName, seqStart);
    }

    public void executeAfterSuccess(AtsApi atsApi) {
        for (Map.Entry<String, String> entry : this.seqNameToStartNum.entrySet()) {
            String query = String.format("INSERT INTO osee_sequence (last_sequence, sequence_name) VALUES (%s, '%s')", entry.getValue(), entry.getKey());
            atsApi.getQueryService().runUpdate(query, new Object[0]);
        }
    }
}

