/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.state;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workflow.WorkState;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.api.workflow.state.IAtsWorkStateFactory;
import org.eclipse.osee.ats.core.internal.state.StateManager;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IAttribute;

public class StateManagerWriter {
    private final IAttributeResolver attrResolver;
    private final IAtsWorkItem workItem;
    private final StateManager stateMgr;
    private final IAtsChangeSet changes;
    private final IAtsWorkStateFactory workStateFactory;

    public StateManagerWriter(IAtsWorkItem workItem, StateManager stateMgr, IAttributeResolver attrResolver, IAtsChangeSet changes, IAtsWorkStateFactory workStateFactory) {
        this.workItem = workItem;
        this.stateMgr = stateMgr;
        this.attrResolver = attrResolver;
        this.changes = changes;
        this.workStateFactory = workStateFactory;
    }

    public void writeToStore() {
        String currentStateName = this.stateMgr.getCurrentStateNameInternal();
        this.attrResolver.setSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateName, (Object)currentStateName, this.changes);
        ArrayList<String> assigneeIds = new ArrayList<String>();
        for (AtsUser user : this.stateMgr.getAssignees()) {
            assigneeIds.add(user.getIdString());
        }
        this.changes.setAttributeValues((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateAssignee, assigneeIds);
        this.attrResolver.setSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentState, (Object)this.workStateFactory.toStoreStr((IAtsStateManager)this.stateMgr, currentStateName), this.changes);
        this.removeCurrentStateAttributeIfExists(currentStateName, this.changes);
        this.writeStatesToStore(this.changes);
    }

    private void writeStatesToStore(IAtsChangeSet changes) {
        for (String stateName : this.stateMgr.getVisitedStateNames()) {
            boolean updated;
            if (stateName.equals(this.stateMgr.getCurrentStateNameInternal()) || (updated = this.updateStateAttributeIfExsists(stateName, changes))) continue;
            this.attrResolver.addAttribute(this.workItem, (AttributeTypeToken)AtsAttributeTypes.State, (Object)this.workStateFactory.toStoreStr(this.workItem.getStateMgr(), stateName), changes);
        }
    }

    private void removeCurrentStateAttributeIfExists(String stateName, IAtsChangeSet changes) {
        Collection attrs = this.attrResolver.getAttributes((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.State);
        for (IAttribute attr : attrs) {
            WorkState storedState = this.workStateFactory.fromStoreStr((String)attr.getValue());
            if (!stateName.equals(storedState.getName())) continue;
            this.attrResolver.deleteAttribute(this.workItem, attr, changes);
        }
    }

    private boolean updateStateAttributeIfExsists(String stateName, IAtsChangeSet changes) {
        Collection attrs = this.attrResolver.getAttributes((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.State);
        for (IAttribute attr : attrs) {
            WorkState storedState = this.workStateFactory.fromStoreStr((String)attr.getValue());
            if (!stateName.equals(storedState.getName())) continue;
            this.attrResolver.setValue(this.workItem, attr, (AttributeTypeId)AtsAttributeTypes.State, (Object)this.workStateFactory.toStoreStr(this.workItem.getStateMgr(), stateName), changes);
            return true;
        }
        return false;
    }
}

