/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.event.IAtsEventService;
import org.eclipse.osee.ats.api.event.IAtsWorkItemTopicEventListener;
import org.eclipse.osee.ats.api.util.AtsTopicEvent;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLog;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public abstract class AbstractAtsEventServiceImpl
implements IAtsEventService,
EventHandler {
    private EventAdmin eventAdmin;
    private final HashCollection<String, IAtsWorkItemTopicEventListener> workItemEventListeners = new HashCollection();

    public EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void postEvent(Event event) {
        this.eventAdmin.postEvent(event);
    }

    public void sendEvent(Event event) {
        this.eventAdmin.sendEvent(event);
    }

    public void postAtsWorkItemTopicEvent(AtsTopicEvent event, Collection<IAtsWorkItem> workItems, TransactionId transaction) {
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            String idsString = AtsObjects.toIdsString(";", workItems);
            properties.put("workItemIds", idsString);
            if (transaction != null && transaction.isValid()) {
                properties.put("transactionId", transaction.getIdString());
            }
            Event osgiEvent = new Event(event.getTopic(), properties);
            this.eventAdmin.postEvent(osgiEvent);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(this.getClass(), (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public void registerAtsWorkItemTopicEvent(IAtsWorkItemTopicEventListener listener, AtsTopicEvent ... events) {
        AtsTopicEvent[] atsTopicEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            AtsTopicEvent event = atsTopicEventArray[n2];
            this.workItemEventListeners.put((Object)event.getTopic(), (Object)listener);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deRegisterAtsWorkItemTopicEvent(IAtsWorkItemTopicEventListener listener) {
        HashSet<String> toRemove = new HashSet<String>();
        Set entrySet = this.workItemEventListeners.entrySet();
        for (Map.Entry entry : entrySet) {
            List listeners = (List)entry.getValue();
            if (!listeners.contains(listener)) continue;
            toRemove.add((String)entry.getKey());
        }
        HashCollection<String, IAtsWorkItemTopicEventListener> hashCollection = this.workItemEventListeners;
        synchronized (hashCollection) {
            for (String key : toRemove) {
                this.workItemEventListeners.removeValue((Object)key, (Object)listener);
            }
        }
    }

    public void handleEvent(Event event) {
        try {
            List listeners;
            String topic = event.getTopic();
            AtsTopicEvent topicEvent = AtsTopicEvent.get((String)topic);
            if (topicEvent != null && (listeners = (List)this.workItemEventListeners.getValues((Object)topic)) != null && !listeners.isEmpty()) {
                List<ArtifactId> workItemArtIds = this.getWorkItemArtIds(event);
                this.reloadWorkItemsAsNecessry(workItemArtIds, event);
                for (IAtsWorkItemTopicEventListener listener : listeners) {
                    try {
                        if (listener.isDisposed()) continue;
                        listener.handleEvent(topicEvent, workItemArtIds);
                    }
                    catch (Exception ex) {
                        OseeLog.logf(this.getClass(), (Level)Level.SEVERE, (Throwable)ex, (String)"Error processing work item transition event handler for - %s", (Object[])new Object[]{listener});
                    }
                }
            }
        }
        catch (Exception exception) {}
    }

    protected void reloadWorkItemsAsNecessry(Collection<ArtifactId> ids, Event event) {
    }

    private List<ArtifactId> getWorkItemArtIds(Event event) {
        String ids = (String)event.getProperty("workItemIds");
        ArrayList<ArtifactId> workItemArtIds = new ArrayList<ArtifactId>();
        for (Long workItemId : Collections.fromString((String)ids, (String)";", Long::valueOf)) {
            ArtifactId workItemArtId = ArtifactId.valueOf((Long)workItemId);
            workItemArtIds.add(workItemArtId);
        }
        return workItemArtIds;
    }
}

