/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile.operations;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.agile.AgileReportType;
import org.eclipse.osee.ats.api.agile.AgileSprintData;
import org.eclipse.osee.ats.api.agile.AgileSprintDateData;
import org.eclipse.osee.ats.api.agile.IAgileSprintHtmlOperation;
import org.eclipse.osee.ats.core.agile.SprintUtil;
import org.eclipse.osee.ats.core.util.chart.LineChart;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;

public class SprintBurnupOperations
implements IAgileSprintHtmlOperation {
    private final AtsApi atsApi;

    public SprintBurnupOperations(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public String getReportHtml(long teamId, long sprintId) {
        try {
            LineChart chart = this.getChartData(teamId, sprintId);
            if (chart.getResults().isErrors()) {
                return AHTML.simplePage((String)chart.getResults().toString().replaceAll("\n", "<br/>"));
            }
            return chart.getChart();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public LineChart getChartData(long teamId, long sprintId) {
        LineChart chart = new LineChart(this.atsApi);
        ArtifactToken team = this.atsApi.getQueryService().getArtifact(Long.valueOf(teamId));
        AgileSprintData data = SprintUtil.getAgileSprintData(this.atsApi, teamId, sprintId, chart.getResults());
        XResultData results = data.validate();
        if (results.isErrors()) {
            return chart;
        }
        try {
            chart.setTitle(String.valueOf(team.getName()) + " - " + data.getSprintName() + " - Burnup");
            chart.setyAxisLabel("Points");
            chart.setxAxisLabel("Dates");
            LinkedList<String> xDateList = new LinkedList<String>();
            for (AgileSprintDateData date : data.getDates()) {
                xDateList.add("\"" + DateUtil.getMMDDYY((Date)date.getDate()) + "\"");
            }
            chart.setxAxisLabels(xDateList);
            boolean hasUnplanned = data.getUnPlannedPoints() > 0;
            Date today = new Date();
            ArrayList<Double> totals = new ArrayList<Double>();
            for (AgileSprintDateData date : data.getDates()) {
                if (!today.after(date.getDate())) continue;
                totals.add(date.getTotalRealizedPoints());
            }
            chart.addLine(hasUnplanned ? "Total Realized Points" : "Total Points", totals, SprintUtil.RGB_BLACK);
            ArrayList<Double> values = new ArrayList<Double>();
            for (AgileSprintDateData date : data.getDates()) {
                if (!today.after(date.getDate())) continue;
                Double completed = date.getCompletedPlannedPoints() + date.getCompletedUnPlannedPoints();
                values.add(Double.valueOf(completed.intValue()));
            }
            chart.addLine("Total Completed", values, SprintUtil.RGB_GREEN);
            if (hasUnplanned) {
                ArrayList<Double> values2 = new ArrayList<Double>();
                for (AgileSprintDateData date : data.getDates()) {
                    if (!today.after(date.getDate())) continue;
                    Double completed = date.getCompletedPlannedPoints();
                    values2.add(Double.valueOf(completed.intValue()));
                }
                chart.addLine("Completed Planned", values2, SprintUtil.RGB_BLUE);
                ArrayList<Double> values1 = new ArrayList<Double>();
                for (AgileSprintDateData date : data.getDates()) {
                    if (!today.after(date.getDate())) continue;
                    Double completedUnPlanned = date.getCompletedUnPlannedPoints();
                    values1.add(Double.valueOf(completedUnPlanned.intValue()));
                }
                chart.addLine("Completed Un-Planned", values1, SprintUtil.RGB_YELLOW);
            }
            return chart;
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex, "Can't return LineChart", new Object[0]);
        }
    }

    public AgileReportType getReportType() {
        return AgileReportType.Burn_Up;
    }
}

